/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testcase.factories;

import java.util.ArrayList;
import java.util.List;
import org.evosuite.Properties;
import org.evosuite.coverage.branch.BranchCoverageSuiteFitness;
import org.evosuite.ga.ChromosomeFactory;
import org.evosuite.rmi.ClientServices;
import org.evosuite.rmi.service.ClientNodeLocal;
import org.evosuite.statistics.RuntimeVariable;
import org.evosuite.testcarver.extraction.CarvingManager;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.TestChromosome;
import org.evosuite.testsuite.TestSuiteChromosome;
import org.evosuite.utils.LoggingUtils;
import org.evosuite.utils.Randomness;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JUnitTestCarvedChromosomeFactory
implements ChromosomeFactory<TestChromosome> {
    private static final long serialVersionUID = -569338946355072318L;
    private static final Logger logger = LoggerFactory.getLogger(JUnitTestCarvedChromosomeFactory.class);
    private final List<TestCase> junitTests = new ArrayList<TestCase>();
    private final ChromosomeFactory<TestChromosome> defaultFactory;
    private static int totalNumberOfTestsCarved = 0;
    private static double carvedCoverage = 0.0;

    public JUnitTestCarvedChromosomeFactory(ChromosomeFactory<TestChromosome> defaultFactory) throws IllegalStateException {
        this.defaultFactory = defaultFactory;
        this.readTestCases();
    }

    private void readTestCases() throws IllegalStateException {
        CarvingManager manager = CarvingManager.getInstance();
        List<TestCase> tests = manager.getTestsForClass(Properties.getTargetClass());
        this.junitTests.addAll(tests);
        if (this.junitTests.size() > 0) {
            totalNumberOfTestsCarved = this.junitTests.size();
            LoggingUtils.getEvoLogger().info("* Using {} carved tests from existing JUnit tests for seeding", (Object)this.junitTests.size());
            if (logger.isDebugEnabled()) {
                for (TestCase test : this.junitTests) {
                    logger.debug("Carved Test: {}", (Object)test.toCode());
                }
            }
            BranchCoverageSuiteFitness f = new BranchCoverageSuiteFitness();
            TestSuiteChromosome suite = new TestSuiteChromosome();
            for (TestCase test : this.junitTests) {
                suite.addTest(test);
            }
            f.getFitness(suite);
            carvedCoverage = suite.getCoverage();
        }
        ClientNodeLocal client = ClientServices.getInstance().getClientNode();
        client.trackOutputVariable(RuntimeVariable.CarvedTests, totalNumberOfTestsCarved);
        client.trackOutputVariable(RuntimeVariable.CarvedCoverage, carvedCoverage);
    }

    public boolean hasCarvedTestCases() {
        return this.junitTests.size() > 0;
    }

    public int getNumCarvedTestCases() {
        return this.junitTests.size();
    }

    @Override
    public TestChromosome getChromosome() {
        int N_mutations = Properties.SEED_MUTATIONS;
        double P_clone = Properties.SEED_CLONE;
        double r = Randomness.nextDouble();
        if (r >= P_clone || this.junitTests.isEmpty()) {
            logger.debug("Using random test");
            return this.defaultFactory.getChromosome();
        }
        logger.info("Cloning user test");
        TestCase test = Randomness.choice(this.junitTests);
        TestChromosome chromosome = new TestChromosome();
        chromosome.setTestCase(test.clone());
        if (N_mutations > 0) {
            int numMutations = Randomness.nextInt(N_mutations);
            logger.debug("Mutations: " + numMutations);
            for (int i = 0; i < numMutations; ++i) {
                chromosome.mutate();
            }
        }
        return chromosome;
    }

    public static int getTotalNumberOfTestsCarved() {
        return totalNumberOfTestsCarved;
    }

    public static double getCoverageOfCarvedTests() {
        return carvedCoverage;
    }
}

