/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testcase.factories;

import org.evosuite.Properties;
import org.evosuite.ga.ChromosomeFactory;
import org.evosuite.testcase.DefaultTestCase;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.TestChromosome;
import org.evosuite.testcase.TestFactory;
import org.evosuite.testcase.execution.ExecutionTracer;
import org.evosuite.testcase.factories.FixedLengthTestChromosomeFactory;
import org.evosuite.utils.Randomness;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RandomLengthTestFactory
implements ChromosomeFactory<TestChromosome> {
    private static final long serialVersionUID = -5202578461625984100L;
    protected static final Logger logger = LoggerFactory.getLogger(FixedLengthTestChromosomeFactory.class);

    private TestCase getRandomTestCase(int size) {
        boolean tracerEnabled = ExecutionTracer.isEnabled();
        if (tracerEnabled) {
            ExecutionTracer.disable();
        }
        TestCase test = this.getNewTestCase();
        int num = 0;
        int length = Randomness.nextInt(size);
        while (length == 0) {
            length = Randomness.nextInt(size);
        }
        TestFactory testFactory = TestFactory.getInstance();
        while (test.size() < length && num < Properties.MAX_ATTEMPTS) {
            testFactory.insertRandomStatement(test, test.size());
            ++num;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Randomized test case:" + test.toCode());
        }
        if (tracerEnabled) {
            ExecutionTracer.enable();
        }
        return test;
    }

    @Override
    public TestChromosome getChromosome() {
        TestChromosome c = new TestChromosome();
        c.setTestCase(this.getRandomTestCase(Properties.CHROMOSOME_LENGTH));
        return c;
    }

    protected TestCase getNewTestCase() {
        return new DefaultTestCase();
    }
}

