/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testcase.localsearch;

import org.evosuite.ga.localsearch.LocalSearchObjective;
import org.evosuite.testcase.TestChromosome;
import org.evosuite.testcase.execution.ExecutionResult;
import org.evosuite.testcase.localsearch.StatementLocalSearch;
import org.evosuite.testcase.localsearch.TestCaseLocalSearch;
import org.evosuite.testcase.statements.numeric.NumericalPrimitiveStatement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IntegerLocalSearch<T>
extends StatementLocalSearch {
    private static final Logger logger = LoggerFactory.getLogger(TestCaseLocalSearch.class);
    private T oldValue;

    @Override
    public boolean doSearch(TestChromosome test, int statement, LocalSearchObjective<TestChromosome> objective) {
        boolean improved = false;
        NumericalPrimitiveStatement p = (NumericalPrimitiveStatement)test.getTestCase().getStatement(statement);
        ExecutionResult oldResult = test.getLastExecutionResult();
        this.oldValue = p.getValue();
        logger.info("Applying search to: " + p.getCode());
        boolean done = false;
        while (!done) {
            done = true;
            p.increment(1L);
            logger.info("Trying increment of " + p.getCode());
            if (objective.hasImproved(test)) {
                done = false;
                improved = true;
                this.iterate(2L, objective, test, p, statement);
                this.oldValue = p.getValue();
                oldResult = test.getLastExecutionResult();
                continue;
            }
            p.setValue(this.oldValue);
            test.setLastExecutionResult(oldResult);
            test.setChanged(false);
            p.increment(-1L);
            logger.info("Trying decrement of " + p.getCode());
            if (objective.hasImproved(test)) {
                done = false;
                this.iterate(-2L, objective, test, p, statement);
                this.oldValue = p.getValue();
                oldResult = test.getLastExecutionResult();
                continue;
            }
            p.setValue(this.oldValue);
            test.setLastExecutionResult(oldResult);
            test.setChanged(false);
        }
        logger.info("Finished local search with result " + p.getCode());
        return improved;
    }

    private boolean iterate(long delta, LocalSearchObjective<TestChromosome> objective, TestChromosome test, NumericalPrimitiveStatement<T> p, int statement) {
        boolean improvement = false;
        Object oldValue = p.getValue();
        ExecutionResult oldResult = test.getLastExecutionResult();
        p.increment(delta);
        logger.info("Trying increment " + delta + " of " + p.getCode());
        while (objective.hasImproved(test)) {
            oldValue = p.getValue();
            oldResult = test.getLastExecutionResult();
            improvement = true;
            delta = 2L * delta;
            p.increment(delta);
            logger.info("Trying increment " + delta + " of " + p.getCode());
        }
        logger.info("No improvement on " + p.getCode());
        p.setValue(oldValue);
        test.setLastExecutionResult(oldResult);
        test.setChanged(false);
        logger.info("Final value of this iteration: " + p.getValue());
        return improvement;
    }
}

