/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testcase.localsearch;

import java.util.HashSet;
import org.evosuite.Properties;
import org.evosuite.ga.localsearch.LocalSearchBudget;
import org.evosuite.ga.localsearch.LocalSearchObjective;
import org.evosuite.ga.operators.mutation.MutationHistory;
import org.evosuite.testcase.TestChromosome;
import org.evosuite.testcase.TestMutationHistoryEntry;
import org.evosuite.testcase.localsearch.DSELocalSearch;
import org.evosuite.testcase.localsearch.StatementLocalSearch;
import org.evosuite.testcase.localsearch.TestCaseLocalSearch;
import org.evosuite.utils.Randomness;

public class SelectiveTestCaseLocalSearch
extends TestCaseLocalSearch {
    @Override
    public boolean doSearch(TestChromosome individual, LocalSearchObjective<TestChromosome> objective) {
        Integer lastPos;
        double oldFitness = individual.getFitness();
        logger.info("Applying local search on test case");
        int lastPosition = individual.size() - 1;
        if (individual.getLastExecutionResult() != null && !individual.isChanged() && (lastPos = individual.getLastExecutionResult().getFirstPositionOfThrownException()) != null) {
            lastPosition = lastPos;
        }
        HashSet<Integer> targetPositions = new HashSet<Integer>();
        logger.info("Mutation history: " + individual.getMutationHistory().toString());
        logger.info("Checking {} mutations", (Object)individual.getMutationHistory().size());
        MutationHistory<TestMutationHistoryEntry> history = new MutationHistory<TestMutationHistoryEntry>();
        history.set(individual.getMutationHistory());
        boolean useDSE = Properties.LOCAL_SEARCH_DSE == Properties.DSEType.TEST && Randomness.nextDouble() < Properties.DSE_PROBABILITY;
        for (TestMutationHistoryEntry mutation : individual.getMutationHistory()) {
            if (LocalSearchBudget.getInstance().isFinished()) break;
            if (!individual.getTestCase().contains(mutation.getStatement())) continue;
            if (mutation.getMutationType() != TestMutationHistoryEntry.TestMutation.DELETION && mutation.getStatement().getPosition() <= lastPosition) {
                logger.info("Found suitable mutation: " + mutation);
                if (!individual.getTestCase().hasReferences(mutation.getStatement().getReturnValue()) && !mutation.getStatement().getReturnClass().equals(Properties.getTargetClass())) {
                    logger.info("Return value of statement  is not referenced and not SUT, not doing local search");
                    continue;
                }
                if (useDSE) {
                    targetPositions.add(mutation.getStatement().getPosition());
                    continue;
                }
                StatementLocalSearch search = StatementLocalSearch.getLocalSearchFor(mutation.getStatement());
                if (search == null) continue;
                search.doSearch(individual, mutation.getStatement().getPosition(), objective);
                continue;
            }
            logger.info("Unsuitable mutation");
        }
        if (!targetPositions.isEmpty()) {
            logger.info("Yes, now applying the search at positions {}!", targetPositions);
            DSELocalSearch dse = new DSELocalSearch();
            boolean dseWasSuccessfull = dse.doSearch(individual, targetPositions, objective);
        }
        individual.getMutationHistory().clear();
        LocalSearchBudget.getInstance().countLocalSearchOnTest();
        assert (individual.getFitness() <= oldFitness);
        return objective.getFitnessFunction().isMaximizationFunction() ? oldFitness < individual.getFitness() : oldFitness > individual.getFitness();
    }
}

