/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testcase.localsearch;

import java.util.Set;
import org.evosuite.Properties;
import org.evosuite.ga.localsearch.LocalSearchObjective;
import org.evosuite.testcase.TestChromosome;
import org.evosuite.testcase.localsearch.ArrayLocalSearch;
import org.evosuite.testcase.localsearch.BooleanLocalSearch;
import org.evosuite.testcase.localsearch.DSELocalSearch;
import org.evosuite.testcase.localsearch.EnumLocalSearch;
import org.evosuite.testcase.localsearch.FloatLocalSearch;
import org.evosuite.testcase.localsearch.IntegerLocalSearch;
import org.evosuite.testcase.localsearch.ReferenceLocalSearch;
import org.evosuite.testcase.localsearch.StringLocalSearch;
import org.evosuite.testcase.statements.ArrayStatement;
import org.evosuite.testcase.statements.ConstructorStatement;
import org.evosuite.testcase.statements.EnumPrimitiveStatement;
import org.evosuite.testcase.statements.FieldStatement;
import org.evosuite.testcase.statements.MethodStatement;
import org.evosuite.testcase.statements.NullStatement;
import org.evosuite.testcase.statements.PrimitiveStatement;
import org.evosuite.testcase.statements.Statement;
import org.evosuite.utils.Randomness;

public abstract class StatementLocalSearch {
    private TestChromosome backup = null;

    protected void backup(TestChromosome test) {
        this.backup = (TestChromosome)test.clone();
    }

    protected void restore(TestChromosome test) {
        if (this.backup == null) {
            return;
        }
        test.setTestCase(this.backup.getTestCase().clone());
        test.copyCachedResults(this.backup);
        test.setFitnesses(this.backup.getFitnesses());
        test.setLastFitnesses(this.backup.getLastFitnesses());
        test.setChanged(this.backup.isChanged());
    }

    public abstract boolean doSearch(TestChromosome var1, int var2, LocalSearchObjective<TestChromosome> var3);

    public boolean doSearch(TestChromosome test, Set<Integer> statements, LocalSearchObjective<TestChromosome> objective) {
        boolean success = false;
        for (Integer statement : statements) {
            if (!this.doSearch(test, statement, objective)) continue;
            success = true;
        }
        return success;
    }

    public int getPositionDelta() {
        return 0;
    }

    public static StatementLocalSearch getLocalSearchFor(Statement statement) {
        boolean useDSE;
        boolean bl = useDSE = Properties.LOCAL_SEARCH_DSE == Properties.DSEType.STATEMENT && Randomness.nextDouble() < Properties.DSE_PROBABILITY;
        if (useDSE) {
            if (statement instanceof PrimitiveStatement) {
                return new DSELocalSearch();
            }
            return null;
        }
        StatementLocalSearch search = null;
        if (statement instanceof NullStatement) {
            if (!Properties.LOCAL_SEARCH_REFERENCES) {
                return null;
            }
            search = new ReferenceLocalSearch();
        } else if (statement instanceof PrimitiveStatement) {
            Class<?> type = statement.getReturnValue().getVariableClass();
            if (type.equals(String.class)) {
                if (Properties.LOCAL_SEARCH_STRINGS) {
                    search = new StringLocalSearch();
                }
            } else {
                if (!Properties.LOCAL_SEARCH_PRIMITIVES) {
                    return null;
                }
                if (type.equals(Integer.class) || type.equals(Integer.TYPE)) {
                    search = new IntegerLocalSearch();
                } else if (type.equals(Byte.class) || type.equals(Byte.TYPE)) {
                    search = new IntegerLocalSearch();
                } else if (type.equals(Short.class) || type.equals(Short.TYPE)) {
                    search = new IntegerLocalSearch();
                } else if (type.equals(Long.class) || type.equals(Long.TYPE)) {
                    search = new IntegerLocalSearch();
                } else if (type.equals(Character.class) || type.equals(Character.TYPE)) {
                    search = new IntegerLocalSearch();
                } else if (type.equals(Float.class) || type.equals(Float.TYPE)) {
                    search = new FloatLocalSearch();
                } else if (type.equals(Double.class) || type.equals(Double.TYPE)) {
                    search = new FloatLocalSearch();
                } else if (type.equals(Boolean.class)) {
                    search = new BooleanLocalSearch();
                } else if (statement instanceof EnumPrimitiveStatement) {
                    search = new EnumLocalSearch();
                }
            }
        } else if (statement instanceof ArrayStatement) {
            if (!Properties.LOCAL_SEARCH_ARRAYS) {
                return null;
            }
            search = new ArrayLocalSearch();
        } else if (statement instanceof MethodStatement) {
            if (!Properties.LOCAL_SEARCH_REFERENCES) {
                return null;
            }
            search = new ReferenceLocalSearch();
        } else if (statement instanceof ConstructorStatement) {
            if (!Properties.LOCAL_SEARCH_REFERENCES) {
                return null;
            }
            search = new ReferenceLocalSearch();
        } else if (statement instanceof FieldStatement) {
            if (!Properties.LOCAL_SEARCH_REFERENCES) {
                return null;
            }
            search = new ReferenceLocalSearch();
        }
        return search;
    }
}

