/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testcase.statements;

import java.io.PrintStream;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.evosuite.Properties;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.TestFactory;
import org.evosuite.testcase.execution.CodeUnderTestException;
import org.evosuite.testcase.execution.Scope;
import org.evosuite.testcase.statements.AbstractStatement;
import org.evosuite.testcase.statements.Statement;
import org.evosuite.testcase.variable.ArrayIndex;
import org.evosuite.testcase.variable.ArrayReference;
import org.evosuite.testcase.variable.FieldReference;
import org.evosuite.testcase.variable.VariableReference;
import org.evosuite.utils.GenericAccessibleObject;
import org.evosuite.utils.GenericClass;
import org.evosuite.utils.LoggingUtils;
import org.evosuite.utils.Randomness;
import org.objectweb.asm.commons.GeneratorAdapter;

public class ArrayStatement
extends AbstractStatement {
    private static final long serialVersionUID = -2858236370873914156L;
    private int[] lengths;

    private static int[] createRandom(int dimensions) {
        int[] result = new int[dimensions];
        for (int idx = 0; idx < dimensions; ++idx) {
            result[idx] = Randomness.nextInt(Properties.MAX_ARRAY) + 1;
        }
        return result;
    }

    public static int determineDimensions(Type type) {
        String name = type.toString().replace("class", "").trim();
        int count = 0;
        for (int i = 0; i < name.length(); ++i) {
            if (name.charAt(i) != '[') continue;
            ++count;
        }
        return count;
    }

    public ArrayStatement(TestCase tc, ArrayReference arrayReference) {
        this(tc, arrayReference, ArrayStatement.createRandom(ArrayStatement.determineDimensions(arrayReference.getType())));
    }

    public ArrayStatement(TestCase tc, ArrayReference arrayReference, int[] length) {
        super(tc, arrayReference);
        this.setLengths(length);
        arrayReference.setLengths(this.lengths);
    }

    public ArrayStatement(TestCase tc, Type type) {
        this(tc, type, ArrayStatement.createRandom(ArrayStatement.determineDimensions(type)));
    }

    public ArrayStatement(TestCase tc, Type type, int length) {
        this(tc, type, new int[]{length});
    }

    public ArrayStatement(TestCase tc, Type type, int[] length) {
        this(tc, new ArrayReference(tc, new GenericClass(type), length), length);
    }

    @Override
    public Statement copy(TestCase newTestCase, int offset) {
        ArrayStatement copy = new ArrayStatement(newTestCase, this.retval.getType(), this.lengths);
        return copy;
    }

    @Override
    public boolean equals(Object s) {
        if (this == s) {
            return true;
        }
        if (s == null) {
            return false;
        }
        if (this.getClass() != s.getClass()) {
            return false;
        }
        ArrayStatement as = (ArrayStatement)s;
        if (!Arrays.equals(this.lengths, as.lengths)) {
            return false;
        }
        return this.retval.equals(as.retval);
    }

    @Override
    public Throwable execute(Scope scope, PrintStream out) throws InvocationTargetException, IllegalArgumentException, IllegalAccessException, InstantiationException {
        Throwable exceptionThrown = null;
        try {
            Class<?> componentType = this.retval.getComponentClass();
            while (componentType.isArray()) {
                componentType = componentType.getComponentType();
            }
            this.retval.setObject(scope, Array.newInstance(componentType, this.lengths));
        }
        catch (CodeUnderTestException e) {
            exceptionThrown = e.getCause();
        }
        return exceptionThrown;
    }

    @Override
    public GenericAccessibleObject<?> getAccessibleObject() {
        return null;
    }

    @Override
    public void getBytecode(GeneratorAdapter mg, Map<Integer, Integer> locals, Throwable exception) {
        if (this.lengths.length > 1) {
            throw new RuntimeException("Not yet implemented for multidimensional arrays!");
        }
        mg.push(this.lengths[0]);
        mg.newArray(org.objectweb.asm.Type.getType((Class)((Class)this.retval.getComponentType())));
        this.retval.storeBytecode(mg, locals);
    }

    public List<Integer> getLengths() {
        return Arrays.asList(ArrayUtils.toObject((int[])this.lengths));
    }

    @Override
    public List<VariableReference> getUniqueVariableReferences() {
        return new ArrayList<VariableReference>(this.getVariableReferences());
    }

    @Override
    public Set<VariableReference> getVariableReferences() {
        LinkedHashSet<VariableReference> references = new LinkedHashSet<VariableReference>();
        references.add(this.retval);
        return references;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = this.retval.hashCode();
        result = 31 * result + Arrays.hashCode(this.lengths);
        return result;
    }

    @Override
    public boolean isAssignmentStatement() {
        return false;
    }

    @Override
    public boolean isValid() {
        int maxAssignment = 0;
        for (Statement statement : this.tc) {
            for (VariableReference var : statement.getVariableReferences()) {
                if (var.getAdditionalVariableReference() != this.retval) continue;
                VariableReference currentVar = var;
                while (currentVar instanceof FieldReference) {
                    currentVar = ((FieldReference)currentVar).getSource();
                }
                ArrayIndex index = (ArrayIndex)currentVar;
                maxAssignment = Math.max(maxAssignment, index.getArrayIndex());
            }
        }
        if (maxAssignment > this.lengths[0]) {
            logger.warn("Max assignment = " + maxAssignment + ", length = " + this.lengths[0]);
            return false;
        }
        return super.isValid();
    }

    @Override
    public boolean mutate(TestCase test, TestFactory factory) {
        int maxAssignment = 0;
        for (Statement statement : test) {
            for (VariableReference var : statement.getVariableReferences()) {
                if (var.getAdditionalVariableReference() != this.retval) continue;
                VariableReference currentVar = var;
                while (currentVar instanceof FieldReference) {
                    currentVar = ((FieldReference)currentVar).getSource();
                }
                if (!(currentVar instanceof ArrayIndex)) {
                    LoggingUtils.getEvoLogger().error("Found assignment to array without ArrayIndex:");
                    LoggingUtils.getEvoLogger().error(test.toCode());
                    LoggingUtils.getEvoLogger().error(statement.getPosition() + ", " + statement.getCode());
                }
                ArrayIndex index = (ArrayIndex)currentVar;
                maxAssignment = Math.max(maxAssignment, index.getArrayIndex());
            }
        }
        int dim = 0;
        if (this.lengths.length > 1) {
            dim = Randomness.nextInt(this.lengths.length - 1);
        }
        int newLength = this.lengths[dim];
        while (newLength == this.lengths[dim]) {
            if (Randomness.nextDouble() <= Properties.RANDOM_PERTURBATION) {
                newLength = Randomness.nextInt(maxAssignment, Math.max(maxAssignment + 1, Properties.MAX_ARRAY)) + 1;
                continue;
            }
            int max = Math.min(Math.abs(this.lengths[dim] - maxAssignment - 1), Properties.MAX_DELTA);
            if (max > 0) {
                newLength = this.lengths[dim] + Randomness.nextInt(2 * max) - max;
                continue;
            }
            newLength = this.lengths[dim] + Randomness.nextInt(Properties.MAX_DELTA);
        }
        if (newLength <= 0) {
            newLength = 1;
        }
        this.lengths[dim] = newLength;
        ((ArrayReference)this.retval).setLengths(this.lengths);
        return true;
    }

    @Override
    public void replace(VariableReference var1, VariableReference var2) {
    }

    @Override
    public boolean same(Statement s) {
        if (this == s) {
            return true;
        }
        if (s == null) {
            return false;
        }
        if (this.getClass() != s.getClass()) {
            return false;
        }
        ArrayStatement as = (ArrayStatement)s;
        if (!Arrays.equals(this.lengths, as.lengths)) {
            return false;
        }
        return this.retval.same(as.retval);
    }

    public void setLengths(int[] lengths) {
        this.lengths = new int[lengths.length];
        for (int i = 0; i < lengths.length; ++i) {
            this.lengths[i] = lengths[i];
        }
        ((ArrayReference)this.retval).setLengths(lengths);
    }

    public void setSize(int size) {
        this.lengths[0] = size;
        ((ArrayReference)this.retval).setArrayLength(size);
    }

    public int size() {
        return this.lengths[0];
    }

    public ArrayReference getArrayReference() {
        return (ArrayReference)this.getReturnValue();
    }
}

