/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testcase.statements;

import edu.uta.cse.dsc.VM;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.evosuite.Properties;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.TestFactory;
import org.evosuite.testcase.execution.CodeUnderTestException;
import org.evosuite.testcase.execution.EvosuiteError;
import org.evosuite.testcase.execution.Scope;
import org.evosuite.testcase.execution.UncompilableCodeException;
import org.evosuite.testcase.statements.AbstractStatement;
import org.evosuite.testcase.statements.NullStatement;
import org.evosuite.testcase.statements.PrimitiveStatement;
import org.evosuite.testcase.statements.Statement;
import org.evosuite.testcase.variable.ArrayIndex;
import org.evosuite.testcase.variable.VariableReference;
import org.evosuite.testcase.variable.VariableReferenceImpl;
import org.evosuite.utils.GenericClass;
import org.evosuite.utils.GenericConstructor;
import org.evosuite.utils.Randomness;
import org.objectweb.asm.Label;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.commons.Method;

public class ConstructorStatement
extends AbstractStatement {
    private static final long serialVersionUID = -3035570485633271957L;
    private GenericConstructor constructor;
    public List<VariableReference> parameters;
    private static final List<String> primitiveClasses = Arrays.asList("char", "int", "short", "long", "boolean", "float", "double", "byte");

    public ConstructorStatement(TestCase tc, GenericConstructor constructor, List<VariableReference> parameters) {
        super(tc, new VariableReferenceImpl(tc, constructor.getOwnerClass()));
        this.constructor = constructor;
        this.parameters = parameters;
    }

    public ConstructorStatement(TestCase tc, GenericConstructor constructor, VariableReference retvar, List<VariableReference> parameters) {
        super(tc, retvar);
        assert (tc.size() > retvar.getStPosition());
        this.constructor = constructor;
        this.parameters = parameters;
    }

    protected ConstructorStatement(TestCase tc, GenericConstructor constructor, VariableReference retvar, List<VariableReference> parameters, boolean check) {
        super(tc, retvar);
        assert (!check);
        this.constructor = constructor;
        this.parameters = parameters;
    }

    public GenericConstructor getConstructor() {
        return this.constructor;
    }

    public void setConstructor(GenericConstructor constructor) {
        this.constructor = constructor;
        this.retval.setType(constructor.getReturnType());
    }

    public static String getReturnType(Class<?> clazz) {
        String retVal = ClassUtils.getShortClassName(clazz);
        if (primitiveClasses.contains(retVal)) {
            return clazz.getSimpleName();
        }
        return retVal;
    }

    @Override
    public Throwable execute(final Scope scope, PrintStream out) throws InvocationTargetException, IllegalArgumentException, InstantiationException, IllegalAccessException {
        logger.trace("Executing constructor " + this.constructor.toString());
        final Object[] inputs = new Object[this.parameters.size()];
        Throwable exceptionThrown = null;
        try {
            return super.exceptionHandler(new AbstractStatement.Executer(){

                @Override
                public void execute() throws InvocationTargetException, IllegalArgumentException, IllegalAccessException, InstantiationException, CodeUnderTestException {
                    Type[] parameterTypes = ConstructorStatement.this.constructor.getParameterTypes();
                    for (int i = 0; i < ConstructorStatement.this.parameters.size(); ++i) {
                        VariableReference parameterVar = ConstructorStatement.this.parameters.get(i);
                        try {
                            inputs[i] = parameterVar.getObject(scope);
                        }
                        catch (CodeUnderTestException e) {
                            throw e;
                        }
                        catch (Throwable e) {
                            AbstractStatement.logger.error("Class " + Properties.TARGET_CLASS + ". Error encountered: " + e);
                            assert (false);
                            throw new EvosuiteError(e);
                        }
                        if (inputs[i] != null && !TypeUtils.isAssignable(inputs[i].getClass(), (Type)parameterTypes[i])) {
                            throw new CodeUnderTestException(new UncompilableCodeException("Cannot assign " + parameterVar.getVariableClass().getName() + " to " + parameterTypes[i]));
                        }
                        if (inputs[i] != null || !ConstructorStatement.this.constructor.getConstructor().getParameterTypes()[i].isPrimitive()) continue;
                        throw new CodeUnderTestException(new NullPointerException());
                    }
                    if (ConstructorStatement.this.constructor.getConstructor().getDeclaringClass().isMemberClass() && !Modifier.isStatic(ConstructorStatement.this.constructor.getConstructor().getDeclaringClass().getModifiers()) && inputs[0] == null) {
                        throw new CodeUnderTestException(new NullPointerException());
                    }
                    Object ret = ConstructorStatement.this.constructor.getConstructor().newInstance(inputs);
                    try {
                        ConstructorStatement.this.retval.setObject(scope, ret);
                    }
                    catch (CodeUnderTestException e) {
                        throw e;
                    }
                    catch (Throwable e) {
                        throw new EvosuiteError(e);
                    }
                }

                @Override
                public Set<Class<? extends Throwable>> throwableExceptions() {
                    HashSet<Class<? extends Throwable>> t = new HashSet<Class<? extends Throwable>>();
                    t.add(InvocationTargetException.class);
                    return t;
                }
            });
        }
        catch (InvocationTargetException e) {
            VM.setIgnoreCallBack((boolean)true);
            exceptionThrown = e.getCause();
            if (logger.isDebugEnabled()) {
                try {
                    logger.debug("Exception thrown in constructor: " + e.getCause());
                }
                catch (Exception ex) {
                    logger.debug("Exception thrown in constructor and SUT gives issue when calling e.getCause()", (Throwable)ex);
                }
            }
            return exceptionThrown;
        }
    }

    @Override
    public Statement copy(TestCase newTestCase, int offset) {
        ArrayList<VariableReference> new_params = new ArrayList<VariableReference>();
        for (VariableReference r : this.parameters) {
            new_params.add(r.copy(newTestCase, offset));
        }
        ConstructorStatement copy = new ConstructorStatement(newTestCase, this.constructor.copy(), new_params);
        return copy;
    }

    @Override
    public Set<VariableReference> getVariableReferences() {
        LinkedHashSet<VariableReference> references = new LinkedHashSet<VariableReference>();
        references.add(this.retval);
        references.addAll(this.parameters);
        for (VariableReference param : this.parameters) {
            if (param.getAdditionalVariableReference() == null) continue;
            references.add(param.getAdditionalVariableReference());
        }
        references.addAll(this.getAssertionReferences());
        return references;
    }

    @Override
    public void replace(VariableReference var1, VariableReference var2) {
        if (this.retval.equals(var1)) {
            this.retval = var2;
        }
        for (int i = 0; i < this.parameters.size(); ++i) {
            if (this.parameters.get(i).equals(var1)) {
                this.parameters.set(i, var2);
                continue;
            }
            this.parameters.get(i).replaceAdditionalVariableReference(var1, var2);
        }
    }

    public List<VariableReference> getParameterReferences() {
        return this.parameters;
    }

    @Override
    public int getNumParameters() {
        return this.parameters.size();
    }

    public void replaceParameterReference(VariableReference var, int numParameter) {
        assert (numParameter >= 0);
        assert (numParameter < this.parameters.size());
        this.parameters.set(numParameter, var);
    }

    @Override
    public boolean equals(Object s) {
        if (this == s) {
            return true;
        }
        if (s == null) {
            return false;
        }
        if (this.getClass() != s.getClass()) {
            return false;
        }
        ConstructorStatement ms = (ConstructorStatement)s;
        if (ms.parameters.size() != this.parameters.size()) {
            return false;
        }
        if (!this.constructor.equals(ms.constructor)) {
            return false;
        }
        for (int i = 0; i < this.parameters.size(); ++i) {
            if (this.parameters.get(i).equals(ms.parameters.get(i))) continue;
            return false;
        }
        return this.retval.equals(ms.retval);
    }

    @Override
    public int hashCode() {
        int prime = 41;
        int result = 1;
        result = 41 * result + (this.constructor == null ? 0 : this.constructor.hashCode());
        result = 41 * result + (this.parameters == null ? 0 : this.parameters.hashCode());
        return result;
    }

    @Override
    public void getBytecode(GeneratorAdapter mg, Map<Integer, Integer> locals, Throwable exception) {
        logger.debug("Invoking constructor");
        Label start = mg.newLabel();
        Label end = mg.newLabel();
        mg.mark(start);
        mg.newInstance(org.objectweb.asm.Type.getType(this.retval.getVariableClass()));
        mg.dup();
        int num = 0;
        for (VariableReference parameter : this.parameters) {
            parameter.loadBytecode(mg, locals);
            if (this.constructor.getConstructor().getParameterTypes()[num].isPrimitive()) {
                if (parameter.getGenericClass().isWrapperType()) {
                    mg.unbox(org.objectweb.asm.Type.getType(parameter.getGenericClass().getUnboxedType()));
                } else if (!parameter.getGenericClass().isPrimitive()) {
                    Class<?> parameterClass = new GenericClass(this.constructor.getParameterTypes()[num]).getBoxedType();
                    org.objectweb.asm.Type parameterType = org.objectweb.asm.Type.getType(parameterClass);
                    mg.checkCast(parameterType);
                    mg.unbox(org.objectweb.asm.Type.getType(this.constructor.getConstructor().getParameterTypes()[num]));
                }
                if (!this.constructor.getParameterTypes()[num].equals(parameter.getVariableClass())) {
                    logger.debug("Types don't match - casting " + parameter.getVariableClass().getName() + " to " + this.constructor.getConstructor().getParameterTypes()[num].getName());
                    mg.cast(org.objectweb.asm.Type.getType(parameter.getVariableClass()), org.objectweb.asm.Type.getType(this.constructor.getConstructor().getParameterTypes()[num]));
                }
            } else if (parameter.getVariableClass().isPrimitive()) {
                mg.box(org.objectweb.asm.Type.getType(parameter.getVariableClass()));
            }
            ++num;
        }
        mg.invokeConstructor(org.objectweb.asm.Type.getType(this.retval.getVariableClass()), Method.getMethod(this.constructor.getConstructor()));
        logger.debug("Storing result");
        this.retval.storeBytecode(mg, locals);
        mg.mark(end);
        Label l = mg.newLabel();
        mg.goTo(l);
        mg.catchException(start, end, org.objectweb.asm.Type.getType(Throwable.class));
        mg.pop();
        if (!this.retval.isVoid()) {
            Class<?> clazz = this.retval.getVariableClass();
            if (clazz.equals(Boolean.TYPE)) {
                mg.push(false);
            } else if (clazz.equals(Character.TYPE)) {
                mg.push(0);
            } else if (clazz.equals(Integer.TYPE)) {
                mg.push(0);
            } else if (clazz.equals(Short.TYPE)) {
                mg.push(0);
            } else if (clazz.equals(Long.TYPE)) {
                mg.push(0L);
            } else if (clazz.equals(Float.TYPE)) {
                mg.push(0.0f);
            } else if (clazz.equals(Double.TYPE)) {
                mg.push(0.0);
            } else if (clazz.equals(Byte.TYPE)) {
                mg.push(0);
            } else if (clazz.equals(String.class)) {
                mg.push("");
            } else {
                mg.visitInsn(1);
            }
            this.retval.storeBytecode(mg, locals);
        }
        mg.mark(l);
    }

    @Override
    public Set<Class<?>> getDeclaredExceptions() {
        Set<Class<?>> ex = super.getDeclaredExceptions();
        ex.addAll(Arrays.asList(this.constructor.getConstructor().getExceptionTypes()));
        return ex;
    }

    @Override
    public List<VariableReference> getUniqueVariableReferences() {
        ArrayList<VariableReference> references = new ArrayList<VariableReference>();
        references.add(this.retval);
        references.addAll(this.parameters);
        for (VariableReference param : this.parameters) {
            if (!(param instanceof ArrayIndex)) continue;
            references.add(((ArrayIndex)param).getArray());
        }
        return references;
    }

    @Override
    public boolean mutate(TestCase test, TestFactory factory) {
        if (Randomness.nextDouble() >= Properties.P_CHANGE_PARAMETER) {
            return false;
        }
        List<VariableReference> parameters = this.getParameterReferences();
        if (parameters.isEmpty()) {
            return false;
        }
        int numParameter = Randomness.nextInt(parameters.size());
        VariableReference parameter = parameters.get(numParameter);
        List<VariableReference> objects = test.getObjects(parameter.getType(), this.getPosition());
        objects.remove(parameter);
        objects.remove(this.getReturnValue());
        NullStatement nullStatement = new NullStatement(test, parameter.getType());
        Statement primitiveCopy = null;
        if (!parameter.isPrimitive()) {
            objects.add(nullStatement.getReturnValue());
        } else {
            Statement originalStatement = test.getStatement(parameter.getStPosition());
            if (originalStatement instanceof PrimitiveStatement) {
                PrimitiveStatement copy = (PrimitiveStatement)originalStatement.clone(test);
                copy.delta();
                objects.add(copy.getReturnValue());
                primitiveCopy = copy;
            }
        }
        if (objects.isEmpty()) {
            return false;
        }
        VariableReference replacement = Randomness.choice(objects);
        if (replacement == nullStatement.getReturnValue()) {
            test.addStatement(nullStatement, this.getPosition());
        } else if (primitiveCopy != null && replacement == primitiveCopy.getReturnValue()) {
            test.addStatement(primitiveCopy, this.getPosition());
        }
        this.replaceParameterReference(replacement, numParameter);
        return true;
    }

    @Override
    public boolean isAccessible() {
        if (!this.constructor.isAccessible()) {
            return false;
        }
        return super.isAccessible();
    }

    @Override
    public boolean isValid() {
        assert (super.isValid());
        for (VariableReference v : this.parameters) {
            v.getStPosition();
        }
        return true;
    }

    @Override
    public boolean same(Statement s) {
        if (this == s) {
            return true;
        }
        if (s == null) {
            return false;
        }
        if (this.getClass() != s.getClass()) {
            return false;
        }
        ConstructorStatement ms = (ConstructorStatement)s;
        if (ms.parameters.size() != this.parameters.size()) {
            return false;
        }
        if (!this.constructor.equals(ms.constructor)) {
            return false;
        }
        for (int i = 0; i < this.parameters.size(); ++i) {
            if (this.parameters.get(i).same(ms.parameters.get(i))) continue;
            return false;
        }
        return this.retval.same(ms.retval);
    }

    public GenericConstructor getAccessibleObject() {
        return this.constructor;
    }

    @Override
    public boolean isAssignmentStatement() {
        return false;
    }

    @Override
    public void changeClassLoader(ClassLoader loader) {
        this.constructor.changeClassLoader(loader);
        super.changeClassLoader(loader);
    }
}

