/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testcase.statements.environment;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Type;
import org.evosuite.runtime.testdata.EvoSuiteFile;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.statements.environment.EnvironmentDataStatement;
import org.evosuite.testcase.variable.VariableReference;
import org.evosuite.utils.Randomness;
import org.evosuite.utils.StringUtil;
import org.objectweb.asm.commons.GeneratorAdapter;

public class FileNamePrimitiveStatement
extends EnvironmentDataStatement<EvoSuiteFile> {
    private static final long serialVersionUID = 4402006999670328128L;

    public FileNamePrimitiveStatement(TestCase tc, EvoSuiteFile value) {
        super(tc, (Type)((Object)EvoSuiteFile.class), value);
    }

    @Override
    public String getTestCode(String varName) {
        String testCode = "";
        VariableReference retval = this.getReturnValue();
        Object value = this.getValue();
        if (value != null) {
            String escapedPath = StringUtil.getEscapedString(((EvoSuiteFile)value).getPath());
            testCode = testCode + ((Class)retval.getType()).getSimpleName() + " " + varName + " = new " + ((Class)retval.getType()).getSimpleName() + "(\"" + escapedPath + "\");\n";
        } else {
            testCode = testCode + ((Class)retval.getType()).getSimpleName() + " " + varName + " = null;\n";
        }
        return testCode;
    }

    @Override
    public void delta() {
        this.randomize();
    }

    @Override
    public void zero() {
    }

    @Override
    protected void pushBytecode(GeneratorAdapter mg) {
    }

    @Override
    public void randomize() {
        String path = Randomness.choice(this.tc.getAccessedEnvironment().getViewOfAccessedFiles());
        if (path != null) {
            this.setValue(new EvoSuiteFile(path));
        } else {
            this.setValue(null);
        }
        logger.debug("Randomized filename: " + this.value);
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
        oos.writeObject(this.value);
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        this.value = (EvoSuiteFile)ois.readObject();
    }
}

