/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testcase.statements.environment;

import java.lang.reflect.Type;
import org.evosuite.runtime.testdata.EvoSuiteAddress;
import org.evosuite.runtime.testdata.EvoSuiteLocalAddress;
import org.evosuite.runtime.vnet.EndPointInfo;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.statements.environment.EnvironmentDataStatement;
import org.evosuite.testcase.variable.VariableReference;
import org.evosuite.utils.Randomness;
import org.evosuite.utils.StringUtil;
import org.objectweb.asm.commons.GeneratorAdapter;

public class LocalAddressPrimitiveStatement
extends EnvironmentDataStatement<EvoSuiteLocalAddress> {
    public LocalAddressPrimitiveStatement(TestCase tc) {
        this(tc, (EvoSuiteLocalAddress)null);
        this.randomize();
    }

    public LocalAddressPrimitiveStatement(TestCase tc, EvoSuiteLocalAddress value) {
        super(tc, (Type)((Object)EvoSuiteLocalAddress.class), value);
    }

    @Override
    public String getTestCode(String varName) {
        String testCode = "";
        VariableReference retval = this.getReturnValue();
        Object value = this.getValue();
        if (value != null) {
            String escapedAddress = StringUtil.getEscapedString(((EvoSuiteAddress)value).getHost());
            int port = ((EvoSuiteAddress)value).getPort();
            testCode = testCode + ((Class)retval.getType()).getSimpleName() + " " + varName + " = new " + ((Class)retval.getType()).getSimpleName() + "(\"" + escapedAddress + "\", " + port + ");\n";
        } else {
            testCode = testCode + ((Class)retval.getType()).getSimpleName() + " " + varName + " = null;\n";
        }
        return testCode;
    }

    @Override
    public void delta() {
        this.randomize();
    }

    @Override
    public void zero() {
    }

    @Override
    protected void pushBytecode(GeneratorAdapter mg) {
    }

    @Override
    public void randomize() {
        EvoSuiteLocalAddress addr;
        if (!this.tc.getAccessedEnvironment().getViewOfLocalListeningPorts().isEmpty()) {
            EndPointInfo info = Randomness.choice(this.tc.getAccessedEnvironment().getViewOfLocalListeningPorts());
            String host = info.getHost();
            int port = info.getPort();
            addr = new EvoSuiteLocalAddress(host, port);
        } else {
            addr = null;
        }
        this.setValue(addr);
    }
}

