/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testcase.statements.numeric;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.evosuite.Properties;
import org.evosuite.seeding.ConstantPool;
import org.evosuite.seeding.ConstantPoolManager;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.statements.numeric.NumericalPrimitiveStatement;
import org.evosuite.utils.Randomness;
import org.objectweb.asm.commons.GeneratorAdapter;

public class DoublePrimitiveStatement
extends NumericalPrimitiveStatement<Double> {
    private static final long serialVersionUID = 6229514439946892566L;

    public DoublePrimitiveStatement(TestCase tc, Double value) {
        super(tc, Double.TYPE, value);
    }

    public DoublePrimitiveStatement(TestCase tc) {
        super(tc, Double.TYPE, Double.valueOf(0.0));
    }

    @Override
    public void zero() {
        this.value = new Double(0.0);
    }

    @Override
    public void pushBytecode(GeneratorAdapter mg) {
        mg.push(((Double)this.value).doubleValue());
    }

    @Override
    public void delta() {
        double P = Randomness.nextDouble();
        if (P < 0.3333333333333333) {
            this.value = (Double)this.value + Randomness.nextGaussian() * (double)Properties.MAX_DELTA;
        } else if (P < 0.6666666666666666) {
            this.value = (Double)this.value + Randomness.nextGaussian();
        } else {
            int precision = Randomness.nextInt(15);
            this.chopPrecision(precision);
        }
    }

    @Override
    public void increment(long delta) {
        this.value = (Double)this.value + (double)delta;
    }

    private void chopPrecision(int precision) {
        if (((Double)this.value).isNaN() || ((Double)this.value).isInfinite()) {
            return;
        }
        BigDecimal bd = new BigDecimal((Double)this.value).setScale(precision, RoundingMode.HALF_EVEN);
        this.value = bd.doubleValue();
    }

    @Override
    public void increment(double delta) {
        this.value = (Double)this.value + delta;
    }

    @Override
    public void randomize() {
        if (Randomness.nextDouble() >= Properties.PRIMITIVE_POOL) {
            this.value = Randomness.nextGaussian() * (double)Properties.MAX_INT;
            int precision = Randomness.nextInt(15);
            this.chopPrecision(precision);
        } else {
            ConstantPool constantPool = ConstantPoolManager.getInstance().getConstantPool();
            this.value = constantPool.getRandomDouble();
        }
    }

    @Override
    public void increment() {
        this.increment(1.0);
    }

    @Override
    public void setMid(Double min, Double max) {
        this.value = min + (max - min) / 2.0;
    }

    @Override
    public void decrement() {
        this.increment(-1.0);
    }

    @Override
    public boolean isPositive() {
        return (Double)this.value >= 0.0;
    }

    @Override
    public void negate() {
        this.value = -((Double)this.value).doubleValue();
    }
}

