/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testcase.statements.numeric;

import org.evosuite.Properties;
import org.evosuite.seeding.ConstantPool;
import org.evosuite.seeding.ConstantPoolManager;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.statements.numeric.NumericalPrimitiveStatement;
import org.evosuite.utils.Randomness;
import org.objectweb.asm.commons.GeneratorAdapter;

public class ShortPrimitiveStatement
extends NumericalPrimitiveStatement<Short> {
    private static final long serialVersionUID = -1041008456902695964L;

    public ShortPrimitiveStatement(TestCase tc, Short value) {
        super(tc, Short.TYPE, value);
    }

    public ShortPrimitiveStatement(TestCase tc) {
        super(tc, Short.TYPE, Short.valueOf((short)0));
    }

    @Override
    public void zero() {
        this.value = (short)0;
    }

    @Override
    public void pushBytecode(GeneratorAdapter mg) {
        mg.push((int)((Short)this.value).shortValue());
    }

    @Override
    public void delta() {
        short delta = (short)Math.floor(Randomness.nextGaussian() * (double)Properties.MAX_DELTA);
        this.value = (short)((Short)this.value + delta);
    }

    @Override
    public void increment(long delta) {
        this.value = (short)((Short)this.value + (short)delta);
    }

    @Override
    public void randomize() {
        short max = (short)Math.min(Properties.MAX_INT, Short.MAX_VALUE);
        if (Randomness.nextDouble() >= Properties.PRIMITIVE_POOL) {
            this.value = (short)(Randomness.nextGaussian() * (double)max);
        } else {
            ConstantPool constantPool = ConstantPoolManager.getInstance().getConstantPool();
            this.value = (short)constantPool.getRandomInt();
        }
    }

    @Override
    public void increment() {
        this.increment(1L);
    }

    @Override
    public void setMid(Short min, Short max) {
        this.value = (short)(min + (max - min) / 2);
    }

    @Override
    public void decrement() {
        this.increment(-1L);
    }

    @Override
    public boolean isPositive() {
        return (Short)this.value >= 0;
    }

    @Override
    public void negate() {
        this.value = -((Short)this.value).shortValue();
    }
}

