/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testcase.variable;

import com.googlecode.gentyref.GenericTypeReflector;
import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.execution.CodeUnderTestException;
import org.evosuite.testcase.execution.Scope;
import org.evosuite.testcase.variable.ArrayReference;
import org.evosuite.testcase.variable.VariableReference;
import org.evosuite.testcase.variable.VariableReferenceImpl;
import org.evosuite.utils.GenericClass;
import org.objectweb.asm.commons.GeneratorAdapter;

public class ArrayIndex
extends VariableReferenceImpl {
    private static final long serialVersionUID = -4492869536935582711L;
    private List<Integer> indices;
    protected ArrayReference array = null;

    public ArrayIndex(TestCase testCase, ArrayReference array, int index) {
        this(testCase, array, Collections.singletonList(index));
    }

    public ArrayIndex(TestCase testCase, ArrayReference array, List<Integer> indices) {
        super(testCase, new GenericClass(ArrayIndex.getReturnType(array, indices.size())));
        this.array = array;
        this.setArrayIndices(indices);
    }

    private static Type getReturnType(ArrayReference array, int indicesCnt) {
        assert (indicesCnt >= 1);
        Type result = array.getComponentType();
        for (int idx = 1; idx < indicesCnt; ++idx) {
            result = GenericTypeReflector.getArrayComponentType((Type)result);
        }
        return result;
    }

    public ArrayReference getArray() {
        return this.array;
    }

    public void setArray(ArrayReference r) {
        this.array = r;
    }

    @Override
    public boolean isArrayIndex() {
        return true;
    }

    public int getArrayIndex() {
        assert (this.indices.size() == 1);
        return this.indices.get(0);
    }

    public void setArrayIndex(int index) {
        assert (this.indices.size() == 1);
        this.indices.set(0, index);
    }

    @Override
    public int getStPosition() {
        assert (this.array != null);
        for (int i = 0; i < this.testCase.size(); ++i) {
            if (!this.testCase.getStatement(i).getReturnValue().equals(this)) continue;
            return i;
        }
        return this.array.getStPosition();
    }

    @Override
    public String getName() {
        String result = this.array.getName();
        for (int index : this.indices) {
            result = result + "[" + index + "]";
        }
        return result;
    }

    @Override
    public void loadBytecode(GeneratorAdapter mg, Map<Integer, Integer> locals) {
        if (this.indices.size() > 1) {
            throw new RuntimeException("Not yet implemented for multidimensional arrays!");
        }
        this.array.loadBytecode(mg, locals);
        mg.push(this.indices.get(0).intValue());
        mg.arrayLoad(org.objectweb.asm.Type.getType(this.type.getRawClass()));
    }

    @Override
    public void storeBytecode(GeneratorAdapter mg, Map<Integer, Integer> locals) {
        if (this.indices.size() > 1) {
            throw new RuntimeException("Not yet implemented for multidimensional arrays!");
        }
        int localVar = mg.newLocal(org.objectweb.asm.Type.getType(this.getVariableClass()));
        mg.storeLocal(localVar);
        this.array.loadBytecode(mg, locals);
        mg.push(this.indices.get(0).intValue());
        mg.loadLocal(localVar);
        mg.arrayStore(org.objectweb.asm.Type.getType(this.type.getRawClass()));
    }

    @Override
    public boolean same(VariableReference r) {
        if (r == null) {
            return false;
        }
        if (!(r instanceof ArrayIndex)) {
            return false;
        }
        ArrayIndex other = (ArrayIndex)r;
        if (this.getStPosition() != r.getStPosition()) {
            return false;
        }
        if (!this.array.same(other.getArray())) {
            return false;
        }
        if (!this.indices.equals(other.indices)) {
            return false;
        }
        if (this.type.equals(r.getGenericClass())) {
            // empty if block
        }
        return true;
    }

    @Override
    public Object getObject(Scope scope) throws CodeUnderTestException {
        Object arrayObject = this.array.getObject(scope);
        try {
            for (int idx = 0; idx < this.indices.size() - 1; ++idx) {
                if (arrayObject == null) {
                    throw new CodeUnderTestException(new NullPointerException());
                }
                arrayObject = Array.get(arrayObject, this.indices.get(idx));
            }
            if (arrayObject == null) {
                throw new CodeUnderTestException(new NullPointerException());
            }
            Object result = Array.get(arrayObject, this.indices.get(this.indices.size() - 1));
            return result;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new CodeUnderTestException(e);
        }
    }

    private Integer getIntValue(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Number) {
            return ((Number)object).intValue();
        }
        if (object instanceof Character) {
            return new Integer(((Character)object).charValue());
        }
        return 0;
    }

    private Short getShortValue(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Number) {
            return (short)((Number)object).intValue();
        }
        if (object instanceof Character) {
            return new Short((short)((Character)object).charValue());
        }
        return (short)0;
    }

    private Byte getByteValue(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Number) {
            return (byte)((Number)object).intValue();
        }
        if (object instanceof Character) {
            return new Byte((byte)((Character)object).charValue());
        }
        return (byte)0;
    }

    private Long getLongValue(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Number) {
            return ((Number)object).longValue();
        }
        if (object instanceof Character) {
            return new Long(((Character)object).charValue());
        }
        return 0L;
    }

    private Float getFloatValue(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Number) {
            return Float.valueOf(((Number)object).floatValue());
        }
        if (object instanceof Character) {
            return new Float(((Character)object).charValue());
        }
        return Float.valueOf(0.0f);
    }

    private Double getDoubleValue(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Number) {
            return ((Number)object).doubleValue();
        }
        if (object instanceof Character) {
            return new Double(((Character)object).charValue());
        }
        return 0.0;
    }

    private Character getCharValue(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Character) {
            return Character.valueOf(((Character)object).charValue());
        }
        if (object instanceof Number) {
            return Character.valueOf((char)((Number)object).intValue());
        }
        return Character.valueOf('0');
    }

    @Override
    public void setObject(Scope scope, Object value) throws CodeUnderTestException {
        Object arrayObject = this.array.getObject(scope);
        try {
            for (int idx = 0; idx < this.indices.size() - 1; ++idx) {
                if (arrayObject == null) {
                    throw new CodeUnderTestException(new NullPointerException());
                }
                arrayObject = Array.get(arrayObject, this.indices.get(idx));
            }
            if (arrayObject == null) {
                throw new CodeUnderTestException(new NullPointerException());
            }
            if (value == null && arrayObject.getClass().getComponentType().isPrimitive()) {
                throw new CodeUnderTestException(new NullPointerException());
            }
            if (arrayObject.getClass().getComponentType().equals(Integer.TYPE)) {
                Array.setInt(arrayObject, this.indices.get(this.indices.size() - 1), this.getIntValue(value));
            } else if (arrayObject.getClass().getComponentType().equals(Boolean.TYPE)) {
                Array.setBoolean(arrayObject, this.indices.get(this.indices.size() - 1), (Boolean)value);
            } else if (arrayObject.getClass().getComponentType().equals(Character.TYPE)) {
                Array.setChar(arrayObject, this.indices.get(this.indices.size() - 1), this.getCharValue(value).charValue());
            } else if (arrayObject.getClass().getComponentType().equals(Double.TYPE)) {
                Array.setDouble(arrayObject, this.indices.get(this.indices.size() - 1), this.getDoubleValue(value));
            } else if (arrayObject.getClass().getComponentType().equals(Float.TYPE)) {
                Array.setFloat(arrayObject, this.indices.get(this.indices.size() - 1), this.getFloatValue(value).floatValue());
            } else if (arrayObject.getClass().getComponentType().equals(Long.TYPE)) {
                Array.setLong(arrayObject, this.indices.get(this.indices.size() - 1), this.getLongValue(value));
            } else if (arrayObject.getClass().getComponentType().equals(Short.TYPE)) {
                Array.setShort(arrayObject, this.indices.get(this.indices.size() - 1), this.getShortValue(value));
            } else if (arrayObject.getClass().getComponentType().equals(Byte.TYPE)) {
                Array.setByte(arrayObject, this.indices.get(this.indices.size() - 1), this.getByteValue(value));
            } else if (arrayObject.getClass().getComponentType().equals(Integer.class)) {
                Array.set(arrayObject, this.indices.get(this.indices.size() - 1), this.getIntValue(value));
            } else if (arrayObject.getClass().getComponentType().equals(Boolean.class)) {
                Array.set(arrayObject, this.indices.get(this.indices.size() - 1), value);
            } else if (arrayObject.getClass().getComponentType().equals(Character.class)) {
                Array.set(arrayObject, this.indices.get(this.indices.size() - 1), this.getCharValue(value));
            } else if (arrayObject.getClass().getComponentType().equals(Double.class)) {
                Array.set(arrayObject, this.indices.get(this.indices.size() - 1), this.getDoubleValue(value));
            } else if (arrayObject.getClass().getComponentType().equals(Float.class)) {
                Array.set(arrayObject, this.indices.get(this.indices.size() - 1), this.getFloatValue(value));
            } else if (arrayObject.getClass().getComponentType().equals(Long.class)) {
                Array.set(arrayObject, this.indices.get(this.indices.size() - 1), this.getLongValue(value));
            } else if (arrayObject.getClass().getComponentType().equals(Short.class)) {
                Array.set(arrayObject, this.indices.get(this.indices.size() - 1), this.getShortValue(value));
            } else if (arrayObject.getClass().getComponentType().equals(Byte.class)) {
                Array.set(arrayObject, this.indices.get(this.indices.size() - 1), this.getByteValue(value));
            } else {
                Array.set(arrayObject, this.indices.get(this.indices.size() - 1), value);
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new CodeUnderTestException(e);
        }
    }

    @Override
    public VariableReference copy(TestCase newTestCase, int offset) {
        ArrayReference otherArray = (ArrayReference)newTestCase.getStatement(this.array.getStPosition() + offset).getReturnValue();
        return new ArrayIndex(newTestCase, otherArray, this.indices);
    }

    @Override
    public VariableReference getAdditionalVariableReference() {
        if (this.array.getAdditionalVariableReference() == null) {
            return this.array;
        }
        return this.array.getAdditionalVariableReference();
    }

    @Override
    public void setAdditionalVariableReference(VariableReference var) {
        assert (var instanceof ArrayReference);
        this.array = (ArrayReference)var;
    }

    @Override
    public void replaceAdditionalVariableReference(VariableReference var1, VariableReference var2) {
        if (this.array.equals(var1)) {
            if (var2 instanceof ArrayReference) {
                this.array = (ArrayReference)var2;
            }
        } else {
            this.array.replaceAdditionalVariableReference(var1, var2);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.array == null ? 0 : this.array.hashCode());
        result = 31 * result + (this.indices == null ? 0 : this.indices.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ArrayIndex other = (ArrayIndex)obj;
        if (this.array == null ? other.array != null : !this.array.equals(other.array)) {
            return false;
        }
        return this.indices.equals(other.indices);
    }

    public void setArrayIndices(List<Integer> indices) {
        this.indices = new ArrayList<Integer>();
        for (Integer i : indices) {
            this.indices.add(i);
        }
    }

    public List<Integer> getArrayIndices() {
        return this.indices;
    }
}

