/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testcase.variable;

import java.lang.reflect.Type;
import java.util.Map;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.execution.CodeUnderTestException;
import org.evosuite.testcase.execution.Scope;
import org.evosuite.testcase.statements.Statement;
import org.evosuite.testcase.variable.VariableReference;
import org.evosuite.utils.GenericClass;
import org.evosuite.utils.PassiveChangeListener;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VariableReferenceImpl
implements VariableReference {
    private static final long serialVersionUID = -2621368452798208805L;
    private int distance = 0;
    private static final Logger logger = LoggerFactory.getLogger(VariableReferenceImpl.class);
    protected GenericClass type;
    protected TestCase testCase;
    protected final PassiveChangeListener<Void> changeListener = new PassiveChangeListener();
    protected Integer stPosition;
    private String originalCode;

    public VariableReferenceImpl(TestCase testCase, GenericClass type) {
        this.testCase = testCase;
        this.type = type;
        testCase.addListener(this.changeListener);
    }

    public VariableReferenceImpl(TestCase testCase, Type type) {
        this(testCase, new GenericClass(type));
    }

    @Override
    public int getStPosition() {
        if (this.stPosition == null || this.changeListener.hasChanged()) {
            this.stPosition = null;
            for (int i = 0; i < this.testCase.size(); ++i) {
                Statement stmt = this.testCase.getStatement(i);
                if (!stmt.getReturnValue().equals(this)) continue;
                this.stPosition = i;
                break;
            }
            if (this.stPosition == null) {
                String msg = "Bloody annoying bug \n";
                msg = msg + "Test case has " + this.testCase.size() + " function calls \n";
                for (int i = 0; i < this.testCase.size(); ++i) {
                    msg = msg + this.testCase.getStatement(i).getCode(null) + "\n";
                }
                msg = msg + "failed to find type " + this.type.getTypeName() + "\n";
                throw new AssertionError((Object)(msg + "A VariableReferences position is only defined if the VariableReference is defined by a statement in the testCase"));
            }
        } else {
            int position = this.stPosition;
            this.stPosition = null;
            this.stPosition = this.getStPosition();
            assert (this.stPosition == position);
        }
        return this.stPosition;
    }

    @Override
    public VariableReference clone() {
        throw new UnsupportedOperationException("This method SHOULD not be used, as only the original reference is keeped up to date");
    }

    @Override
    public VariableReference clone(TestCase newTestCase) {
        return newTestCase.getStatement(this.getStPosition()).getReturnValue();
    }

    @Override
    public VariableReference copy(TestCase newTestCase, int offset) {
        return newTestCase.getStatement(this.getStPosition() + offset).getReturnValue();
    }

    @Override
    public String getSimpleClassName() {
        if (this.type.isPrimitive() || this.type.isArray() && new GenericClass(this.type.getComponentType()).isPrimitive()) {
            return this.type.getRawClass().getSimpleName();
        }
        return this.type.getSimpleName();
    }

    @Override
    public String getClassName() {
        return this.type.getClassName();
    }

    @Override
    public String getComponentName() {
        return this.type.getComponentName();
    }

    @Override
    public Type getComponentType() {
        return this.type.getComponentType();
    }

    @Override
    public boolean isEnum() {
        return this.type.isEnum();
    }

    @Override
    public boolean isArray() {
        return this.type.isArray();
    }

    @Override
    public boolean isArrayIndex() {
        return false;
    }

    @Override
    public boolean isPrimitive() {
        return this.type.isPrimitive();
    }

    @Override
    public boolean isVoid() {
        return this.type.isVoid();
    }

    @Override
    public boolean isString() {
        return this.type.isString();
    }

    @Override
    public boolean isWrapperType() {
        return this.type.isWrapperType();
    }

    @Override
    public boolean isAccessible() {
        return true;
    }

    @Override
    public boolean isAssignableFrom(Type other) {
        return this.type.isAssignableFrom(other);
    }

    @Override
    public boolean isAssignableTo(Type other) {
        return this.type.isAssignableTo(other);
    }

    @Override
    public boolean isAssignableFrom(VariableReference other) {
        return this.type.isAssignableFrom(other.getType());
    }

    @Override
    public boolean isAssignableTo(VariableReference other) {
        return this.type.isAssignableTo(other.getType());
    }

    @Override
    public Type getType() {
        return this.type.getType();
    }

    @Override
    public void setType(Type type) {
        this.type = new GenericClass(type);
    }

    @Override
    public Class<?> getVariableClass() {
        return this.type.getRawClass();
    }

    @Override
    public Class<?> getComponentClass() {
        return this.type.getRawClass().getComponentType();
    }

    @Override
    public Object getObject(Scope scope) throws CodeUnderTestException {
        return scope.getObject(this);
    }

    @Override
    public String getOriginalCode() {
        return this.originalCode;
    }

    @Override
    public void setObject(Scope scope, Object value) throws CodeUnderTestException {
        scope.setObject(this, value);
    }

    @Override
    public void setOriginalCode(String code) {
        if (this.originalCode != null) {
            logger.debug("Original code already set to '{}', skip setting it to '{}'.", (Object)this.originalCode, (Object)code);
            return;
        }
        if (code != null) {
            this.originalCode = code.trim();
        }
    }

    @Override
    public String toString() {
        if (this.originalCode != null) {
            return this.originalCode;
        }
        return "VariableReference: Statement " + this.getStPosition() + ", type " + this.type.getTypeName();
    }

    @Override
    public String getName() {
        return "var" + this.getStPosition();
    }

    @Override
    public void loadBytecode(GeneratorAdapter mg, Map<Integer, Integer> locals) {
        logger.debug("Loading variable in bytecode: " + this.getStPosition());
        if (this.getStPosition() < 0) {
            mg.visitInsn(1);
        } else {
            mg.loadLocal(locals.get(this.getStPosition()).intValue(), org.objectweb.asm.Type.getType(this.type.getRawClass()));
        }
    }

    @Override
    public void storeBytecode(GeneratorAdapter mg, Map<Integer, Integer> locals) {
        logger.debug("Storing variable in bytecode: " + this.getStPosition() + " of type " + org.objectweb.asm.Type.getType(this.type.getRawClass()));
        if (!locals.containsKey(this.getStPosition())) {
            locals.put(this.getStPosition(), mg.newLocal(org.objectweb.asm.Type.getType(this.type.getRawClass())));
        }
        mg.storeLocal(locals.get(this.getStPosition()).intValue(), org.objectweb.asm.Type.getType(this.type.getRawClass()));
    }

    @Override
    public Object getDefaultValue() {
        if (this.isVoid()) {
            return null;
        }
        if (this.type.isString()) {
            return "";
        }
        if (this.isPrimitive()) {
            if (this.type.getRawClass().equals(Float.TYPE)) {
                return Float.valueOf(0.0f);
            }
            if (this.type.getRawClass().equals(Long.TYPE)) {
                return 0L;
            }
            if (this.type.getRawClass().equals(Boolean.TYPE)) {
                return false;
            }
            return 0;
        }
        return null;
    }

    @Override
    public String getDefaultValueString() {
        if (this.isVoid()) {
            return "";
        }
        if (this.type.isString()) {
            return "\"\"";
        }
        if (this.isPrimitive()) {
            if (this.type.getRawClass().equals(Float.TYPE)) {
                return "0.0F";
            }
            if (this.type.getRawClass().equals(Long.TYPE)) {
                return "0L";
            }
            if (this.type.getRawClass().equals(Boolean.TYPE)) {
                return "false";
            }
            return "0";
        }
        return "null";
    }

    @Override
    public int compareTo(VariableReference other) {
        return this.getStPosition() - other.getStPosition();
    }

    @Override
    public boolean same(VariableReference r) {
        if (r == null) {
            return false;
        }
        if (this.getStPosition() != r.getStPosition()) {
            return false;
        }
        return this.type.equals(r.getGenericClass());
    }

    @Override
    public GenericClass getGenericClass() {
        return this.type;
    }

    @Override
    public VariableReference getAdditionalVariableReference() {
        return null;
    }

    @Override
    public void setAdditionalVariableReference(VariableReference var) {
    }

    @Override
    public void replaceAdditionalVariableReference(VariableReference var1, VariableReference var2) {
    }

    @Override
    public int getDistance() {
        return this.distance;
    }

    @Override
    public void setDistance(int distance) {
        this.distance = distance;
    }

    @Override
    public void changeClassLoader(ClassLoader loader) {
        this.type.changeClassLoader(loader);
    }
}

