/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testsuite;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.evosuite.Properties;
import org.evosuite.ga.Chromosome;
import org.evosuite.ga.ChromosomeFactory;
import org.evosuite.ga.SecondaryObjective;
import org.evosuite.ga.localsearch.LocalSearchObjective;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.TestChromosome;
import org.evosuite.testcase.TestFitnessFunction;
import org.evosuite.testcase.execution.TestCaseExecutor;
import org.evosuite.testsuite.AbstractTestSuiteChromosome;
import org.evosuite.testsuite.localsearch.TestSuiteLocalSearch;

public class TestSuiteChromosome
extends AbstractTestSuiteChromosome<TestChromosome> {
    private static final List<SecondaryObjective<?>> secondaryObjectives = new ArrayList();
    private static int secondaryObjIndex = 0;
    private static final long serialVersionUID = 88380759969800800L;

    public static void addSecondaryObjective(SecondaryObjective<?> objective) {
        secondaryObjectives.add(objective);
    }

    public static void ShuffleSecondaryObjective() {
        Collections.shuffle(secondaryObjectives);
    }

    public static int getSecondaryObjectivesSize() {
        return secondaryObjectives.size();
    }

    public static boolean isFirstSecondaryObjectiveEnabled() {
        return secondaryObjIndex == 0;
    }

    public static void disableFirstSecondaryObjective() {
        if (secondaryObjIndex != 1) {
            secondaryObjIndex = 1;
        }
    }

    public static void enableFirstSecondaryObjective() {
        if (secondaryObjIndex != 0) {
            secondaryObjIndex = 0;
        }
    }

    public static void reverseSecondaryObjective() {
        Collections.reverse(secondaryObjectives);
    }

    public static void removeSecondaryObjective(SecondaryObjective<TestSuiteChromosome> objective) {
        secondaryObjectives.remove(objective);
    }

    public TestSuiteChromosome() {
    }

    public TestSuiteChromosome(ChromosomeFactory<TestChromosome> testChromosomeFactory) {
        super(testChromosomeFactory);
    }

    protected TestSuiteChromosome(TestSuiteChromosome source) {
        super(source);
    }

    public TestChromosome addTest(TestCase test) {
        TestChromosome c = new TestChromosome();
        c.setTestCase(test);
        this.addTest(c);
        return c;
    }

    public void clearMutationHistory() {
        for (TestChromosome test : this.tests) {
            test.getMutationHistory().clear();
        }
    }

    public void clearTests() {
        this.tests.clear();
        this.unmodifiableTests.clear();
    }

    @Override
    public TestSuiteChromosome clone() {
        return new TestSuiteChromosome(this);
    }

    @Override
    public <T extends Chromosome> int compareSecondaryObjective(T o) {
        SecondaryObjective<?> so;
        int objective = secondaryObjIndex;
        int c = 0;
        while (c == 0 && objective < secondaryObjectives.size() && (so = secondaryObjectives.get(objective++)) != null) {
            c = so.compareChromosomes(this, o);
        }
        return c;
    }

    @Override
    public void deleteTest(TestCase testCase) {
        if (testCase != null) {
            for (int i = 0; i < this.tests.size(); ++i) {
                if (!((TestChromosome)this.tests.get(i)).getTestCase().equals(testCase)) continue;
                this.tests.remove(i);
                this.unmodifiableTests.remove(i);
            }
        }
    }

    public Set<TestFitnessFunction> getCoveredGoals() {
        HashSet<TestFitnessFunction> goals = new HashSet<TestFitnessFunction>();
        for (TestChromosome test : this.tests) {
            goals.addAll(test.getTestCase().getCoveredGoals());
        }
        return goals;
    }

    public List<TestCase> getTests() {
        ArrayList<TestCase> testcases = new ArrayList<TestCase>();
        for (TestChromosome test : this.tests) {
            testcases.add(test.getTestCase());
        }
        return testcases;
    }

    public boolean isUnmodifiable(TestChromosome test) {
        return this.unmodifiableTests.contains(test);
    }

    @Override
    public boolean localSearch(LocalSearchObjective<? extends Chromosome> objective) {
        TestSuiteLocalSearch localSearch = TestSuiteLocalSearch.getLocalSearch();
        return localSearch.doSearch(this, objective);
    }

    @Override
    public void mutate() {
        for (int i = 0; i < Properties.NUMBER_OF_MUTATIONS; ++i) {
            super.mutate();
        }
    }

    public void restoreTests(ArrayList<TestCase> backup) {
        this.tests.clear();
        this.unmodifiableTests.clear();
        TestCaseExecutor executor = TestCaseExecutor.getInstance();
        for (TestCase testCase : backup) {
            this.addTest(testCase);
            executor.execute(testCase);
        }
    }

    public String toString() {
        String result = "TestSuite: " + this.tests.size() + "\n";
        int i = 0;
        for (TestChromosome test : this.tests) {
            result = result + "Test " + i + ": \n";
            ++i;
            result = result + test.getTestCase().toCode() + "\n";
        }
        return result;
    }
}

