/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testsuite.localsearch;

import java.util.List;
import org.evosuite.Properties;
import org.evosuite.ga.localsearch.LocalSearchBudget;
import org.evosuite.ga.localsearch.LocalSearchObjective;
import org.evosuite.testcase.TestChromosome;
import org.evosuite.testsuite.TestSuiteChromosome;
import org.evosuite.testsuite.TestSuiteFitnessFunction;
import org.evosuite.testsuite.localsearch.TestSuiteDSE;
import org.evosuite.testsuite.localsearch.TestSuiteLocalSearch;
import org.evosuite.testsuite.localsearch.TestSuiteLocalSearchObjective;
import org.evosuite.utils.Randomness;

public class StandardTestSuiteLocalSearch
extends TestSuiteLocalSearch {
    @Override
    public boolean doSearch(TestSuiteChromosome individual, LocalSearchObjective<TestSuiteChromosome> objective) {
        List tests = individual.getTestChromosomes();
        Randomness.shuffle(tests);
        if (Properties.LOCAL_SEARCH_ENSURE_DOUBLE_EXECUTION) {
            this.ensureDoubleExecution(individual, (TestSuiteFitnessFunction)objective.getFitnessFunction());
        }
        if (Properties.LOCAL_SEARCH_RESTORE_COVERAGE) {
            this.restoreBranchCoverage(individual, (TestSuiteFitnessFunction)objective.getFitnessFunction());
        }
        if (Properties.LOCAL_SEARCH_EXPAND_TESTS) {
            this.expandTestSuite(individual);
        }
        double fitnessBefore = individual.getFitness();
        if (Properties.LOCAL_SEARCH_DSE == Properties.DSEType.SUITE && Randomness.nextDouble() < Properties.DSE_PROBABILITY) {
            this.doDSESearch(individual, objective);
        } else {
            this.doRegularSearch(individual, objective);
        }
        LocalSearchBudget.getInstance().countLocalSearchOnTestSuite();
        return objective.getFitnessFunction().isMaximizationFunction() ? fitnessBefore > individual.getFitness() : fitnessBefore < individual.getFitness();
    }

    private void doRegularSearch(TestSuiteChromosome individual, LocalSearchObjective<TestSuiteChromosome> objective) {
        List tests = individual.getTestChromosomes();
        for (int i = 0; i < tests.size(); ++i) {
            TestChromosome test = (TestChromosome)tests.get(i);
            if (individual.isUnmodifiable(test)) continue;
            logger.debug("Local search on test " + i + ", current fitness: " + individual.getFitness());
            TestSuiteLocalSearchObjective testObjective = new TestSuiteLocalSearchObjective((TestSuiteFitnessFunction)objective.getFitnessFunction(), individual, i);
            if (LocalSearchBudget.getInstance().isFinished()) {
                logger.debug("Local search budget used up: " + (Object)((Object)Properties.LOCAL_SEARCH_BUDGET_TYPE));
                break;
            }
            logger.debug("Local search budget not yet used up");
            test.localSearch(testObjective);
        }
    }

    protected void doDSESearch(TestSuiteChromosome individual, LocalSearchObjective<TestSuiteChromosome> objective) {
        TestSuiteDSE dse = new TestSuiteDSE();
        dse.applyDSE(individual, (TestSuiteFitnessFunction)objective.getFitnessFunction());
    }
}

