/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testsuite.localsearch;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import org.evosuite.Properties;
import org.evosuite.ga.localsearch.LocalSearchBudget;
import org.evosuite.ga.localsearch.LocalSearchObjective;
import org.evosuite.symbolic.BranchCondition;
import org.evosuite.symbolic.ConcolicExecution;
import org.evosuite.symbolic.DSEStats;
import org.evosuite.symbolic.expr.Constraint;
import org.evosuite.symbolic.expr.Expression;
import org.evosuite.symbolic.expr.Variable;
import org.evosuite.symbolic.solver.ConstraintCache;
import org.evosuite.symbolic.solver.Solver;
import org.evosuite.symbolic.solver.SolverFactory;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.TestChromosome;
import org.evosuite.testcase.statements.PrimitiveStatement;
import org.evosuite.testcase.statements.Statement;
import org.evosuite.testsuite.TestSuiteChromosome;
import org.evosuite.testsuite.TestSuiteFitnessFunction;
import org.evosuite.testsuite.localsearch.TestSuiteLocalSearch;
import org.evosuite.utils.Randomness;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestSuiteDSE
extends TestSuiteLocalSearch {
    private static final Logger logger = LoggerFactory.getLogger(TestSuiteDSE.class);
    public static int nrConstraints = 0;
    public static int nrSolvedConstraints = 0;
    private int nrCurrConstraints = 0;
    public static int success = 0;
    public static int failed = 0;
    private final Map<TestChromosome, List<BranchCondition>> branchConditions = new HashMap<TestChromosome, List<BranchCondition>>();
    private final Set<BranchCondition> unsolvableBranchConditions = new HashSet<BranchCondition>();
    private final Map<String, Integer> solutionAttempts = new HashMap<String, Integer>();
    private final Collection<TestBranchPair> unsolvedBranchConditions = Properties.DSE_RANK_BRANCH_CONDITIONS ? new PriorityQueue<TestBranchPair>() : new ArrayList<TestBranchPair>();

    private void calculateUncoveredBranches() {
        this.unsolvedBranchConditions.clear();
        if (Properties.DSE_NEGATE_ALL_CONDITIONS) {
            for (TestChromosome testChromosome : this.branchConditions.keySet()) {
                for (BranchCondition branchCondition : this.branchConditions.get(testChromosome)) {
                    if (this.unsolvableBranchConditions.contains(branchCondition)) continue;
                    this.unsolvedBranchConditions.add(new TestBranchPair(testChromosome, branchCondition));
                }
            }
        } else {
            HashMap solvedConstraints = new HashMap();
            for (TestChromosome test : this.branchConditions.keySet()) {
                for (BranchCondition branch : this.branchConditions.get(test)) {
                    if (this.unsolvableBranchConditions.contains(branch)) continue;
                    String index = this.getBranchIndex(branch);
                    if (!solvedConstraints.containsKey(index)) {
                        solvedConstraints.put(index, new HashMap());
                    }
                    Constraint<?> c = branch.getLocalConstraint();
                    if (!((Map)solvedConstraints.get(index)).containsKey((Object)c.getComparator())) {
                        ((Map)solvedConstraints.get(index)).put(c.getComparator(), new HashSet());
                    }
                    ((Set)((Map)solvedConstraints.get(index)).get((Object)c.getComparator())).add(new TestBranchPair(test, branch));
                }
            }
            for (String index : solvedConstraints.keySet()) {
                if (((Map)solvedConstraints.get(index)).size() != 1) continue;
                Set branches = (Set)((Map)solvedConstraints.get(index)).values().iterator().next();
                this.unsolvedBranchConditions.addAll(branches);
            }
            logger.info("Update set of unsolved branch conditions to " + this.unsolvedBranchConditions.size());
            if (!Properties.DSE_RANK_BRANCH_CONDITIONS) {
                Randomness.shuffle((ArrayList)this.unsolvedBranchConditions);
            }
        }
    }

    private void updatePathConstraints(TestChromosome test) {
        List<BranchCondition> branches = ConcolicExecution.getSymbolicPath(test);
        this.branchConditions.put(test, branches);
    }

    private void createPathConstraints(TestSuiteChromosome testSuite) {
        for (TestChromosome test : testSuite.getTestChromosomes()) {
            this.updatePathConstraints(test);
        }
        this.calculateUncoveredBranches();
    }

    private String getBranchIndex(BranchCondition branch) {
        return branch.getFullName() + branch.getInstructionIndex();
    }

    private TestBranchPair getNextBranchCondition() {
        TestBranchPair pair = this.getNextTestBranchPair();
        if (Properties.DSE_NEGATE_ALL_CONDITIONS) {
            return pair;
        }
        String index = this.getBranchIndex(pair.branch);
        if (!this.unsolvedBranchConditions.isEmpty()) {
            while (this.solutionAttempts.containsKey(index) && this.solutionAttempts.get(index) >= Properties.CONSTRAINT_SOLUTION_ATTEMPTS && !this.unsolvedBranchConditions.isEmpty()) {
                logger.info("Reached maximum number of attempts for branch " + index);
                pair = this.getNextTestBranchPair();
                index = this.getBranchIndex(pair.branch);
            }
        }
        if (!this.solutionAttempts.containsKey(index)) {
            this.solutionAttempts.put(index, 1);
        } else {
            this.solutionAttempts.put(index, this.solutionAttempts.get(index) + 1);
        }
        return pair;
    }

    private TestBranchPair getNextTestBranchPair() {
        TestBranchPair pair = Properties.DSE_RANK_BRANCH_CONDITIONS ? (TestBranchPair)((PriorityQueue)this.unsolvedBranchConditions).poll() : (TestBranchPair)((ArrayList)this.unsolvedBranchConditions).remove(0);
        return pair;
    }

    private boolean hasNextBranchCondition() {
        return !this.unsolvedBranchConditions.isEmpty();
    }

    private TestCase negateCondition(Set<Constraint<?>> reachingConstraints, Constraint<?> localConstraint, TestCase test) {
        List<Constraint<?>> constraints = new LinkedList();
        constraints.addAll(reachingConstraints);
        Constraint<?> targetConstraint = localConstraint.negate();
        constraints.add(targetConstraint);
        if (!targetConstraint.isSolveable()) {
            logger.info("Found unsolvable constraint: " + targetConstraint);
            return null;
        }
        int size = constraints.size();
        if (size > 0) {
            logger.debug("Calculating cone of influence for " + size + " constraints");
            constraints = this.reduce(constraints);
            logger.info("Reduced constraints from " + size + " to " + constraints.size());
        }
        this.nrCurrConstraints = constraints.size();
        nrConstraints += this.nrCurrConstraints;
        logger.info("Applying local search");
        Solver solver = SolverFactory.getInstance().buildNewSolver();
        DSEStats.reportNewConstraints(constraints);
        long startSolvingTime = System.currentTimeMillis();
        Map<String, Object> values = ConstraintCache.getInstance().solve(solver, constraints);
        long estimatedSolvingTime = System.currentTimeMillis() - startSolvingTime;
        DSEStats.reportNewSolvingTime(estimatedSolvingTime);
        if (values != null && !values.isEmpty()) {
            DSEStats.reportNewSAT();
            TestCase newTest = test.clone();
            for (String key : values.keySet()) {
                Object val = values.get(key);
                if (val != null) {
                    PrimitiveStatement<?> p;
                    String name;
                    Number value;
                    logger.info("New value: " + key + ": " + val);
                    if (val instanceof Long) {
                        value = (Long)val;
                        name = key.replace("__SYM", "");
                        p = this.getStatement(newTest, name);
                        if (p.getValue().getClass().equals(Character.class)) {
                            p.setValue(Character.valueOf((char)((Long)value).intValue()));
                            continue;
                        }
                        if (p.getValue().getClass().equals(Long.class)) {
                            p.setValue(value);
                            continue;
                        }
                        if (p.getValue().getClass().equals(Integer.class)) {
                            p.setValue(((Long)value).intValue());
                            continue;
                        }
                        if (p.getValue().getClass().equals(Short.class)) {
                            p.setValue(((Long)value).shortValue());
                            continue;
                        }
                        if (p.getValue().getClass().equals(Boolean.class)) {
                            p.setValue(((Long)value).intValue() > 0);
                            continue;
                        }
                        if (p.getValue().getClass().equals(Byte.class)) {
                            p.setValue(((Long)value).byteValue() > 0);
                            continue;
                        }
                        logger.warn("New value is of an unsupported type: " + p.getValue().getClass() + val);
                        continue;
                    }
                    if (val instanceof String) {
                        String name2 = key.replace("__SYM", "");
                        PrimitiveStatement<?> p2 = this.getStatement(newTest, name2);
                        assert (p2 != null) : "Could not find variable " + name2 + " in test: " + newTest.toCode() + " / Orig test: " + test.toCode() + ", seed: " + Randomness.getSeed();
                        if (p2.getValue().getClass().equals(Character.class)) {
                            p2.setValue(Character.valueOf((char)Integer.parseInt(val.toString())));
                            continue;
                        }
                        p2.setValue(val.toString());
                        continue;
                    }
                    if (val instanceof Double) {
                        value = (Double)val;
                        name = key.replace("__SYM", "");
                        p = this.getStatement(newTest, name);
                        assert (p != null) : "Could not find variable " + name + " in test: " + newTest.toCode() + " / Orig test: " + test.toCode() + ", seed: " + Randomness.getSeed();
                        if (p.getValue().getClass().equals(Double.class)) {
                            p.setValue(value);
                            continue;
                        }
                        if (p.getValue().getClass().equals(Float.class)) {
                            p.setValue(Float.valueOf(((Double)value).floatValue()));
                            continue;
                        }
                        logger.warn("New value is of an unsupported type: " + val);
                        continue;
                    }
                    logger.debug("New value is of an unsupported type: " + val);
                    continue;
                }
                logger.debug("New value is null");
            }
            return newTest;
        }
        logger.info("Found no solution");
        DSEStats.reportNewUNSAT();
        return null;
    }

    private PrimitiveStatement<?> getStatement(TestCase test, String name) {
        for (Statement statement : test) {
            if (!(statement instanceof PrimitiveStatement) || !statement.getReturnValue().getName().equals(name)) continue;
            return (PrimitiveStatement)statement;
        }
        return null;
    }

    private List<Constraint<?>> reduce(List<Constraint<?>> constraints) {
        Constraint<?> target = constraints.get(constraints.size() - 1);
        Set<Variable<?>> dependencies = this.getVariables(target);
        LinkedList coi = new LinkedList();
        if (dependencies.size() <= 0) {
            return coi;
        }
        coi.add(target);
        block0: for (int i = constraints.size() - 2; i >= 0; --i) {
            Constraint<?> constraint = constraints.get(i);
            Set<Variable<?>> variables = this.getVariables(constraint);
            for (Variable<?> var : dependencies) {
                if (!variables.contains(var)) continue;
                dependencies.addAll(variables);
                coi.addFirst(constraint);
                continue block0;
            }
        }
        return coi;
    }

    private Set<Variable<?>> getVariables(Constraint<?> constraint) {
        HashSet variables = new HashSet();
        TestSuiteDSE.getVariables(constraint.getLeftOperand(), variables);
        TestSuiteDSE.getVariables(constraint.getRightOperand(), variables);
        return variables;
    }

    public static void getVariables(Expression<?> expr, Set<Variable<?>> variables) {
        variables.addAll(expr.getVariables());
    }

    @Override
    public boolean doSearch(TestSuiteChromosome individual, LocalSearchObjective<TestSuiteChromosome> objective) {
        return this.applyDSE(individual, (TestSuiteFitnessFunction)objective.getFitnessFunction());
    }

    public boolean applyDSE(TestSuiteChromosome individual, TestSuiteFitnessFunction fitness) {
        logger.info("[DSE] Current test suite: " + individual.toString());
        boolean wasSuccess = false;
        TestSuiteChromosome expandedTests = this.expandTestSuite(individual);
        this.createPathConstraints(expandedTests);
        fitness.getFitness(expandedTests);
        double originalFitness = individual.getFitness(fitness);
        while (this.hasNextBranchCondition() && !LocalSearchBudget.getInstance().isFinished()) {
            logger.info("Branches remaining: " + this.unsolvedBranchConditions.size());
            TestBranchPair next = this.getNextBranchCondition();
            BranchCondition branch = next.branch;
            TestCase newTest = this.negateCondition(branch.getReachingConstraints(), branch.getLocalConstraint(), next.test.getTestCase());
            if (newTest != null) {
                logger.info("Found new test: " + newTest.toCode());
                TestChromosome newTestChromosome = new TestChromosome();
                newTestChromosome.setTestCase(newTest);
                expandedTests.addTest(newTestChromosome);
                if (Properties.DSE_KEEP_ALL_TESTS) {
                    this.updatePathConstraints(newTestChromosome);
                    this.calculateUncoveredBranches();
                    individual.addTest(newTest);
                    wasSuccess = true;
                } else if (fitness.getFitness(expandedTests) < originalFitness) {
                    logger.info("New test improves fitness to {}", (Object)expandedTests.getFitness(fitness));
                    DSEStats.reportNewTestUseful();
                    wasSuccess = true;
                    this.updatePathConstraints(newTestChromosome);
                    this.calculateUncoveredBranches(newTestChromosome);
                    individual.addTest(newTest);
                    originalFitness = expandedTests.getFitness(fitness);
                } else {
                    logger.info("New test does not improve fitness");
                    DSEStats.reportNewTestUnuseful();
                    expandedTests.deleteTest(newTest);
                }
                ++success;
                continue;
            }
            this.unsolvableBranchConditions.add(branch);
            ++failed;
            logger.info("Failed to find new test.");
        }
        logger.info("Finished DSE");
        fitness.getFitness(individual);
        LocalSearchBudget.getInstance().countLocalSearchOnTestSuite();
        return wasSuccess;
    }

    private void calculateUncoveredBranches(TestChromosome newTestChromosome) {
        if (Properties.DSE_NEGATE_ALL_CONDITIONS) {
            for (BranchCondition branchCondition : this.branchConditions.get(newTestChromosome)) {
                if (this.unsolvableBranchConditions.contains(branchCondition)) continue;
                this.unsolvedBranchConditions.add(new TestBranchPair(newTestChromosome, branchCondition));
            }
        } else {
            this.calculateUncoveredBranches();
        }
    }

    private class TestBranchPair
    implements Comparable<TestBranchPair> {
        TestChromosome test;
        BranchCondition branch;
        private final double ranking;

        TestBranchPair(TestChromosome test, BranchCondition branchCondition) {
            this.test = test;
            this.branch = branchCondition;
            this.ranking = this.computeRanking(branchCondition);
        }

        private double computeRanking(BranchCondition condition) {
            int length = 1 + condition.getReachingConstraints().size();
            int totalSize = 0;
            for (Constraint<?> constraint : condition.getReachingConstraints()) {
                totalSize += constraint.getSize();
            }
            double avg_size = (double)totalSize / (double)condition.getReachingConstraints().size();
            double ranking = (double)length * avg_size;
            return ranking;
        }

        @Override
        public int compareTo(TestBranchPair arg0) {
            return Double.compare(this.ranking, arg0.ranking);
        }
    }
}

