/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testsuite.localsearch;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.evosuite.Properties;
import org.evosuite.ga.localsearch.LocalSearch;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.TestCaseExpander;
import org.evosuite.testcase.TestChromosome;
import org.evosuite.testcase.execution.ExecutionResult;
import org.evosuite.testcase.execution.TestCaseExecutor;
import org.evosuite.testcase.localsearch.BranchCoverageMap;
import org.evosuite.testsuite.TestSuiteChromosome;
import org.evosuite.testsuite.TestSuiteFitnessFunction;
import org.evosuite.testsuite.localsearch.SelectiveTestSuiteLocalSearch;
import org.evosuite.testsuite.localsearch.StandardTestSuiteLocalSearch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TestSuiteLocalSearch
implements LocalSearch<TestSuiteChromosome> {
    protected static final Logger logger = LoggerFactory.getLogger(TestSuiteLocalSearch.class);

    public static TestSuiteLocalSearch getLocalSearch() {
        if (Properties.LOCAL_SEARCH_SELECTIVE) {
            return new SelectiveTestSuiteLocalSearch();
        }
        return new StandardTestSuiteLocalSearch();
    }

    protected TestSuiteChromosome expandTestSuite(TestSuiteChromosome individual) {
        logger.debug("Expanding tests for local search");
        TestSuiteChromosome newTestSuite = new TestSuiteChromosome();
        for (TestChromosome test : individual.getTestChromosomes()) {
            if (test.getLastExecutionResult() == null || test.isChanged()) {
                test.setLastExecutionResult(TestCaseExecutor.runTest(test.getTestCase()));
                test.setChanged(false);
            }
            if (test.getLastExecutionResult().hasTimeout() || test.getLastExecutionResult().hasTestException()) {
                logger.info("Skipping test with timeout or exception");
                continue;
            }
            TestCase newTest = test.getTestCase().clone();
            TestCase expandedTest = this.expandTestCase(newTest);
            newTestSuite.addTest(expandedTest);
        }
        List oldTests = individual.getTestChromosomes();
        oldTests.clear();
        oldTests.addAll(newTestSuite.getTestChromosomes());
        return newTestSuite;
    }

    private TestCase expandTestCase(TestCase test) {
        if (!Properties.LOCAL_SEARCH_EXPAND_TESTS) {
            return test;
        }
        TestCaseExpander expander = new TestCaseExpander();
        return expander.expandTestCase(test);
    }

    protected void ensureDoubleExecution(TestSuiteChromosome individual, TestSuiteFitnessFunction objective) {
        logger.debug("Ensuring double execution");
        HashSet<TestChromosome> duplicates = new HashSet<TestChromosome>();
        HashMap<Integer, Integer> covered = new HashMap<Integer, Integer>();
        HashMap<Integer, TestChromosome> testMap = new HashMap<Integer, TestChromosome>();
        for (TestChromosome testChromosome : individual.getTestChromosomes()) {
            if (testChromosome.getLastExecutionResult() == null || testChromosome.isChanged()) {
                ExecutionResult result = testChromosome.executeForFitnessFunction(objective);
                testChromosome.setLastExecutionResult(result);
                testChromosome.setChanged(false);
            }
            for (Map.Entry<Integer, Integer> entry : testChromosome.getLastExecutionResult().getTrace().getPredicateExecutionCount().entrySet()) {
                if (!covered.containsKey(entry.getKey())) {
                    covered.put(entry.getKey(), 0);
                }
                covered.put(entry.getKey(), (Integer)covered.get(entry.getKey()) + entry.getValue());
                testMap.put(entry.getKey(), testChromosome);
            }
        }
        for (Map.Entry entry : covered.entrySet()) {
            int branchId = (Integer)entry.getKey();
            int count = (Integer)entry.getValue();
            if (count != 1) continue;
            TestChromosome duplicate = (TestChromosome)((TestChromosome)testMap.get(branchId)).clone();
            ExecutionResult result = duplicate.executeForFitnessFunction(objective);
            duplicate.setLastExecutionResult(result);
            duplicate.setChanged(false);
            duplicates.add(duplicate);
        }
        if (!duplicates.isEmpty()) {
            logger.info("Adding " + duplicates.size() + " tests to cover branches sufficiently");
            for (TestChromosome testChromosome : duplicates) {
                individual.addTest(testChromosome);
            }
            individual.setChanged(true);
            objective.getFitness(individual);
        }
    }

    private Set<Integer> getCoveredTrueBranches(TestSuiteChromosome suite) {
        LinkedHashSet<Integer> covered = new LinkedHashSet<Integer>();
        for (TestChromosome testChromosome : suite.getTestChromosomes()) {
            ExecutionResult lastResult = testChromosome.getLastExecutionResult();
            if (lastResult == null) continue;
            covered.addAll(lastResult.getTrace().getCoveredTrueBranches());
        }
        return covered;
    }

    private Set<Integer> getCoveredFalseBranches(TestSuiteChromosome suite) {
        LinkedHashSet<Integer> covered = new LinkedHashSet<Integer>();
        for (TestChromosome testChromosome : suite.getTestChromosomes()) {
            ExecutionResult lastResult = testChromosome.getLastExecutionResult();
            if (lastResult == null) continue;
            covered.addAll(lastResult.getTrace().getCoveredFalseBranches());
        }
        return covered;
    }

    protected void restoreBranchCoverage(TestSuiteChromosome individual, TestSuiteFitnessFunction objective) {
        logger.debug("Adding branches already covered previously");
        BranchCoverageMap branchMap = BranchCoverageMap.getInstance();
        LinkedHashSet<Integer> uncoveredTrueBranches = new LinkedHashSet<Integer>(branchMap.getCoveredTrueBranches());
        LinkedHashSet<Integer> uncoveredFalseBranches = new LinkedHashSet<Integer>(branchMap.getCoveredFalseBranches());
        uncoveredTrueBranches.removeAll(this.getCoveredTrueBranches(individual));
        uncoveredFalseBranches.removeAll(this.getCoveredFalseBranches(individual));
        for (Integer branchId : uncoveredTrueBranches) {
            individual.addTest(branchMap.getTestCoveringTrue(branchId).clone());
        }
        for (Integer branchId : uncoveredFalseBranches) {
            individual.addTest(branchMap.getTestCoveringFalse(branchId).clone());
        }
    }
}

