/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.utils;

import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Queue;
import java.util.Set;
import org.evosuite.Properties;
import org.evosuite.utils.RandomAccessQueue;
import org.evosuite.utils.Randomness;

public class DefaultRandomAccessQueue<T>
implements RandomAccessQueue<T> {
    private final Set<T> valueSet = new HashSet<T>();
    private final Queue<T> queue = new ArrayDeque<T>();

    @Override
    public void restrictedAdd(T value) {
        if (!this.valueSet.contains(value)) {
            this.queue.add(value);
            this.valueSet.add(value);
            this.reduceSize();
        }
    }

    private void reduceSize() {
        if (this.queue.size() > Properties.DYNAMIC_POOL_SIZE) {
            T value = this.queue.poll();
            this.valueSet.remove(value);
        }
    }

    @Override
    public T getRandomValue() {
        return Randomness.choice(this.valueSet);
    }

    public String toString() {
        String res = new String("[ ");
        for (Object element : this.queue) {
            res = res + element + " ";
        }
        res = res + "]";
        return res;
    }
}

