/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.utils;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.evosuite.utils.GenericArrayTypeImpl;
import org.evosuite.utils.GenericClass;
import org.evosuite.utils.ParameterizedTypeImpl;
import org.evosuite.utils.WildcardTypeImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericUtils {
    private static final Logger logger = LoggerFactory.getLogger(GenericUtils.class);

    public static boolean isAssignable(Type type, TypeVariable<?> typeVariable) {
        boolean isAssignable = true;
        for (Type boundType : typeVariable.getBounds()) {
            Type resolvedBoundType = GenericUtils.replaceTypeVariable(boundType, typeVariable, type);
            if (GenericClass.isAssignable(resolvedBoundType, type)) continue;
            isAssignable = false;
            break;
        }
        return isAssignable;
    }

    public static Type replaceTypeVariables(Type targetType, Map<TypeVariable<?>, Type> typeMap) {
        Type returnType = targetType;
        for (TypeVariable<?> var : typeMap.keySet()) {
            returnType = GenericUtils.replaceTypeVariable(returnType, var, typeMap.get(var));
        }
        return returnType;
    }

    public static Type replaceTypeVariablesWithWildcards(Type targetType) {
        if (targetType instanceof TypeVariable) {
            TypeVariable typeVariable = (TypeVariable)targetType;
            return new WildcardTypeImpl(typeVariable.getBounds(), new Type[0]);
        }
        if (targetType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)targetType;
            Type owner = null;
            if (parameterizedType.getOwnerType() != null) {
                owner = GenericUtils.replaceTypeVariablesWithWildcards(parameterizedType.getOwnerType());
            }
            Type[] currentParameters = parameterizedType.getActualTypeArguments();
            Type[] parameters = new Type[currentParameters.length];
            for (int i = 0; i < parameters.length; ++i) {
                parameters[i] = GenericUtils.replaceTypeVariablesWithWildcards(currentParameters[i]);
            }
            return new ParameterizedTypeImpl((Class)parameterizedType.getRawType(), parameters, owner);
        }
        return targetType;
    }

    public static Type replaceTypeVariable(Type targetType, TypeVariable<?> variable, Type variableType) {
        if (targetType instanceof Class) {
            return targetType;
        }
        if (targetType instanceof GenericArrayType) {
            GenericArrayType gType = (GenericArrayType)targetType;
            Type componentType = GenericUtils.replaceTypeVariable(gType.getGenericComponentType(), variable, variableType);
            return GenericArrayTypeImpl.createArrayType(componentType);
        }
        if (targetType instanceof ParameterizedType) {
            ParameterizedType pType = (ParameterizedType)targetType;
            Type ownerType = null;
            if (pType.getOwnerType() != null) {
                ownerType = GenericUtils.replaceTypeVariable(pType.getOwnerType(), variable, variableType);
            }
            Type[] originalParameterTypes = pType.getActualTypeArguments();
            Type[] parameterTypes = new Type[originalParameterTypes.length];
            for (int i = 0; i < originalParameterTypes.length; ++i) {
                parameterTypes[i] = GenericUtils.replaceTypeVariable(originalParameterTypes[i], variable, variableType);
            }
            return new ParameterizedTypeImpl((Class)pType.getRawType(), parameterTypes, ownerType);
        }
        if (targetType instanceof WildcardType) {
            int i;
            WildcardType wType = (WildcardType)targetType;
            Type[] originalUpperBounds = wType.getUpperBounds();
            Type[] originalLowerBounds = wType.getLowerBounds();
            Type[] upperBounds = new Type[originalUpperBounds.length];
            Type[] lowerBounds = new Type[originalLowerBounds.length];
            for (i = 0; i < originalUpperBounds.length; ++i) {
                upperBounds[i] = GenericUtils.replaceTypeVariable(originalUpperBounds[i], variable, variableType);
            }
            for (i = 0; i < originalLowerBounds.length; ++i) {
                lowerBounds[i] = GenericUtils.replaceTypeVariable(originalLowerBounds[i], variable, variableType);
            }
            return new WildcardTypeImpl(upperBounds, lowerBounds);
        }
        if (targetType instanceof TypeVariable) {
            if (targetType.equals(variable)) {
                logger.debug("Do equal: " + variable + "/" + targetType);
                return variableType;
            }
            logger.debug("Do not equal: " + variable + "/" + targetType);
            logger.debug("Do not equal: " + variable.getGenericDeclaration() + "/" + ((TypeVariable)targetType).getGenericDeclaration());
            return targetType;
        }
        logger.debug("Unknown type of class " + targetType.getClass() + ": " + targetType);
        return targetType;
    }

    public Map<TypeVariable<?>, Type> getMatchingTypeParameters(GenericArrayType p1, GenericArrayType p2) {
        if (p1.getGenericComponentType() instanceof ParameterizedType && p2.getGenericComponentType() instanceof ParameterizedType) {
            return GenericUtils.getMatchingTypeParameters((ParameterizedType)p1.getGenericComponentType(), (ParameterizedType)p2.getGenericComponentType());
        }
        HashMap map = new HashMap();
        return map;
    }

    public static Map<TypeVariable<?>, Type> getMatchingTypeParameters(ParameterizedType p1, ParameterizedType p2) {
        logger.debug("Matching generic types between " + p1 + " and " + p2);
        HashMap map = new HashMap();
        if (!p1.getRawType().equals(p2.getRawType())) {
            logger.debug("Raw types do not match!");
            GenericClass ownerClass = new GenericClass(p2);
            if (GenericClass.isSubclass(p1.getRawType(), p2.getRawType())) {
                logger.debug(p1 + " is a super type of " + p2);
                Map commonsMap = TypeUtils.determineTypeArguments((Class)((Class)p2.getRawType()), (ParameterizedType)p1);
                logger.debug("Adding to map: " + commonsMap);
                for (TypeVariable t : map.keySet()) {
                    logger.debug(t + ": " + t.getGenericDeclaration());
                }
                TypeVariable<Class<T>>[] p2TypesA = ((Class)p2.getRawType()).getTypeParameters();
                Type[] p2TypesB = p2.getActualTypeArguments();
                for (int i = 0; i < p2TypesA.length; ++i) {
                    TypeVariable a = p2TypesA[i];
                    Type b = p2TypesB[i];
                    logger.debug("Should be mapping " + a + " and " + b);
                    if (a instanceof TypeVariable) {
                        logger.debug(a + " is a type variable: " + a.getGenericDeclaration());
                        if (b instanceof TypeVariable) {
                            logger.debug(b + " is a type variable: " + ((TypeVariable)b).getGenericDeclaration());
                            if (commonsMap.containsKey(a) && !(commonsMap.get(a) instanceof WildcardType) && !(commonsMap.get(a) instanceof TypeVariable)) {
                                map.put((TypeVariable)b, (Type)commonsMap.get(a));
                            }
                        }
                    }
                    logger.debug("Updated map: " + map);
                }
            }
            for (GenericClass interfaceClass : ownerClass.getInterfaces()) {
                if (interfaceClass.isParameterizedType()) {
                    map.putAll(GenericUtils.getMatchingTypeParameters(p1, (ParameterizedType)interfaceClass.getType()));
                    continue;
                }
                logger.debug("Interface " + interfaceClass + " is not parameterized");
            }
            if (ownerClass.getRawClass().getSuperclass() != null) {
                GenericClass ownerSuperClass = ownerClass.getSuperClass();
                if (ownerSuperClass.isParameterizedType()) {
                    map.putAll(GenericUtils.getMatchingTypeParameters(p1, (ParameterizedType)ownerSuperClass.getType()));
                } else {
                    logger.debug("Super type " + ownerSuperClass + " is not parameterized");
                }
            }
            return map;
        }
        for (int i = 0; i < p1.getActualTypeArguments().length; ++i) {
            Type t2;
            Type t1 = p1.getActualTypeArguments()[i];
            if (t1 == (t2 = p2.getActualTypeArguments()[i])) continue;
            logger.debug("First match: " + t1 + " - " + t2);
            if (t1 instanceof TypeVariable) {
                map.put((TypeVariable)t1, t2);
            }
            if (t2 instanceof TypeVariable) {
                map.put((TypeVariable)t2, t1);
            } else if (t2 instanceof ParameterizedType && t1 instanceof ParameterizedType) {
                map.putAll(GenericUtils.getMatchingTypeParameters((ParameterizedType)t1, (ParameterizedType)t2));
            }
            logger.debug("Updated map: " + map);
        }
        if (p1.getOwnerType() != null && p1.getOwnerType() instanceof ParameterizedType && p2.getOwnerType() instanceof ParameterizedType) {
            map.putAll(GenericUtils.getMatchingTypeParameters((ParameterizedType)p1.getOwnerType(), (ParameterizedType)p2.getOwnerType()));
        }
        return map;
    }
}

