/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.utils;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.util.StatusPrinter;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.PrintStream;
import java.io.UTFDataFormatException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.evosuite.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingUtils {
    private static final Logger logger = LoggerFactory.getLogger(LoggingUtils.class);
    public static final PrintStream DEFAULT_OUT = System.out;
    public static final PrintStream DEFAULT_ERR = System.err;
    public static final String USE_DIFFERENT_LOGGING_XML_PARAMETER = "use_different_logback";
    private static final String EVO_LOGGER = "evo_logger";
    protected static PrintStream latestOut = null;
    protected static PrintStream latestErr = null;
    public static final String LOG_TARGET = "log.target";
    public static final String LOG_LEVEL = "log.level";
    private static volatile boolean alreadyMuted = false;
    private ServerSocket serverSocket;
    private final ExecutorService logConnections = Executors.newSingleThreadExecutor();
    private final ExecutorService logHandler = Executors.newCachedThreadPool();

    public static Logger getEvoLogger() {
        return LoggerFactory.getLogger((String)EVO_LOGGER);
    }

    public boolean startLogServer() {
        try {
            this.serverSocket = new ServerSocket();
            this.serverSocket.bind(null);
            this.logConnections.submit(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    while (!LoggingUtils.this.isServerClosed()) {
                        final Socket socket = LoggingUtils.this.serverSocket.accept();
                        LoggingUtils.this.logHandler.submit(new Callable<Void>(){

                            @Override
                            public Void call() {
                                try {
                                    ObjectInputStream ois = new ObjectInputStream(new BufferedInputStream(socket.getInputStream()));
                                    while (socket != null && socket.isConnected() && !LoggingUtils.this.isServerClosed()) {
                                        ILoggingEvent event = (ILoggingEvent)ois.readObject();
                                        ch.qos.logback.classic.Logger remoteLogger = (ch.qos.logback.classic.Logger)LoggerFactory.getLogger((String)event.getLoggerName());
                                        remoteLogger.callAppenders(event);
                                    }
                                }
                                catch (SocketException se) {
                                }
                                catch (UTFDataFormatException utfe) {
                                }
                                catch (EOFException eof) {
                                }
                                catch (InvalidClassException ice) {
                                    logger.error("Error in de-serialized log event: " + ice.getMessage());
                                }
                                catch (Exception e) {
                                    logger.error("Problem in reading loggings", (Throwable)e);
                                }
                                return null;
                            }
                        });
                    }
                    return null;
                }
            });
            return true;
        }
        catch (Exception e) {
            logger.error("Can't start log server", (Throwable)e);
            return false;
        }
    }

    public boolean isServerClosed() {
        return this.serverSocket == null || this.serverSocket.isClosed() || !this.serverSocket.isBound();
    }

    public Integer getLogServerPort() {
        if (this.isServerClosed()) {
            return null;
        }
        return this.serverSocket.getLocalPort();
    }

    public void closeLogServer() {
        if (this.serverSocket != null && !this.serverSocket.isClosed()) {
            try {
                this.serverSocket.close();
            }
            catch (IOException e) {
                logger.error("Error in closing log server", (Throwable)e);
            }
            this.serverSocket = null;
        }
    }

    public static void muteCurrentOutAndErrStream() {
        if (alreadyMuted) {
            return;
        }
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        PrintStream outStream = new PrintStream(byteStream);
        latestOut = System.out;
        latestErr = System.err;
        System.setOut(outStream);
        System.setErr(outStream);
        alreadyMuted = true;
    }

    public static void restorePreviousOutAndErrStream() {
        if (!alreadyMuted) {
            return;
        }
        System.setOut(latestOut);
        System.setErr(latestErr);
        alreadyMuted = false;
    }

    public static void restoreDefaultOutAndErrStream() {
        System.setOut(DEFAULT_OUT);
        System.setErr(DEFAULT_ERR);
    }

    public static void setLoggingForJUnit() {
        Logger root;
        if (Properties.ENABLE_ASSERTS_FOR_EVOSUITE) {
            return;
        }
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        if (LoggingUtils.isDefaultLoggingConfiguration(context) && (root = LoggerFactory.getLogger((String)"org.evosuite")) != null && root instanceof ch.qos.logback.classic.Logger) {
            ((ch.qos.logback.classic.Logger)root).setLevel(Level.OFF);
        }
    }

    private static boolean isDefaultLoggingConfiguration(LoggerContext context) {
        return context.getName().equals("default");
    }

    public static boolean loadLogbackForEvoSuite() {
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        boolean isOK = true;
        if (LoggingUtils.isDefaultLoggingConfiguration(context)) {
            try {
                JoranConfigurator configurator = new JoranConfigurator();
                configurator.setContext((Context)context);
                String xmlFileName = LoggingUtils.getLogbackFileName();
                InputStream f = null;
                f = LoggingUtils.class.getClassLoader() != null ? LoggingUtils.class.getClassLoader().getResourceAsStream(xmlFileName) : ClassLoader.getSystemClassLoader().getResourceAsStream(xmlFileName);
                if (f == null) {
                    String msg = xmlFileName + " not found on classpath";
                    System.err.println(msg);
                    logger.error(msg);
                    isOK = false;
                } else {
                    context.reset();
                    configurator.doConfigure(f);
                }
            }
            catch (JoranException je) {
                isOK = false;
            }
            StatusPrinter.printInCaseOfErrorsOrWarnings((Context)context);
        }
        return isOK;
    }

    public static String getLogbackFileName() {
        return System.getProperty(USE_DIFFERENT_LOGGING_XML_PARAMETER, "logback-evosuite.xml");
    }
}

