/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.utils;

import com.googlecode.gentyref.CaptureType;
import com.googlecode.gentyref.GenericTypeReflector;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;

public class ParameterizedTypeImpl
implements ParameterizedType {
    private final Class<?> rawType;
    private final Type[] actualTypeArguments;
    private final Type ownerType;

    public ParameterizedTypeImpl(Class<?> rawType, Type[] actualTypeArguments, Type owner) {
        this.rawType = rawType;
        this.actualTypeArguments = actualTypeArguments;
        this.ownerType = owner;
    }

    @Override
    public Type getRawType() {
        return this.rawType;
    }

    @Override
    public Type[] getActualTypeArguments() {
        return this.actualTypeArguments;
    }

    @Override
    public Type getOwnerType() {
        return this.ownerType;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ParameterizedType)) {
            return false;
        }
        ParameterizedType other = (ParameterizedType)obj;
        if (this == other) {
            return true;
        }
        return this.rawType.equals(other.getRawType()) && Arrays.equals(this.actualTypeArguments, other.getActualTypeArguments()) && (this.ownerType == null ? other.getOwnerType() == null : this.ownerType.equals(other.getOwnerType()));
    }

    public int hashCode() {
        int result = this.rawType.hashCode() ^ Arrays.hashCode(this.actualTypeArguments);
        if (this.ownerType != null) {
            result ^= this.ownerType.hashCode();
        }
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        String clazz = this.rawType.getName();
        if (this.ownerType != null) {
            String prefix;
            sb.append(GenericTypeReflector.getTypeName((Type)this.ownerType)).append('.');
            String string = prefix = this.ownerType instanceof ParameterizedType ? ((Class)((ParameterizedType)this.ownerType).getRawType()).getName() + '$' : ((Class)this.ownerType).getName() + '$';
            if (clazz.startsWith(prefix)) {
                clazz = clazz.substring(prefix.length());
            }
        }
        sb.append(clazz);
        if (this.actualTypeArguments.length != 0) {
            sb.append('<');
            for (int i = 0; i < this.actualTypeArguments.length; ++i) {
                Type arg = this.actualTypeArguments[i];
                if (i != 0) {
                    sb.append(", ");
                }
                if (arg instanceof CaptureType) {
                    CaptureType captureType = (CaptureType)arg;
                    if (captureType.getLowerBounds().length == 0) {
                        sb.append("?");
                        continue;
                    }
                    sb.append(captureType.getLowerBounds()[0].toString());
                    continue;
                }
                if (arg == null) {
                    sb.append("null");
                    continue;
                }
                sb.append(GenericTypeReflector.getTypeName((Type)arg));
            }
            sb.append('>');
        }
        return sb.toString();
    }
}

