/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.utils;

import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.evosuite.TestGenerationContext;
import org.evosuite.coverage.mutation.MutationObserver;
import org.evosuite.instrumentation.InstrumentingClassLoader;
import org.evosuite.runtime.Runtime;
import org.evosuite.runtime.reset.ResetManager;
import org.evosuite.runtime.sandbox.Sandbox;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResetExecutor {
    private static final Logger logger = LoggerFactory.getLogger(ResetExecutor.class);
    private final Set<String> alreadyLoggedErrors;
    private static ResetExecutor instance;
    private final HashSet<String> confirmedResettableClasses = new HashSet();

    private ResetExecutor() {
        this.alreadyLoggedErrors = new HashSet<String>();
    }

    public static synchronized ResetExecutor getInstance() {
        if (instance == null) {
            instance = new ResetExecutor();
        }
        return instance;
    }

    public void resetAllClasses() {
        List classesToReset = ResetManager.getInstance().getClassResetOrder();
        this.resetClasses(classesToReset);
    }

    public void resetClasses(List<String> classesToReset) {
        for (String className : classesToReset) {
            this.resetClass(className);
        }
    }

    private Method getResetMethod(String className) {
        try {
            InstrumentingClassLoader classLoader = TestGenerationContext.getInstance().getClassLoaderForSUT();
            Class<?> clazz = Class.forName(className, true, classLoader);
            Method m = clazz.getDeclaredMethod("__STATIC_RESET", null);
            m.setAccessible(true);
            return m;
        }
        catch (NoSuchMethodException e) {
            logger.debug("__STATIC_RESET() method does not exists in class " + className);
        }
        catch (Error | Exception e) {
            this.logWarn(className, e.getClass() + " thrown while loading method  __STATIC_RESET() for class " + className);
        }
        return null;
    }

    private synchronized void logWarn(String className, String msg) {
        if (this.alreadyLoggedErrors.contains(className)) {
            return;
        }
        this.alreadyLoggedErrors.add(className);
        logger.warn(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetClass(String className) {
        logger.debug("Resetting class " + className);
        int mutationActive = MutationObserver.activeMutation;
        MutationObserver.deactivateMutation();
        this.confirmedResettableClasses.add(className);
        Sandbox.goingToExecuteSUTCode();
        TestGenerationContext.getInstance().goingToExecuteSUTCode();
        Runtime.getInstance().resetRuntime();
        try {
            Method resetMethod = this.getResetMethod(className);
            if (resetMethod != null) {
                resetMethod.invoke(null, (Object[])null);
            }
        }
        catch (Exception e) {
            this.logWarn(className, e.getClass() + " thrown during execution of method  __STATIC_RESET() for class " + className + ", " + e.getCause());
        }
        finally {
            Sandbox.doneWithExecutingSUTCode();
            TestGenerationContext.getInstance().doneWithExecuteingSUTCode();
            MutationObserver.activateMutation(mutationActive);
        }
    }

    public void reloadClasses() {
        for (String className : ResetManager.getInstance().getClassResetOrder()) {
            Runtime.getInstance().resetRuntime();
            try {
                InstrumentingClassLoader classLoader = TestGenerationContext.getInstance().getClassLoaderForSUT();
                Class.forName(className, true, classLoader);
            }
            catch (ClassNotFoundException e) {
                this.logWarn(className, "Class " + className + " could not be found during setting up of assertion generation ");
            }
            catch (ExceptionInInitializerError ex) {
                this.logWarn(className, "Class " + className + " could not be initialized during setting up of assertion generation ");
            }
            catch (LinkageError ex) {
                this.logWarn(className, "Class " + className + "  initialization led to a Linkage error ");
            }
        }
    }
}

