/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.utils;

import com.thoughtworks.xstream.XStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    private static Logger logger = LoggerFactory.getLogger(Utils.class);

    public static void sleepUntil(long targetTimeMillis) {
        long delta;
        while ((delta = targetTimeMillis - System.currentTimeMillis()) > 0L) {
            try {
                Thread.sleep(delta);
            }
            catch (InterruptedException e) {}
        }
    }

    public static void sleepFor(long millis) {
        Utils.sleepUntil(System.currentTimeMillis() + millis);
    }

    public static void deleteDir(String dirName) {
        File dir = new File(dirName);
        if (dir.exists()) {
            String[] children;
            for (String s : children = dir.list()) {
                File f = new File(dir, s);
                if (f.isDirectory()) {
                    Utils.deleteDir(f.getAbsolutePath());
                }
                f.delete();
            }
        }
        dir.delete();
    }

    public static boolean createDir(String dirName) {
        File srcDirs = new File(dirName);
        return srcDirs.mkdirs();
    }

    public static boolean moveFile(File source, File dest) {
        if (source.isDirectory() || dest.isDirectory()) {
            return false;
        }
        try {
            if (dest.exists()) {
                dest.delete();
            }
            FileUtils.moveFile((File)source, (File)dest);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public static boolean addURL(String path) {
        URL url = null;
        try {
            url = new File(path).toURI().toURL();
        }
        catch (MalformedURLException e) {
            return false;
        }
        URLClassLoader sysloader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        Class<URLClassLoader> sysclass = URLClassLoader.class;
        try {
            Class[] parameters = new Class[]{URL.class};
            Method method = sysclass.getDeclaredMethod("addURL", parameters);
            method.setAccessible(true);
            method.invoke((Object)sysloader, url);
            method.setAccessible(false);
        }
        catch (Throwable t) {
            return false;
        }
        return true;
    }

    public static Set<String> classesDescFromString(String input) {
        HashSet<String> classesDesc = new HashSet<String>();
        try {
            if (input.equals("null")) {
                return new HashSet<String>();
            }
        }
        catch (NullPointerException e) {
            return classesDesc;
        }
        Pattern p = Pattern.compile("([a-z])+(/\\w+)+");
        Matcher m = p.matcher(input);
        while (m.find()) {
            String str = m.group();
            classesDesc.add(str);
        }
        return classesDesc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> readFile(String fileName) {
        LinkedList<String> content = new LinkedList<String>();
        try {
            InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(fileName), "utf-8");
            try (BufferedReader in = new BufferedReader(reader);){
                String str;
                while ((str = in.readLine()) != null) {
                    content.add(str);
                }
            }
        }
        catch (Exception e) {
            logger.error("Error while reading file " + fileName + " , " + e.getMessage(), (Throwable)e);
        }
        return content;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFileToString(String fileName) {
        StringBuilder content = new StringBuilder();
        try {
            InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(fileName), "utf-8");
            try (BufferedReader in = new BufferedReader(reader);){
                String str;
                while ((str = in.readLine()) != null) {
                    content.append(str);
                }
            }
        }
        catch (Exception e) {
            logger.error("Error while reading file " + fileName + " , " + e.getMessage(), (Throwable)e);
        }
        return content.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> readFile(File file) {
        LinkedList<String> content = new LinkedList<String>();
        try {
            InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file), "utf-8");
            try (BufferedReader in = new BufferedReader(reader);){
                String str;
                while ((str = in.readLine()) != null) {
                    content.add(str);
                }
            }
        }
        catch (Exception e) {
            logger.error("Error while reading file " + file.getName() + " , " + e.getMessage(), (Throwable)e);
        }
        return content;
    }

    public static void writeFile(String content, String fileName) {
        try {
            FileUtils.writeStringToFile((File)new File(fileName), (String)content);
        }
        catch (IOException e) {
            logger.error("Error while writing file " + fileName + " , " + e.getMessage(), (Throwable)e);
        }
    }

    public static void writeFile(String content, File file) {
        try {
            FileUtils.writeStringToFile((File)file, (String)content);
        }
        catch (Exception e) {
            logger.error("Error while reading file " + file.getName() + " , " + e.getMessage(), (Throwable)e);
        }
    }

    public static void writeFile(InputStream in, File dest) {
        try {
            dest.deleteOnExit();
            if (!dest.exists()) {
                int len;
                FileOutputStream out = new FileOutputStream(dest);
                byte[] buf = new byte[1024];
                while ((len = in.read(buf)) > 0) {
                    ((OutputStream)out).write(buf, 0, len);
                }
                ((OutputStream)out).close();
            }
            in.close();
        }
        catch (Exception e) {
            logger.error("Error while writing file " + dest.getName() + " , " + e.getMessage(), (Throwable)e);
        }
    }

    public static void writeXML(Object data, String fileName) {
        try {
            XStream xstream = new XStream();
            FileUtils.writeStringToFile((File)new File(fileName), (String)xstream.toXML(data));
        }
        catch (Exception e) {
            logger.error("Error while writing file " + fileName + " , " + e.getMessage(), (Throwable)e);
        }
    }

    public static <T> T readXML(String fileName) {
        XStream xstream = new XStream();
        try {
            InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(fileName), "utf-8");
            BufferedReader in = new BufferedReader(reader);
            return (T)xstream.fromXML((Reader)in);
        }
        catch (Exception e) {
            logger.error("Error while reading file " + fileName + " , " + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static String getPackageName(Class<?> clazz) {
        String name;
        String packageName = "";
        packageName = clazz.getPackage() != null ? clazz.getPackage().getName() : ((name = clazz.getName()).contains(".") ? name.substring(0, name.lastIndexOf(".")) : "");
        return packageName;
    }

    public static String createFolderForTests(String base, String fullClassName) {
        String packageName = "";
        packageName = fullClassName.contains(".") ? fullClassName.substring(0, fullClassName.lastIndexOf(".")) : "";
        packageName = packageName.replaceAll(".", File.separator);
        String testFolderName = base + File.separator + packageName;
        File testFolder = new File(testFolderName);
        if (testFolder.exists()) {
            return testFolderName;
        }
        boolean created = testFolder.mkdirs();
        if (!created) {
            logger.error("Failed to create: " + testFolderName);
            return null;
        }
        return testFolderName;
    }

    public static List<File> getAllFilesInSubFolder(String base, String ending) throws IllegalArgumentException {
        File dir = new File(base);
        if (!dir.exists() || !dir.isDirectory()) {
            throw new IllegalArgumentException("Invalid folder " + base);
        }
        LinkedList<File> files = new LinkedList<File>();
        Utils.recursiveFileSearch(files, dir, ending);
        return files;
    }

    private static void recursiveFileSearch(List<File> files, File dir, String ending) {
        for (File file : dir.listFiles()) {
            if (file.isDirectory()) {
                Utils.recursiveFileSearch(files, file, ending);
                continue;
            }
            if (!file.getName().endsWith(ending)) continue;
            files.add(file);
        }
    }
}

