/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.utils;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.HashMap;
import java.util.Map;
import org.evosuite.utils.GenericArrayTypeImpl;
import org.evosuite.utils.GenericClass;
import org.evosuite.utils.ParameterizedTypeImpl;
import org.evosuite.utils.WildcardTypeImpl;

class VarMap {
    public final Map<TypeVariable<?>, Type> map = new HashMap();

    VarMap() {
    }

    void add(TypeVariable<?> variable, Type value) {
        this.map.put(variable, value);
    }

    void addAll(TypeVariable<?>[] variables, Type[] values) {
        assert (variables.length == values.length);
        for (int i = 0; i < variables.length; ++i) {
            this.map.put(variables[i], values[i]);
        }
    }

    void addAll(Map<TypeVariable<?>, GenericClass> variables) {
        for (Map.Entry<TypeVariable<?>, GenericClass> entry : variables.entrySet()) {
            this.map.put(entry.getKey(), entry.getValue().getType());
        }
    }

    VarMap(TypeVariable<?>[] variables, Type[] values) {
        this.addAll(variables, values);
    }

    Type map(Type type) {
        if (type instanceof Class) {
            return type;
        }
        if (type instanceof TypeVariable) {
            if (this.map.containsKey(type)) {
                return this.map.get(type);
            }
            return new WildcardTypeImpl(new Type[]{Object.class}, new Type[0]);
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType pType = (ParameterizedType)type;
            return new ParameterizedTypeImpl((Class)pType.getRawType(), this.map(pType.getActualTypeArguments()), pType.getOwnerType() == null ? pType.getOwnerType() : this.map(pType.getOwnerType()));
        }
        if (type instanceof WildcardType) {
            WildcardType wType = (WildcardType)type;
            return new WildcardTypeImpl(this.map(wType.getUpperBounds()), this.map(wType.getLowerBounds()));
        }
        if (type instanceof GenericArrayType) {
            return GenericArrayTypeImpl.createArrayType(this.map(((GenericArrayType)type).getGenericComponentType()));
        }
        throw new RuntimeException("not implemented: mapping " + type.getClass() + " (" + type + ")");
    }

    Type[] map(Type[] types) {
        Type[] result = new Type[types.length];
        for (int i = 0; i < types.length; ++i) {
            result[i] = this.map(types[i]);
        }
        return result;
    }
}

