/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.gentyref;

import com.googlecode.gentyref.GenericTypeReflector;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ParameterizedTypeImpl
implements ParameterizedType {
    private final Class<?> rawType;
    private final Type[] actualTypeArguments;
    private final Type ownerType;

    public ParameterizedTypeImpl(Class<?> rawType, Type[] actualTypeArguments, Type ownerType) {
        this.rawType = rawType;
        this.actualTypeArguments = actualTypeArguments;
        this.ownerType = ownerType;
    }

    @Override
    public Type getRawType() {
        return this.rawType;
    }

    @Override
    public Type[] getActualTypeArguments() {
        return this.actualTypeArguments;
    }

    @Override
    public Type getOwnerType() {
        return this.ownerType;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ParameterizedType)) {
            return false;
        }
        ParameterizedType other = (ParameterizedType)obj;
        return this.rawType.equals(other.getRawType()) && Arrays.equals(this.actualTypeArguments, other.getActualTypeArguments()) && (this.ownerType == null ? other.getOwnerType() == null : this.ownerType.equals(other.getOwnerType()));
    }

    public int hashCode() {
        int result = this.rawType.hashCode() ^ Arrays.hashCode(this.actualTypeArguments);
        if (this.ownerType != null) {
            result ^= this.ownerType.hashCode();
        }
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        String clazz = this.rawType.getName();
        if (this.ownerType != null) {
            String prefix;
            sb.append(GenericTypeReflector.getTypeName(this.ownerType)).append('.');
            String string = prefix = this.ownerType instanceof ParameterizedType ? String.valueOf(((Class)((ParameterizedType)this.ownerType).getRawType()).getName()) + '$' : String.valueOf(((Class)this.ownerType).getName()) + '$';
            if (clazz.startsWith(prefix)) {
                clazz = clazz.substring(prefix.length());
            }
        }
        sb.append(clazz);
        if (this.actualTypeArguments.length != 0) {
            sb.append('<');
            int i = 0;
            while (i < this.actualTypeArguments.length) {
                Type arg = this.actualTypeArguments[i];
                if (i != 0) {
                    sb.append(", ");
                }
                sb.append(GenericTypeReflector.getTypeName(arg));
                ++i;
            }
            sb.append('>');
        }
        return sb.toString();
    }
}

