/*
 * Decompiled with CFR 0.152.
 */
package com.panayotis.gnuplot;

import com.panayotis.gnuplot.GNUPlot;
import com.panayotis.gnuplot.GNUPlotException;
import com.panayotis.gnuplot.GNUPlotParameters;
import com.panayotis.gnuplot.terminal.GNUPlotTerminal;
import com.panayotis.io.FileUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;

class GNUPlotExec {
    private static final transient String DEFAULT_PATH = FileUtils.findPathExec("gnuplot");
    private transient File gnuplotexec;
    private boolean ispersist;
    private static final String[] persistcommand = new String[]{"path", "-persist"};
    private static final String[] nopersist = new String[]{"path"};

    GNUPlotExec() throws IOException {
        this(null);
    }

    GNUPlotExec(String path) throws IOException {
        if (path == null) {
            path = DEFAULT_PATH;
        }
        this.setGNUPlotPath(path);
        this.ispersist = true;
    }

    void setGNUPlotPath(String path) throws IOException {
        File file = FileUtils.getExec(path);
        if (file == null) {
            throw new IOException("GnuPlot executable \"" + path + "\" not found.");
        }
        this.gnuplotexec = file;
    }

    String getGNUPlotPath() {
        return this.gnuplotexec.getPath();
    }

    public String getCommands(GNUPlotParameters par, GNUPlotTerminal terminal) {
        return par.getPlotCommands(terminal);
    }

    void plot(GNUPlotParameters par, GNUPlotTerminal terminal) throws GNUPlotException {
        try {
            final GNUPlotTerminal term = terminal;
            String comms = this.getCommands(par, term);
            final Messages msg = new Messages();
            GNUPlot.getDebugger().msg("** Start of plot commands **", 40);
            GNUPlot.getDebugger().msg(comms, 40);
            GNUPlot.getDebugger().msg("** End of plot commands **", 40);
            String[] command = this.ispersist ? persistcommand : nopersist;
            command[0] = this.getGNUPlotPath();
            String cmdStr = "";
            for (String cmd : command) {
                cmdStr = cmdStr + cmd + " ";
            }
            GNUPlot.getDebugger().msg("exec(" + cmdStr + ")", 40);
            final Process proc = Runtime.getRuntime().exec(command);
            Thread err_thread = new Thread(){

                public void run() {
                    BufferedReader err = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
                    StringBuffer buf = new StringBuffer();
                    try {
                        String line;
                        while ((line = err.readLine()) != null) {
                            line = GNUPlotExec.this.parseErrorLine(line, "gnuplot> plot");
                            line = GNUPlotExec.this.parseErrorLine(line, "multiplot> plot");
                            if ((line = line.replace("input data ('e' ends) >", "").trim()).equals("^")) {
                                line = "";
                            }
                            if (line.equals("")) continue;
                            if (line.indexOf("_ERROR_") >= 0) {
                                msg.error = "Error while parsing 'plot' arguments.";
                                break;
                            }
                            buf.append(line).append('\n');
                        }
                        err.close();
                        msg.output = buf.toString();
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                }
            };
            err_thread.start();
            Thread out_thread = new Thread(){

                public void run() {
                    msg.process = term.processOutput(proc.getInputStream());
                }
            };
            out_thread.start();
            OutputStreamWriter out = new OutputStreamWriter(proc.getOutputStream());
            out.write(comms);
            out.flush();
            out.close();
            try {
                proc.waitFor();
                out_thread.join();
                err_thread.join();
            }
            catch (InterruptedException ex) {
                throw new GNUPlotException("Interrupted execution of gnuplot");
            }
            String message = null;
            message = msg.error != null ? msg.error : msg.process;
            int level = 50;
            if (message != null) {
                level = 20;
            }
            GNUPlot.getDebugger().msg("** Start of error stream **", level);
            GNUPlot.getDebugger().msg(msg.output, level);
            GNUPlot.getDebugger().msg("** End of error stream **", level);
            if (message != null) {
                throw new GNUPlotException(message);
            }
        }
        catch (IOException ex) {
            throw new GNUPlotException("IOException while executing \"" + this.getGNUPlotPath() + "\":" + ex.getLocalizedMessage());
        }
    }

    void setPersist(boolean persist) {
        this.ispersist = persist;
    }

    private String parseErrorLine(String error, String tag) {
        if (error.startsWith(tag) && error.endsWith(" ; _gnuplot_error = 0")) {
            StringBuffer bf = new StringBuffer("Error in:");
            bf.append(error.substring(tag.length(), error.length() - " ; _gnuplot_error = 0".length()));
            return bf.toString();
        }
        return error;
    }

    private class Messages {
        String output = "";
        String error = null;
        String process = null;

        private Messages() {
        }
    }
}

