/*
 * Decompiled with CFR 0.152.
 */
package edu.uta.cse.dsc.instrument;

final class AccessFlags {
    AccessFlags() {
    }

    private static boolean is(int access, int mask) {
        return (access & mask) != 0;
    }

    static boolean isAbstract(int access) {
        return AccessFlags.is(access, 1024);
    }

    static boolean isAnnotation(int access) {
        return AccessFlags.is(access, 8192);
    }

    static boolean isBridge(int access) {
        return AccessFlags.is(access, 64);
    }

    static boolean isDeprecated(int access) {
        return AccessFlags.is(access, 131072);
    }

    static boolean isEnum(int access) {
        return AccessFlags.is(access, 16384);
    }

    static boolean isFinal(int access) {
        return AccessFlags.is(access, 16);
    }

    static boolean isInterface(int access) {
        return AccessFlags.is(access, 512);
    }

    static boolean isNative(int access) {
        return AccessFlags.is(access, 256);
    }

    static boolean isPrivate(int access) {
        return AccessFlags.is(access, 2);
    }

    static boolean isProtected(int access) {
        return AccessFlags.is(access, 4);
    }

    static boolean isPublic(int access) {
        return AccessFlags.is(access, 1);
    }

    static boolean isStatic(int access) {
        return AccessFlags.is(access, 8);
    }

    static boolean isStrict(int access) {
        return AccessFlags.is(access, 2048);
    }

    static boolean isSuper(int access) {
        return AccessFlags.is(access, 32);
    }

    static boolean isSynchronized(int access) {
        return AccessFlags.is(access, 32);
    }

    static boolean isSynthetic(int access) {
        return AccessFlags.is(access, 4096);
    }

    static boolean isTransient(int access) {
        return AccessFlags.is(access, 128);
    }

    static boolean isVarArgs(int access) {
        return AccessFlags.is(access, 128);
    }

    static boolean isVolatile(int access) {
        return AccessFlags.is(access, 64);
    }
}

