/*
 * Decompiled with CFR 0.152.
 */
package edu.uta.cse.dsc.instrument;

import edu.uta.cse.dsc.MainConfig;
import edu.uta.cse.dsc.instrument.DscBytecodeInstrumentation;
import edu.uta.cse.dsc.instrument.ResourceList;
import edu.uta.cse.dsc.util.Assertions;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.Type;

public class DscInstrumentingClassLoader
extends ClassLoader {
    private final ClassLoader classLoader;
    private final DscBytecodeInstrumentation instrumentation;
    private final Map<String, Class<?>> classes = new HashMap();

    public DscInstrumentingClassLoader() {
        super(DscInstrumentingClassLoader.class.getClassLoader());
        this.instrumentation = new DscBytecodeInstrumentation();
        this.classLoader = DscInstrumentingClassLoader.class.getClassLoader();
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        if (!this.checkIfCanInstrument(name)) {
            Class<?> result = this.findLoadedClass(name);
            if (result != null) {
                return result;
            }
            result = this.classLoader.loadClass(name);
            return result;
        }
        Class<?> result = this.findLoadedClass(name);
        if (result != null) {
            return result;
        }
        result = this.classes.get(name);
        if (result != null) {
            return result;
        }
        Class<?> instrumentedClass = null;
        instrumentedClass = this.instrumentClass(name);
        return instrumentedClass;
    }

    private boolean checkIfCanInstrument(String name) {
        return !MainConfig.get().isIgnored(name);
    }

    private Class<?> instrumentClass(String fullyQualifiedTargetClass) throws ClassNotFoundException {
        try {
            String className = fullyQualifiedTargetClass.replace('.', '/');
            InputStream is = ClassLoader.getSystemResourceAsStream(className + ".class");
            if (is == null) {
                try {
                    is = this.findTargetResource(className + ".class");
                }
                catch (FileNotFoundException e) {
                    throw new ClassNotFoundException("Class '" + className + ".class" + "' should be in target project, but could not be found!");
                }
            }
            byte[] byteBuffer = this.instrumentation.transformBytes(className, new ClassReader(is));
            Class<?> result = this.defineClass(fullyQualifiedTargetClass, byteBuffer, 0, byteBuffer.length);
            this.classes.put(fullyQualifiedTargetClass, result);
            return result;
        }
        catch (Exception e) {
            throw new ClassNotFoundException(e.getMessage(), e);
        }
    }

    private InputStream findTargetResource(String name) throws FileNotFoundException {
        Collection<String> resources = ResourceList.findResourceInClassPath(name);
        if (resources.isEmpty()) {
            throw new FileNotFoundException(name);
        }
        String fileName = resources.iterator().next();
        return new FileInputStream(fileName);
    }

    public Class<?> getClassForName(String className) {
        Assertions.notNull(className);
        Class<?> res = null;
        String classNameDot = className.replace("/", ".");
        try {
            res = this.loadClass(classNameDot);
        }
        catch (ClassNotFoundException cnfe) {
            Assertions.check(false, cnfe);
        }
        return Assertions.notNull(res);
    }

    public Class<?> getClassForType(Type aType) {
        switch (aType.getSort()) {
            case 1: {
                return Boolean.TYPE;
            }
            case 3: {
                return Byte.TYPE;
            }
            case 2: {
                return Character.TYPE;
            }
            case 8: {
                return Double.TYPE;
            }
            case 6: {
                return Float.TYPE;
            }
            case 5: {
                return Integer.TYPE;
            }
            case 7: {
                return Long.TYPE;
            }
            case 4: {
                return Short.TYPE;
            }
            case 0: {
                return Void.TYPE;
            }
            case 9: {
                Class<?> elementClass = this.getClassForType(aType.getElementType());
                int dimensions = aType.getDimensions();
                int[] lenghts = new int[dimensions];
                Class<?> array_class = Array.newInstance(elementClass, lenghts).getClass();
                return array_class;
            }
        }
        return this.getClassForName(aType.getInternalName());
    }
}

