/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite;

import java.io.File;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.evosuite.Properties;
import org.evosuite.classpath.ClassPathHandler;
import org.evosuite.executionmode.Continuous;
import org.evosuite.executionmode.Help;
import org.evosuite.executionmode.ListClasses;
import org.evosuite.executionmode.ListParameters;
import org.evosuite.executionmode.MeasureCoverage;
import org.evosuite.executionmode.PrintStats;
import org.evosuite.executionmode.Setup;
import org.evosuite.executionmode.TestGeneration;
import org.evosuite.executionmode.WriteDependencies;
import org.evosuite.utils.LoggingUtils;

public class CommandLineParameters {
    public static void validateInputOptionsAndParameters(CommandLine line) throws IllegalArgumentException {
        String junitSuffix;
        java.util.Properties properties = line.getOptionProperties("D");
        String cut = line.getOptionValue("class");
        if (cut != null) {
            if (cut.endsWith(".java")) {
                throw new IllegalArgumentException("The target -class should be a JVM qualifying name (e.g., org.foo.SomeClass) and not a source file");
            }
            if (cut.endsWith(".class")) {
                throw new IllegalArgumentException("The target -class should be a JVM qualifying name (e.g., org.foo.SomeClass) and not a bytecode file");
            }
        }
        if (!line.hasOption("continuous") && !line.hasOption("startedByCtg")) {
            for (Object p : properties.keySet()) {
                if (!p.toString().startsWith("ctg_")) continue;
                throw new IllegalArgumentException("Option " + p + " is only valid in '-" + "continuous" + "' mode");
            }
        }
        if ((junitSuffix = properties.getProperty("junit_suffix")) != null && !junitSuffix.endsWith("Test")) {
            throw new IllegalArgumentException("A JUnit suffix should always end with a 'Test'");
        }
    }

    public static Options getCommandLineOptions() {
        Options options = new Options();
        Option help = Help.getOption();
        Option setup = Setup.getOption();
        Option measureCoverage = MeasureCoverage.getOption();
        Option listClasses = ListClasses.getOption();
        Option listDependencies = WriteDependencies.getOption();
        Option printStats = PrintStats.getOption();
        Option listParameters = ListParameters.getOption();
        Option continuous = Continuous.getOption();
        Option[] generateOptions = TestGeneration.getOptions();
        Option targetClass = new Option("class", true, "target class for test generation. A fully qualifying needs to be provided, e.g. org.foo.SomeClass");
        Option targetPrefix = new Option("prefix", true, "target package prefix for test generation. All classes on the classpath with the given package prefix will be used, i.e. all classes in the given package and sub-packages.");
        Option targetCP = new Option("target", true, "target classpath for test generation. Either a jar file or a folder where to find the .class files");
        Option projectCP = new Option("projectCP", true, "classpath of the project under test and all its dependencies");
        Option evosuiteCP = new Option("evosuiteCP", true, "classpath of EvoSuite jar file(s). This is needed when EvoSuite is called in plugins like Eclipse/Maven");
        Option junitPrefix = new Option("junit", true, "junit prefix");
        Option criterion = new Option("criterion", true, "target criterion for test generation");
        Option seed = new Option("seed", true, "seed for random number generator");
        Option mem = new Option("mem", true, "heap size for client process (in megabytes)");
        Option libraryPath = new Option("libraryPath", true, "java library path to native libraries of the project under test");
        Option startedByCtg = new Option("startedByCtg", false, "Determine if current process was started by a CTG process");
        Option extendSuite = new Option("extend", true, "extend an existing test suite");
        Option inheritance = new Option("inheritanceTree", "Cache inheritance tree during setup");
        Option heapDump = new Option("heapdump", "Create heap dump on client VM out of memory error");
        Option base_dir = new Option("base_dir", true, "Working directory in which tests and reports will be placed");
        OptionBuilder.withArgName("property=value");
        OptionBuilder.hasArgs(2);
        OptionBuilder.withValueSeparator();
        OptionBuilder.withDescription("use value for given property");
        Option property = OptionBuilder.create("D");
        for (Option option : generateOptions) {
            options.addOption(option);
        }
        options.addOption(continuous);
        options.addOption(listParameters);
        options.addOption(help);
        options.addOption(extendSuite);
        options.addOption(measureCoverage);
        options.addOption(listClasses);
        options.addOption(listDependencies);
        options.addOption(printStats);
        options.addOption(setup);
        options.addOption(targetClass);
        options.addOption(targetPrefix);
        options.addOption(targetCP);
        options.addOption(junitPrefix);
        options.addOption(criterion);
        options.addOption(seed);
        options.addOption(mem);
        options.addOption(libraryPath);
        options.addOption(evosuiteCP);
        options.addOption(inheritance);
        options.addOption(base_dir);
        options.addOption(property);
        options.addOption(projectCP);
        options.addOption(heapDump);
        options.addOption(startedByCtg);
        return options;
    }

    public static void handleSeed(List<String> javaOpts, CommandLine line) throws NullPointerException {
        if (line.hasOption("seed")) {
            String seedValue = line.getOptionValue("seed");
            javaOpts.add("-Drandom_seed=" + seedValue);
            Properties.RANDOM_SEED = Long.parseLong(seedValue);
        }
    }

    public static void addJavaDOptions(List<String> javaOpts, CommandLine line) throws Error {
        java.util.Properties properties = line.getOptionProperties("D");
        HashSet<String> propertyNames = new HashSet<String>(Properties.getParameters());
        for (String propertyName : properties.stringPropertyNames()) {
            if (!propertyNames.contains(propertyName)) {
                LoggingUtils.getEvoLogger().error("* Unknown property: " + propertyName);
                throw new Error("Unknown property: " + propertyName);
            }
            String propertyValue = properties.getProperty(propertyName);
            javaOpts.add("-D" + propertyName + "=" + propertyValue);
            System.setProperty(propertyName, propertyValue);
            try {
                Properties.getInstance().setValue(propertyName, propertyValue);
            }
            catch (Exception e) {
                throw new Error("Invalid value for property " + propertyName + ": " + propertyValue + ". Exception " + e.getMessage(), e);
            }
        }
    }

    public static void handleClassPath(CommandLine line) {
        String DCP = null;
        java.util.Properties properties = line.getOptionProperties("D");
        for (String propertyName : properties.stringPropertyNames()) {
            if (!propertyName.equals("CP")) continue;
            DCP = properties.getProperty(propertyName);
        }
        if (line.hasOption("projectCP") && DCP != null) {
            throw new IllegalArgumentException("Ambiguous classpath: both -projectCP and -DCP are defined");
        }
        String[] cpEntries = null;
        if (line.hasOption("projectCP")) {
            cpEntries = line.getOptionValue("projectCP").split(File.pathSeparator);
        } else if (DCP != null) {
            cpEntries = DCP.split(File.pathSeparator);
        }
        if (cpEntries != null) {
            ClassPathHandler.getInstance().changeTargetClassPath(cpEntries);
        }
        if (line.hasOption("target")) {
            String target = line.getOptionValue("target");
            ClassPathHandler.getInstance().addElementToTargetProjectClassPath(target);
        }
        if (line.hasOption("evosuiteCP")) {
            String[] entries = line.getOptionValues("evosuiteCP");
            ClassPathHandler.getInstance().setEvoSuiteClassPath(entries);
        }
    }

    public static void handleJVMOptions(List<String> javaOpts, CommandLine line) {
        if (line.hasOption("mem")) {
            javaOpts.add("-Xmx" + line.getOptionValue("mem") + "M");
        }
        if (line.hasOption("libraryPath")) {
            javaOpts.add("-Djava.library.path=" + line.getOptionValue("libraryPath"));
        }
        if (line.hasOption("heapdump")) {
            javaOpts.add("-XX:+HeapDumpOnOutOfMemoryError");
        }
    }
}

