/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.evosuite.ProgressMonitor;
import org.evosuite.Properties;
import org.evosuite.ShutdownTestWriter;
import org.evosuite.TestGenerationContext;
import org.evosuite.assertion.AssertionGenerator;
import org.evosuite.assertion.CompleteAssertionGenerator;
import org.evosuite.assertion.SimpleMutationAssertionGenerator;
import org.evosuite.assertion.StructuredAssertionGenerator;
import org.evosuite.assertion.UnitAssertionGenerator;
import org.evosuite.classpath.ClassPathHandler;
import org.evosuite.contracts.ContractChecker;
import org.evosuite.contracts.FailingTestSet;
import org.evosuite.coverage.CoverageAnalysis;
import org.evosuite.coverage.FitnessLogger;
import org.evosuite.coverage.TestFitnessFactory;
import org.evosuite.coverage.ambiguity.AmbiguityCoverageFactory;
import org.evosuite.coverage.ambiguity.AmbiguityCoverageSuiteFitness;
import org.evosuite.coverage.branch.Branch;
import org.evosuite.coverage.branch.BranchCoverageFactory;
import org.evosuite.coverage.branch.BranchCoverageSuiteFitness;
import org.evosuite.coverage.branch.BranchPool;
import org.evosuite.coverage.branch.OnlyBranchCoverageFactory;
import org.evosuite.coverage.branch.OnlyBranchCoverageSuiteFitness;
import org.evosuite.coverage.dataflow.AllDefsCoverageFactory;
import org.evosuite.coverage.dataflow.AllDefsCoverageSuiteFitness;
import org.evosuite.coverage.dataflow.DefUseCoverageFactory;
import org.evosuite.coverage.dataflow.DefUseCoverageSuiteFitness;
import org.evosuite.coverage.dataflow.DefUseCoverageTestFitness;
import org.evosuite.coverage.dataflow.DefUseFitnessCalculator;
import org.evosuite.coverage.exception.ExceptionCoverageFactory;
import org.evosuite.coverage.exception.ExceptionCoverageSuiteFitness;
import org.evosuite.coverage.ibranch.IBranchFitnessFactory;
import org.evosuite.coverage.ibranch.IBranchSuiteFitness;
import org.evosuite.coverage.line.LineCoverageFactory;
import org.evosuite.coverage.line.LineCoverageSuiteFitness;
import org.evosuite.coverage.method.MethodCoverageFactory;
import org.evosuite.coverage.method.MethodCoverageSuiteFitness;
import org.evosuite.coverage.method.MethodNoExceptionCoverageFactory;
import org.evosuite.coverage.method.MethodNoExceptionCoverageSuiteFitness;
import org.evosuite.coverage.method.MethodTraceCoverageFactory;
import org.evosuite.coverage.method.MethodTraceCoverageSuiteFitness;
import org.evosuite.coverage.mutation.MutationFactory;
import org.evosuite.coverage.mutation.MutationTestPool;
import org.evosuite.coverage.mutation.MutationTimeoutStoppingCondition;
import org.evosuite.coverage.mutation.OnlyMutationFactory;
import org.evosuite.coverage.mutation.OnlyMutationSuiteFitness;
import org.evosuite.coverage.mutation.StrongMutationSuiteFitness;
import org.evosuite.coverage.mutation.WeakMutationSuiteFitness;
import org.evosuite.coverage.output.OutputCoverageFactory;
import org.evosuite.coverage.output.OutputCoverageSuiteFitness;
import org.evosuite.coverage.readability.ReadabilitySuiteFitness;
import org.evosuite.coverage.rho.RhoCoverageFactory;
import org.evosuite.coverage.rho.RhoCoverageSuiteFitness;
import org.evosuite.coverage.statement.StatementCoverageFactory;
import org.evosuite.coverage.statement.StatementCoverageSuiteFitness;
import org.evosuite.ga.Chromosome;
import org.evosuite.ga.ChromosomeFactory;
import org.evosuite.ga.FitnessFunction;
import org.evosuite.ga.FitnessReplacementFunction;
import org.evosuite.ga.MinimizeSizeSecondaryObjective;
import org.evosuite.ga.SecondaryObjective;
import org.evosuite.ga.TournamentChromosomeFactory;
import org.evosuite.ga.bloatcontrol.BloatControlFunction;
import org.evosuite.ga.localsearch.BranchCoverageMap;
import org.evosuite.ga.metaheuristics.GeneticAlgorithm;
import org.evosuite.ga.metaheuristics.MuPlusLambdaGA;
import org.evosuite.ga.metaheuristics.NSGAII;
import org.evosuite.ga.metaheuristics.OnePlusOneEA;
import org.evosuite.ga.metaheuristics.RandomSearch;
import org.evosuite.ga.metaheuristics.SearchListener;
import org.evosuite.ga.metaheuristics.StandardGA;
import org.evosuite.ga.metaheuristics.SteadyStateGA;
import org.evosuite.ga.operators.crossover.CoverageCrossOver;
import org.evosuite.ga.operators.crossover.CrossOverFunction;
import org.evosuite.ga.operators.crossover.SinglePointCrossOver;
import org.evosuite.ga.operators.crossover.SinglePointFixedCrossOver;
import org.evosuite.ga.operators.crossover.SinglePointRelativeCrossOver;
import org.evosuite.ga.operators.selection.BinaryTournamentSelectionCrowdedComparison;
import org.evosuite.ga.operators.selection.FitnessProportionateSelection;
import org.evosuite.ga.operators.selection.RankSelection;
import org.evosuite.ga.operators.selection.SelectionFunction;
import org.evosuite.ga.operators.selection.TournamentSelection;
import org.evosuite.ga.populationlimit.IndividualPopulationLimit;
import org.evosuite.ga.populationlimit.PopulationLimit;
import org.evosuite.ga.populationlimit.SizePopulationLimit;
import org.evosuite.ga.stoppingconditions.GlobalTimeStoppingCondition;
import org.evosuite.ga.stoppingconditions.MaxFitnessEvaluationsStoppingCondition;
import org.evosuite.ga.stoppingconditions.MaxGenerationStoppingCondition;
import org.evosuite.ga.stoppingconditions.MaxStatementsStoppingCondition;
import org.evosuite.ga.stoppingconditions.MaxTestsStoppingCondition;
import org.evosuite.ga.stoppingconditions.MaxTimeStoppingCondition;
import org.evosuite.ga.stoppingconditions.RMIStoppingCondition;
import org.evosuite.ga.stoppingconditions.SocketStoppingCondition;
import org.evosuite.ga.stoppingconditions.StoppingCondition;
import org.evosuite.ga.stoppingconditions.ZeroFitnessStoppingCondition;
import org.evosuite.junit.JUnitAnalyzer;
import org.evosuite.junit.writer.TestSuiteWriter;
import org.evosuite.regression.RegressionSuiteFitness;
import org.evosuite.regression.RegressionTestChromosomeFactory;
import org.evosuite.regression.RegressionTestSuiteChromosomeFactory;
import org.evosuite.result.TestGenerationResult;
import org.evosuite.result.TestGenerationResultBuilder;
import org.evosuite.rmi.ClientServices;
import org.evosuite.rmi.service.ClientState;
import org.evosuite.runtime.sandbox.PermissionStatistics;
import org.evosuite.runtime.sandbox.Sandbox;
import org.evosuite.seeding.ObjectPool;
import org.evosuite.seeding.ObjectPoolManager;
import org.evosuite.seeding.TestCaseRecycler;
import org.evosuite.seeding.factories.BIAndRITestSuiteChromosomeFactory;
import org.evosuite.seeding.factories.BIMethodSeedingTestSuiteChromosomeFactory;
import org.evosuite.seeding.factories.BIMutatedMethodSeedingTestSuiteChromosomeFactory;
import org.evosuite.seeding.factories.BestIndividualTestSuiteChromosomeFactory;
import org.evosuite.seeding.factories.RandomIndividualTestSuiteChromosomeFactory;
import org.evosuite.seeding.factories.RandomMethodSeedingTestSuiteChromosomeFactory;
import org.evosuite.setup.DependencyAnalysis;
import org.evosuite.setup.TestCluster;
import org.evosuite.statistics.RuntimeVariable;
import org.evosuite.statistics.StatisticsListener;
import org.evosuite.statistics.StatisticsSender;
import org.evosuite.symbolic.DSEStats;
import org.evosuite.testcarver.capture.CaptureLog;
import org.evosuite.testcarver.capture.Capturer;
import org.evosuite.testcarver.codegen.CaptureLogAnalyzer;
import org.evosuite.testcarver.codegen.ICodeGenerator;
import org.evosuite.testcarver.testcase.EvoTestCaseCodeGenerator;
import org.evosuite.testcarver.testcase.TestCarvingExecutionObserver;
import org.evosuite.testcase.AllMethodsTestChromosomeFactory;
import org.evosuite.testcase.CodeUnderTestException;
import org.evosuite.testcase.ConstantInliner;
import org.evosuite.testcase.ExecutionResult;
import org.evosuite.testcase.ExecutionTraceImpl;
import org.evosuite.testcase.ExecutionTracer;
import org.evosuite.testcase.JUnitTestCarvedChromosomeFactory;
import org.evosuite.testcase.MinimizeExceptionsSecondaryObjective;
import org.evosuite.testcase.RandomLengthTestFactory;
import org.evosuite.testcase.RelativeTestLengthBloatControl;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.TestCaseExecutor;
import org.evosuite.testcase.TestCaseMinimizer;
import org.evosuite.testcase.TestCaseReplacementFunction;
import org.evosuite.testcase.TestChromosome;
import org.evosuite.testcase.TestFitnessFunction;
import org.evosuite.testcase.UncompilableCodeException;
import org.evosuite.testcase.ValueMinimizer;
import org.evosuite.testsuite.AbstractFitnessFactory;
import org.evosuite.testsuite.FixedSizeTestSuiteChromosomeFactory;
import org.evosuite.testsuite.MinimizeAverageLengthSecondaryObjective;
import org.evosuite.testsuite.MinimizeMaxLengthSecondaryObjective;
import org.evosuite.testsuite.MinimizeTotalLengthSecondaryObjective;
import org.evosuite.testsuite.RelativeSuiteLengthBloatControl;
import org.evosuite.testsuite.SerializationSuiteChromosomeFactory;
import org.evosuite.testsuite.StatementsPopulationLimit;
import org.evosuite.testsuite.TestSuiteChromosome;
import org.evosuite.testsuite.TestSuiteChromosomeFactory;
import org.evosuite.testsuite.TestSuiteFitnessFunction;
import org.evosuite.testsuite.TestSuiteMinimizer;
import org.evosuite.testsuite.TestSuiteReplacementFunction;
import org.evosuite.utils.ArrayUtil;
import org.evosuite.utils.LoggingUtils;
import org.evosuite.utils.Randomness;
import org.evosuite.utils.ResourceController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.misc.Signal;

public class TestSuiteGenerator {
    private static Logger logger = LoggerFactory.getLogger(TestSuiteGenerator.class);
    public static final ZeroFitnessStoppingCondition zero_fitness = new ZeroFitnessStoppingCondition();
    public static final GlobalTimeStoppingCondition global_time = new GlobalTimeStoppingCondition();
    public static StoppingCondition stopping_condition;
    private final ProgressMonitor progressMonitor = new ProgressMonitor();
    private GeneticAlgorithm ga;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TestGenerationResult> generateTestSuite() {
        LoggingUtils.getEvoLogger().info("* Analyzing classpath: ");
        ClientServices.getInstance().getClientNode().changeState(ClientState.INITIALIZATION);
        TestCaseExecutor.initExecutor();
        Sandbox.goingToExecuteSUTCode();
        TestGenerationContext.getInstance().goingToExecuteSUTCode();
        Sandbox.goingToExecuteUnsafeCodeOnSameThread();
        try {
            String cp = ClassPathHandler.getInstance().getTargetProjectClasspath();
            DependencyAnalysis.analyze(Properties.TARGET_CLASS, Arrays.asList(cp.split(File.pathSeparator)));
            LoggingUtils.getEvoLogger().info("* Finished analyzing classpath");
        }
        catch (Throwable e) {
            LoggingUtils.getEvoLogger().error("* Error while initializing target class: " + (e.getMessage() != null ? e.getMessage() : e.toString()));
            logger.error("Problem for " + Properties.TARGET_CLASS + ". Full stack:", e);
            ArrayList<TestGenerationResult> arrayList = new ArrayList<TestGenerationResult>(Arrays.asList(TestGenerationResultBuilder.buildErrorResult(e.getMessage() != null ? e.getMessage() : e.toString())));
            return arrayList;
        }
        finally {
            Sandbox.doneWithExecutingUnsafeCodeOnSameThread();
            Sandbox.doneWithExecutingSUTCode();
            TestGenerationContext.getInstance().doneWithExecuteingSUTCode();
        }
        ObjectPoolManager.getInstance();
        LoggingUtils.getEvoLogger().info("* Generating tests for class " + Properties.TARGET_CLASS);
        this.printTestCriterion();
        if (Properties.getTargetClass() == null) {
            return new ArrayList<TestGenerationResult>(Arrays.asList(TestGenerationResultBuilder.buildErrorResult("Could not load target class")));
        }
        List<TestSuiteChromosome> testCases = this.generateTests();
        ClientServices.getInstance().getClientNode().publishPermissionStatistics();
        PermissionStatistics.getInstance().printStatistics(LoggingUtils.getEvoLogger());
        List<TestGenerationResult> results = TestSuiteGenerator.writeJUnitTestsAndCreateResult(testCases);
        TestCaseExecutor.pullDown();
        ClientServices.getInstance().getClientNode().changeState(ClientState.WRITING_STATISTICS);
        LoggingUtils.getEvoLogger().info("* Done!");
        LoggingUtils.getEvoLogger().info("");
        return results;
    }

    public GeneticAlgorithm getEmployedGeneticAlgorithm() {
        return this.ga;
    }

    private List<TestSuiteChromosome> generateTests() {
        ArrayList<TestSuiteChromosome> tests = new ArrayList<TestSuiteChromosome>();
        TestCluster.getInstance();
        if (TestCluster.getInstance().getNumTestCalls() == 0) {
            LoggingUtils.getEvoLogger().info("* Found no testable methods in the target class " + Properties.TARGET_CLASS);
            return new ArrayList<TestSuiteChromosome>();
        }
        ContractChecker checker = null;
        if (Properties.CHECK_CONTRACTS) {
            checker = new ContractChecker();
            TestCaseExecutor.getInstance().addObserver(checker);
        }
        if (Properties.STRATEGY == Properties.Strategy.EVOSUITE) {
            tests.addAll(this.generateWholeSuite());
        } else if (Properties.STRATEGY == Properties.Strategy.RANDOM) {
            tests.add(this.generateRandomTests());
        } else if (Properties.STRATEGY == Properties.Strategy.RANDOM_FIXED) {
            tests.add(this.generateFixedRandomTests());
        } else {
            tests.add(this.generateIndividualTests());
        }
        if (Properties.CHECK_CONTRACTS) {
            TestCaseExecutor.getInstance().removeObserver(checker);
        }
        if (Properties.TRACK_BOOLEAN_BRANCHES) {
            int gradientBranchCount = ExecutionTraceImpl.gradientBranches.size() * 2;
            ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.Gradient_Branches, gradientBranchCount);
        }
        if (Properties.TRACK_COVERED_GRADIENT_BRANCHES) {
            int coveredGradientBranchCount = ExecutionTraceImpl.gradientBranchesCoveredTrue.size() + ExecutionTraceImpl.gradientBranchesCoveredFalse.size();
            ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.Gradient_Branches_Covered, coveredGradientBranchCount);
        }
        if (Properties.BRANCH_COMPARISON_TYPES) {
            int cmp_intzero = 0;
            int cmp_intint = 0;
            int cmp_refref = 0;
            int cmp_refnull = 0;
            for (Branch b : BranchPool.getAllBranches()) {
                int branchOpCode = b.getInstruction().getASMNode().getOpcode();
                switch (branchOpCode) {
                    case 153: 
                    case 154: 
                    case 155: 
                    case 156: 
                    case 157: 
                    case 158: {
                        ++cmp_intzero;
                        break;
                    }
                    case 159: 
                    case 160: 
                    case 161: 
                    case 162: 
                    case 163: 
                    case 164: {
                        ++cmp_intint;
                        break;
                    }
                    case 165: 
                    case 166: {
                        ++cmp_refref;
                        break;
                    }
                    case 198: 
                    case 199: {
                        ++cmp_refnull;
                    }
                }
            }
            ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.Cmp_IntZero, cmp_intzero);
            ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.Cmp_IntInt, cmp_intint);
            ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.Cmp_RefRef, cmp_refref);
            ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.Cmp_RefNull, cmp_refnull);
        }
        ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.Statements_Executed, MaxStatementsStoppingCondition.getNumExecutedStatements());
        ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.Tests_Executed, MaxTestsStoppingCondition.getNumExecutedTests());
        StatisticsSender.executedAndThenSendIndividualToMaster((TestSuiteChromosome)tests.get(0));
        ClientServices.getInstance().getClientNode().publishPermissionStatistics();
        LoggingUtils.getEvoLogger().info("* Time spent executing tests: " + TestCaseExecutor.timeExecuted + "ms");
        if (ArrayUtil.contains((Object[])Properties.CRITERION, (Object)Properties.Criterion.DEFUSE)) {
            if (Properties.ENABLE_ALTERNATIVE_FITNESS_CALCULATION) {
                LoggingUtils.getEvoLogger().info("* Time spent calculating alternative fitness: " + DefUseFitnessCalculator.alternativeTime + "ms");
            }
            LoggingUtils.getEvoLogger().info("* Time spent calculating single fitnesses: " + DefUseCoverageTestFitness.singleFitnessTime + "ms");
        }
        if (Properties.ASSERTIONS) {
            LoggingUtils.getEvoLogger().info("* Generating assertions");
            ClientServices.getInstance().getClientNode().changeState(ClientState.ASSERTION_GENERATION);
            this.addAssertions(tests);
            StatisticsSender.sendIndividualToMaster((Chromosome)tests.get(0));
        }
        if (Properties.CHECK_CONTRACTS) {
            for (TestSuiteChromosome test : tests) {
                for (TestCase failing_test : FailingTestSet.getFailingTests()) {
                    test.addTest(failing_test);
                }
            }
            FailingTestSet.sendStatistics();
        }
        LoggingUtils.getEvoLogger().info("* Compiling and checking tests");
        int i = 0;
        for (TestSuiteChromosome test : tests) {
            List<TestCase> testCases = test.getTests();
            if (Properties.JUNIT_TESTS && Properties.JUNIT_CHECK) {
                if (JUnitAnalyzer.isJavaCompilerAvailable()) {
                    if (tests.size() > 1) {
                        LoggingUtils.getEvoLogger().info("  - Compiling and checking test " + i);
                    }
                    JUnitAnalyzer.removeTestsThatDoNotCompile(testCases);
                    boolean unstable = false;
                    int numUnstable = 0;
                    numUnstable = JUnitAnalyzer.handleTestsThatAreUnstable(testCases);
                    boolean bl = unstable = numUnstable > 0;
                    if (testCases.size() > 1) {
                        Collections.reverse(testCases);
                        unstable = (numUnstable += JUnitAnalyzer.handleTestsThatAreUnstable(testCases)) > 0 || unstable;
                    }
                    ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.HadUnstableTests, unstable);
                    ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.NumUnstableTests, numUnstable);
                } else {
                    logger.error("No Java compiler is available. Are you running with the JDK?");
                }
            }
            test.clearTests();
            for (TestCase testCase : testCases) {
                test.addTest(testCase);
            }
            ++i;
        }
        for (TestSuiteChromosome test : tests) {
            assert (!Properties.JUNIT_TESTS || JUnitAnalyzer.verifyCompilationAndExecution(test.getTests()));
        }
        this.writeObjectPool(tests);
        return tests;
    }

    public static TestGenerationResult writeJUnitTestsAndCreateResult(List<TestCase> tests, String suffix) {
        if (Properties.JUNIT_TESTS) {
            ClientServices.getInstance().getClientNode().changeState(ClientState.WRITING_TESTS);
            TestSuiteWriter suite = new TestSuiteWriter();
            if (Properties.ASSERTION_STRATEGY == Properties.AssertionStrategy.STRUCTURED) {
                suite.insertAllTests(tests);
            } else {
                suite.insertTests(tests);
            }
            if (Properties.CHECK_CONTRACTS) {
                LoggingUtils.getEvoLogger().info("* Writing failing test cases");
                FailingTestSet.writeJUnitTestSuite(suite);
            }
            String name = Properties.TARGET_CLASS.substring(Properties.TARGET_CLASS.lastIndexOf(".") + 1);
            String testDir = Properties.TEST_DIR;
            LoggingUtils.getEvoLogger().info("* Writing JUnit test case '" + name + suffix + "' to " + testDir);
            suite.writeTestSuite(name + suffix, testDir);
        }
        return TestGenerationResultBuilder.buildSuccessResult();
    }

    public static List<TestGenerationResult> writeJUnitTestsAndCreateResult(List<TestSuiteChromosome> tests) {
        ArrayList<TestGenerationResult> results = new ArrayList<TestGenerationResult>();
        if (tests.size() > 1) {
            for (int i = 0; i < tests.size(); ++i) {
                results.add(TestSuiteGenerator.writeJUnitTestsAndCreateResult(tests.get(i).getTests(), "_" + i + "_" + Properties.JUNIT_SUFFIX));
            }
        } else if (tests.size() == 1 && tests.get(0).getTests().size() > 0) {
            results.add(TestSuiteGenerator.writeJUnitTestsAndCreateResult(tests.get(0).getTests(), Properties.JUNIT_SUFFIX));
        }
        return results;
    }

    private void addAssertions(List<TestSuiteChromosome> l_tests) {
        for (TestSuiteChromosome tests : l_tests) {
            this.addAssertions(tests);
        }
    }

    private void addAssertions(TestSuiteChromosome tests) {
        ContractChecker.setActive(false);
        AssertionGenerator asserter = Properties.ASSERTION_STRATEGY == Properties.AssertionStrategy.MUTATION ? new SimpleMutationAssertionGenerator() : (Properties.ASSERTION_STRATEGY == Properties.AssertionStrategy.STRUCTURED ? new StructuredAssertionGenerator() : (Properties.ASSERTION_STRATEGY == Properties.AssertionStrategy.ALL ? new CompleteAssertionGenerator() : new UnitAssertionGenerator()));
        asserter.addAssertions(tests);
        if (Properties.FILTER_ASSERTIONS) {
            asserter.filterFailingAssertions(tests);
        }
    }

    private void writeObjectPool(List<TestSuiteChromosome> suites) {
        for (TestSuiteChromosome suite : suites) {
            this.writeObjectPool(suite);
        }
    }

    private void writeObjectPool(TestSuiteChromosome suite) {
        if (!Properties.WRITE_POOL.isEmpty()) {
            LoggingUtils.getEvoLogger().info("* Writing sequences to pool");
            ObjectPool pool = ObjectPool.getPoolFromTestSuite(suite);
            pool.writePool(Properties.WRITE_POOL);
        }
    }

    private List<TestCase> carveTests(List<TestCase> testsToBeCarved) {
        ArrayList<TestCase> result = new ArrayList<TestCase>(testsToBeCarved.size());
        TestCaseExecutor executor = TestCaseExecutor.getInstance();
        TestCarvingExecutionObserver execObserver = new TestCarvingExecutionObserver();
        executor.addObserver(execObserver);
        HashSet allAccessedClasses = new HashSet();
        Logger logger = LoggingUtils.getEvoLogger();
        CaptureLogAnalyzer analyzer = new CaptureLogAnalyzer();
        EvoTestCaseCodeGenerator codeGen = new EvoTestCaseCodeGenerator();
        for (TestCase t : testsToBeCarved) {
            allAccessedClasses.addAll(t.getAccessedClasses());
            Capturer.startCapture();
            executor.execute(t);
            CaptureLog log = Capturer.stopCapture();
            Iterator iter = allAccessedClasses.iterator();
            while (iter.hasNext()) {
                Class c = (Class)iter.next();
                if (!c.isPrimitive()) continue;
                iter.remove();
            }
            if (allAccessedClasses.isEmpty()) {
                logger.warn("There are no classes which can be observed in test\n{}\n --> no test carving performed", (Object)t);
                Capturer.clear();
                continue;
            }
            logger.debug("Evosuite Test:\n{}", (Object)t);
            analyzer.analyze(log, (ICodeGenerator)codeGen, allAccessedClasses.toArray(new Class[allAccessedClasses.size()]));
            TestCase carvedTestCase = codeGen.getCode();
            codeGen.clear();
            logger.info("Carved Test:\n{}", (Object)carvedTestCase);
            result.add(carvedTestCase);
            allAccessedClasses.clear();
            Capturer.clear();
        }
        executor.removeObserver(execObserver);
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public List<TestSuiteChromosome> generateWholeSuite() {
        void var11_23;
        if (this.ga == null || this.ga.getAge() == 0) {
            LoggingUtils.getEvoLogger().info("* Setting up search algorithm for whole suite generation");
            this.ga = this.setup();
        } else {
            LoggingUtils.getEvoLogger().info("* Resuming search algorithm at generation " + this.ga.getAge() + " for whole suite generation");
        }
        if (Properties.SERIALIZE_GA || Properties.CLIENT_ON_THREAD) {
            TestGenerationResultBuilder.getInstance().setGeneticAlgorithm(this.ga);
        }
        long start_time = System.currentTimeMillis() / 1000L;
        List fitness_functions = TestSuiteGenerator.getFitnessFunction();
        this.ga.addFitnessFunctions(fitness_functions);
        if (ArrayUtil.contains((Object[])Properties.CRITERION, (Object)Properties.Criterion.STRONGMUTATION)) {
            for (FitnessFunction fitness_function : fitness_functions) {
                this.ga.addListener((StrongMutationSuiteFitness)fitness_function);
            }
        }
        this.ga.setChromosomeFactory(TestSuiteGenerator.getChromosomeFactory(fitness_functions.get(0)));
        this.ga.addListener(this.progressMonitor);
        if (ArrayUtil.contains((Object[])Properties.CRITERION, (Object)Properties.Criterion.DEFUSE) || ArrayUtil.contains((Object[])Properties.CRITERION, (Object)Properties.Criterion.ALLDEFS) || ArrayUtil.contains((Object[])Properties.CRITERION, (Object)Properties.Criterion.STATEMENT) || ArrayUtil.contains((Object[])Properties.CRITERION, (Object)Properties.Criterion.RHO) || ArrayUtil.contains((Object[])Properties.CRITERION, (Object)Properties.Criterion.AMBIGUITY)) {
            ExecutionTracer.enableTraceCalls();
        }
        this.ga.resetStoppingConditions();
        List<TestFitnessFactory<? extends TestFitnessFunction>> goalFactories = TestSuiteGenerator.getFitnessFactory();
        ArrayList<TestFitnessFunction> goals = new ArrayList<TestFitnessFunction>();
        if (goalFactories.size() == 1) {
            TestFitnessFactory<? extends TestFitnessFunction> factory = goalFactories.iterator().next();
            LoggingUtils.getEvoLogger().info("* Total number of test goals: {}", (Object)factory.getCoverageGoals().size());
            goals.addAll(factory.getCoverageGoals());
        } else {
            LoggingUtils.getEvoLogger().info("* Total number of test goals: ");
            for (TestFitnessFactory<? extends TestFitnessFunction> goalFactory : goalFactories) {
                goals.addAll(goalFactory.getCoverageGoals());
                LoggingUtils.getEvoLogger().info("  - " + goalFactory.getClass().getSimpleName().replace("CoverageFactory", "") + " " + goalFactory.getCoverageGoals().size());
            }
        }
        ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.Total_Goals, goals.size());
        List<Object> bestSuites = new ArrayList<TestSuiteChromosome>();
        if (!Properties.STOP_ZERO || !goals.isEmpty() || ArrayUtil.contains((Object[])Properties.CRITERION, (Object)Properties.Criterion.EXCEPTION)) {
            LoggingUtils.getEvoLogger().info("* Using seed {}", (Object)Randomness.getSeed());
            LoggingUtils.getEvoLogger().info("* Starting evolution");
            ClientServices.getInstance().getClientNode().changeState(ClientState.SEARCH);
            this.ga.generateSolution();
            bestSuites = this.ga.getBestIndividuals();
            if (bestSuites.isEmpty()) {
                LoggingUtils.getEvoLogger().warn("Could not find any suitable chromosome");
                return bestSuites;
            }
        } else {
            bestSuites.add(new TestSuiteChromosome());
            zero_fitness.setFinished();
            for (TestSuiteChromosome testSuiteChromosome : bestSuites) {
                for (FitnessFunction<?> ff : testSuiteChromosome.getFitnesses().keySet()) {
                    testSuiteChromosome.setCoverage(ff, 1.0);
                }
            }
        }
        long end_time = System.currentTimeMillis() / 1000L;
        if (Properties.SHOW_PROGRESS) {
            LoggingUtils.getEvoLogger().info("");
        }
        String text = " statements, best individual has fitness: ";
        if (bestSuites.size() > 1) {
            text = " statements, best individuals have fitness: ";
        }
        LoggingUtils.getEvoLogger().info("* Search finished after " + (end_time - start_time) + "s and " + this.ga.getAge() + " generations, " + MaxStatementsStoppingCondition.getNumExecutedStatements() + text + ((TestSuiteChromosome)bestSuites.get(0)).getFitness());
        if (Properties.TEST_CARVING) {
            for (TestSuiteChromosome testSuiteChromosome : bestSuites) {
                List<TestCase> list = this.carveTests(testSuiteChromosome.getTests());
                testSuiteChromosome.clearTests();
                for (TestCase t : list) {
                    testSuiteChromosome.addTest(t);
                }
            }
        }
        if (Properties.TEST_FACTORY == Properties.TestFactory.SERIALIZATION) {
            SerializationSuiteChromosomeFactory.saveTests(bestSuites);
        }
        if (Properties.MINIMIZE_VALUES && Properties.CRITERION.length == 1) {
            double fitness = ((TestSuiteChromosome)bestSuites.get(0)).getFitness();
            ClientServices.getInstance().getClientNode().changeState(ClientState.MINIMIZING_VALUES);
            LoggingUtils.getEvoLogger().info("* Minimizing values");
            ValueMinimizer valueMinimizer = new ValueMinimizer();
            valueMinimizer.minimize((TestSuiteChromosome)bestSuites.get(0), (TestSuiteFitnessFunction)fitness_functions.get(0));
            assert (fitness >= ((TestSuiteChromosome)bestSuites.get(0)).getFitness());
        }
        if (Properties.INLINE) {
            ClientServices.getInstance().getClientNode().changeState(ClientState.INLINING);
            ConstantInliner inliner = new ConstantInliner();
            for (TestSuiteChromosome testSuiteChromosome : bestSuites) {
                Map<FitnessFunction<?>, Double> fitnesses = testSuiteChromosome.getFitnesses();
                inliner.inline(testSuiteChromosome);
                for (FitnessFunction<?> fitnessFunction : fitnesses.keySet()) {
                    assert (fitnesses.get(fitnessFunction) >= testSuiteChromosome.getFitness(fitnessFunction));
                }
            }
        }
        if (Properties.MINIMIZE) {
            ClientServices.getInstance().getClientNode().changeState(ClientState.MINIMIZATION);
            TestSuiteMinimizer minimizer = new TestSuiteMinimizer(goalFactories);
            if (Properties.CRITERION.length == 1 || Properties.COMPOSITIONAL_FITNESS) {
                LoggingUtils.getEvoLogger().info("* Minimizing test suite");
                minimizer.minimize((TestSuiteChromosome)bestSuites.get(0), true);
            } else {
                LoggingUtils.getEvoLogger().info("* Minimizing test suites");
                for (TestSuiteChromosome testSuiteChromosome : bestSuites) {
                    minimizer.minimize(testSuiteChromosome, false);
                }
            }
        } else {
            ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.Result_Size, ((TestSuiteChromosome)bestSuites.get(0)).size());
            ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.Minimized_Size, ((TestSuiteChromosome)bestSuites.get(0)).size());
            ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.Result_Length, ((TestSuiteChromosome)bestSuites.get(0)).totalLengthOfTestCases());
            ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.Minimized_Length, ((TestSuiteChromosome)bestSuites.get(0)).totalLengthOfTestCases());
        }
        if (Properties.COVERAGE) {
            void var12_32;
            Properties.Criterion[] arr$ = Properties.CRITERION;
            int n = arr$.length;
            boolean bl = false;
            while (var12_32 < n) {
                Properties.Criterion pc = arr$[var12_32];
                CoverageAnalysis.analyzeCoverage((TestSuiteChromosome)bestSuites.get(0), pc);
                ++var12_32;
            }
        }
        int number_of_test_cases = 0;
        boolean bl = false;
        double d = 0.0;
        for (TestSuiteChromosome testSuiteChromosome : bestSuites) {
            number_of_test_cases += testSuiteChromosome.size();
            var11_23 += testSuiteChromosome.totalLengthOfTestCases();
            d += testSuiteChromosome.getCoverage();
        }
        d /= (double)bestSuites.size();
        if (ArrayUtil.contains((Object[])Properties.CRITERION, (Object)Properties.Criterion.MUTATION) || ArrayUtil.contains((Object[])Properties.CRITERION, (Object)Properties.Criterion.STRONGMUTATION)) {
            // empty if block
        }
        StatisticsSender.executedAndThenSendIndividualToMaster((TestSuiteChromosome)bestSuites.get(0));
        LoggingUtils.getEvoLogger().info("* Generated " + number_of_test_cases + " tests with total length " + (int)var11_23);
        if (!Properties.ANALYSIS_CRITERIA.isEmpty()) {
            CoverageAnalysis.analyzeCriteria((TestSuiteChromosome)bestSuites.get(0), Properties.ANALYSIS_CRITERIA);
        }
        if (Properties.COMPOSITIONAL_FITNESS) {
            LoggingUtils.getEvoLogger().info("* Resulting test suite's coverage: " + NumberFormat.getPercentInstance().format(d) + " (average coverage for all fitness functions)");
        } else {
            LoggingUtils.getEvoLogger().info("* Resulting test suite's coverage: " + NumberFormat.getPercentInstance().format(d));
        }
        this.ga.printBudget();
        if (ArrayUtil.contains((Object[])Properties.CRITERION, (Object)Properties.Criterion.DEFUSE) && Properties.ANALYSIS_CRITERIA.isEmpty()) {
            DefUseCoverageSuiteFitness.printCoverage();
        }
        if (Properties.LOCAL_SEARCH_DSE != Properties.DSEType.OFF) {
            DSEStats.printStatistics();
        }
        if (Properties.FILTER_SANDBOX_TESTS) {
            for (TestSuiteChromosome testSuiteChromosome : bestSuites) {
                for (TestChromosome test : testSuiteChromosome.getTestChromosomes()) {
                    int position;
                    ExecutionResult result = test.getLastExecutionResult();
                    if (result == null) {
                        result = TestCaseExecutor.runTest(test.getTestCase());
                    }
                    if (!result.hasSecurityException() || (position = result.getFirstPositionOfThrownException().intValue()) <= 0) continue;
                    test.getTestCase().chop(position);
                    result = TestCaseExecutor.runTest(test.getTestCase());
                    test.setLastExecutionResult(result);
                }
            }
        }
        return bestSuites;
    }

    private void printTestCriterion() {
        if (Properties.CRITERION.length > 1) {
            LoggingUtils.getEvoLogger().info("* Test criteria:");
        } else {
            LoggingUtils.getEvoLogger().info("* Test criterion:");
        }
        for (int i = 0; i < Properties.CRITERION.length; ++i) {
            this.printTestCriterion(Properties.CRITERION[i]);
        }
    }

    private void printTestCriterion(Properties.Criterion criterion) {
        switch (criterion) {
            case WEAKMUTATION: {
                LoggingUtils.getEvoLogger().info("  - Mutation testing (weak)");
                break;
            }
            case ONLYMUTATION: {
                LoggingUtils.getEvoLogger().info("  - Only Mutation testing (weak)");
                break;
            }
            case STRONGMUTATION: 
            case MUTATION: {
                LoggingUtils.getEvoLogger().info("  - Mutation testing (strong)");
                break;
            }
            case DEFUSE: {
                LoggingUtils.getEvoLogger().info("  - All DU Pairs");
                break;
            }
            case STATEMENT: {
                LoggingUtils.getEvoLogger().info("  - Statement Coverage");
                break;
            }
            case RHO: {
                LoggingUtils.getEvoLogger().info("  - Rho Coverage");
                break;
            }
            case AMBIGUITY: {
                LoggingUtils.getEvoLogger().info("  - Ambiguity Coverage");
                break;
            }
            case ALLDEFS: {
                LoggingUtils.getEvoLogger().info("  - All Definitions");
                break;
            }
            case EXCEPTION: {
                LoggingUtils.getEvoLogger().info("  - Exception");
                break;
            }
            case ONLYBRANCH: {
                LoggingUtils.getEvoLogger().info("  - Only-Branch Coverage");
                break;
            }
            case METHODTRACE: {
                LoggingUtils.getEvoLogger().info("  - Method Coverage");
                break;
            }
            case METHOD: {
                LoggingUtils.getEvoLogger().info("  - Top-Level Method Coverage");
                break;
            }
            case METHODNOEXCEPTION: {
                LoggingUtils.getEvoLogger().info("  - No-Exception Top-Level Method Coverage");
                break;
            }
            case LINE: {
                LoggingUtils.getEvoLogger().info("  - Line Coverage");
                break;
            }
            case OUTPUT: {
                LoggingUtils.getEvoLogger().info("  - Method-Output Coverage");
                break;
            }
            default: {
                LoggingUtils.getEvoLogger().info("  - Branch Coverage");
            }
        }
    }

    public static List<TestSuiteFitnessFunction> getFitnessFunction() {
        ArrayList<TestSuiteFitnessFunction> ffs = new ArrayList<TestSuiteFitnessFunction>();
        for (int i = 0; i < Properties.CRITERION.length; ++i) {
            ffs.add(TestSuiteGenerator.getFitnessFunction(Properties.CRITERION[i]));
        }
        return ffs;
    }

    public static TestSuiteFitnessFunction getFitnessFunction(Properties.Criterion criterion) {
        switch (criterion) {
            case STRONGMUTATION: {
                return new StrongMutationSuiteFitness();
            }
            case WEAKMUTATION: {
                return new WeakMutationSuiteFitness();
            }
            case MUTATION: {
                return new StrongMutationSuiteFitness();
            }
            case ONLYMUTATION: {
                return new OnlyMutationSuiteFitness();
            }
            case DEFUSE: {
                return new DefUseCoverageSuiteFitness();
            }
            case BRANCH: {
                return new BranchCoverageSuiteFitness();
            }
            case IBRANCH: {
                return new IBranchSuiteFitness();
            }
            case STATEMENT: {
                return new StatementCoverageSuiteFitness();
            }
            case RHO: {
                return new RhoCoverageSuiteFitness();
            }
            case AMBIGUITY: {
                return new AmbiguityCoverageSuiteFitness();
            }
            case ALLDEFS: {
                return new AllDefsCoverageSuiteFitness();
            }
            case EXCEPTION: {
                return new ExceptionCoverageSuiteFitness();
            }
            case REGRESSION: {
                return new RegressionSuiteFitness();
            }
            case READABILITY: {
                return new ReadabilitySuiteFitness();
            }
            case ONLYBRANCH: {
                return new OnlyBranchCoverageSuiteFitness();
            }
            case METHODTRACE: {
                return new MethodTraceCoverageSuiteFitness();
            }
            case METHOD: {
                return new MethodCoverageSuiteFitness();
            }
            case METHODNOEXCEPTION: {
                return new MethodNoExceptionCoverageSuiteFitness();
            }
            case LINE: {
                return new LineCoverageSuiteFitness();
            }
            case OUTPUT: {
                return new OutputCoverageSuiteFitness();
            }
        }
        logger.warn("No TestSuiteFitnessFunction defined for " + Properties.CRITERION + " using default one (BranchCoverageSuiteFitness)");
        return new BranchCoverageSuiteFitness();
    }

    public static List<TestFitnessFactory<? extends TestFitnessFunction>> getFitnessFactory() {
        ArrayList<TestFitnessFactory<? extends TestFitnessFunction>> goalsFactory = new ArrayList<TestFitnessFactory<? extends TestFitnessFunction>>();
        for (int i = 0; i < Properties.CRITERION.length; ++i) {
            goalsFactory.add(TestSuiteGenerator.getFitnessFactory(Properties.CRITERION[i]));
        }
        return goalsFactory;
    }

    public static TestFitnessFactory<? extends TestFitnessFunction> getFitnessFactory(Properties.Criterion crit) {
        switch (crit) {
            case STRONGMUTATION: 
            case MUTATION: {
                return new MutationFactory();
            }
            case WEAKMUTATION: {
                return new MutationFactory(false);
            }
            case ONLYMUTATION: {
                return new OnlyMutationFactory();
            }
            case DEFUSE: {
                return new DefUseCoverageFactory();
            }
            case BRANCH: {
                return new BranchCoverageFactory();
            }
            case IBRANCH: {
                return new IBranchFitnessFactory();
            }
            case STATEMENT: {
                return new StatementCoverageFactory();
            }
            case RHO: {
                return new RhoCoverageFactory();
            }
            case AMBIGUITY: {
                return new AmbiguityCoverageFactory();
            }
            case ALLDEFS: {
                return new AllDefsCoverageFactory();
            }
            case EXCEPTION: {
                return new ExceptionCoverageFactory();
            }
            case ONLYBRANCH: {
                return new OnlyBranchCoverageFactory();
            }
            case METHODTRACE: {
                return new MethodTraceCoverageFactory();
            }
            case METHOD: {
                return new MethodCoverageFactory();
            }
            case METHODNOEXCEPTION: {
                return new MethodNoExceptionCoverageFactory();
            }
            case LINE: {
                return new LineCoverageFactory();
            }
            case OUTPUT: {
                return new OutputCoverageFactory();
            }
        }
        logger.warn("No TestFitnessFactory defined for " + (Object)((Object)crit) + " using default one (BranchCoverageFactory)");
        return new BranchCoverageFactory();
    }

    private TestSuiteChromosome bootstrapRandomSuite(FitnessFunction<?> fitness, TestFitnessFactory<?> goals) {
        if (ArrayUtil.contains((Object[])Properties.CRITERION, (Object)Properties.Criterion.DEFUSE) || ArrayUtil.contains((Object[])Properties.CRITERION, (Object)Properties.Criterion.ALLDEFS)) {
            LoggingUtils.getEvoLogger().info("* Disabled random bootstraping for dataflow criterion");
            Properties.RANDOM_TESTS = 0;
        }
        if (Properties.RANDOM_TESTS > 0) {
            LoggingUtils.getEvoLogger().info("* Bootstrapping initial random test suite");
        }
        FixedSizeTestSuiteChromosomeFactory factory = new FixedSizeTestSuiteChromosomeFactory(Properties.RANDOM_TESTS);
        TestSuiteChromosome suite = factory.getChromosome();
        if (Properties.RANDOM_TESTS > 0) {
            TestSuiteMinimizer minimizer = new TestSuiteMinimizer(goals);
            minimizer.minimize(suite, true);
            LoggingUtils.getEvoLogger().info("* Initial test suite contains " + suite.size() + " tests");
        }
        return suite;
    }

    private boolean isFinished(TestSuiteChromosome chromosome) {
        if (stopping_condition.isFinished()) {
            return true;
        }
        if (Properties.STOP_ZERO && chromosome.getFitness() == 0.0) {
            return true;
        }
        return !(stopping_condition instanceof MaxTimeStoppingCondition) && global_time.isFinished();
    }

    public TestSuiteChromosome generateFixedRandomTests() {
        LoggingUtils.getEvoLogger().info("* Generating fixed number of random tests");
        RandomLengthTestFactory factory = new RandomLengthTestFactory();
        TestSuiteChromosome suite = new TestSuiteChromosome();
        GeneticAlgorithm<TestSuiteChromosome> suiteGA = TestSuiteGenerator.getGeneticAlgorithm(new TestSuiteChromosomeFactory());
        stopping_condition = TestSuiteGenerator.getStoppingCondition();
        for (int i = 0; i < Properties.NUM_RANDOM_TESTS && !suiteGA.isFinished(); ++i) {
            logger.info("Current test: " + i + "/" + Properties.NUM_RANDOM_TESTS);
            TestChromosome test = factory.getChromosome();
            ExecutionResult result = TestCaseExecutor.runTest(test.getTestCase());
            Integer pos = result.getFirstPositionOfThrownException();
            if (pos != null) {
                if (result.getExceptionThrownAtPosition(pos) instanceof CodeUnderTestException || result.getExceptionThrownAtPosition(pos) instanceof UncompilableCodeException || result.getExceptionThrownAtPosition(pos) instanceof TestCaseExecutor.TimeoutExceeded) continue;
                test.getTestCase().chop(pos + 1);
                test.setChanged(true);
            } else {
                test.setLastExecutionResult(result);
            }
            suite.addTest(test);
        }
        suiteGA.getPopulation().add(suite);
        suiteGA.printBudget();
        return suite;
    }

    public TestSuiteChromosome generateRandomTests() {
        LoggingUtils.getEvoLogger().info("* Using random test generation");
        List fitness_functions = TestSuiteGenerator.getFitnessFunction();
        TestSuiteChromosome suite = new TestSuiteChromosome();
        for (TestSuiteFitnessFunction testSuiteFitnessFunction : fitness_functions) {
            suite.addFitness(testSuiteFitnessFunction);
        }
        List<TestFitnessFactory<? extends TestFitnessFunction>> goalFactories = TestSuiteGenerator.getFitnessFactory();
        ArrayList<? extends TestFitnessFunction> arrayList = new ArrayList<TestFitnessFunction>();
        LoggingUtils.getEvoLogger().info("* Total number of test goals: ");
        for (TestFitnessFactory<? extends TestFitnessFunction> goalFactory : goalFactories) {
            arrayList.addAll(goalFactory.getCoverageGoals());
            LoggingUtils.getEvoLogger().info("  - " + goalFactory.getClass().getSimpleName().replace("CoverageFactory", "") + " " + goalFactory.getCoverageGoals().size());
        }
        ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.Total_Goals, arrayList.size());
        GeneticAlgorithm<TestSuiteChromosome> suiteGA = TestSuiteGenerator.getGeneticAlgorithm(new TestSuiteChromosomeFactory());
        suiteGA.addFitnessFunctions(fitness_functions);
        this.ga = suiteGA;
        RandomLengthTestFactory factory = new RandomLengthTestFactory();
        stopping_condition = TestSuiteGenerator.getStoppingCondition();
        for (FitnessFunction fitness_function : fitness_functions) {
            ((TestSuiteFitnessFunction)fitness_function).getFitness(suite);
        }
        ClientServices.getInstance().getClientNode().changeState(ClientState.SEARCH);
        while (!this.isFinished(suite)) {
            TestChromosome test = factory.getChromosome();
            TestSuiteChromosome clone = suite.clone();
            clone.addTest(test);
            for (FitnessFunction fitness_function : fitness_functions) {
                ((TestSuiteFitnessFunction)fitness_function).getFitness(clone);
                logger.debug("Old fitness: {}, new fitness: {}", (Object)suite.getFitness(), (Object)clone.getFitness());
            }
            if (clone.compareTo(suite) >= 0) continue;
            suite = clone;
            StatisticsSender.executedAndThenSendIndividualToMaster(clone);
        }
        suiteGA.getPopulation().add(suite);
        suiteGA.printBudget();
        if (Properties.MINIMIZE && Properties.CRITERION.length == 1) {
            LoggingUtils.getEvoLogger().info("* Minimizing result");
            ClientServices.getInstance().getClientNode().changeState(ClientState.MINIMIZATION);
            TestSuiteMinimizer minimizer = new TestSuiteMinimizer(goalFactories);
            minimizer.minimize((TestSuiteChromosome)suiteGA.getBestIndividual(), true);
        }
        ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.Statements_Executed, MaxStatementsStoppingCondition.getNumExecutedStatements());
        ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.Tests_Executed, MaxTestsStoppingCondition.getNumExecutedTests());
        ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.Fitness_Evaluations, MaxTestsStoppingCondition.getNumExecutedTests());
        if (!Properties.ANALYSIS_CRITERIA.isEmpty()) {
            CoverageAnalysis.analyzeCriteria(suite, Properties.ANALYSIS_CRITERIA);
        }
        return suite;
    }

    /*
     * Could not resolve type clashes
     */
    public TestSuiteChromosome generateIndividualTests() {
        int total_goals;
        LoggingUtils.getEvoLogger().info("* Setting up search algorithm for individual test generation");
        ExecutionTracer.enableTraceCalls();
        if (this.ga == null) {
            this.ga = this.setup();
        }
        GeneticAlgorithm<TestSuiteChromosome> suiteGA = TestSuiteGenerator.getGeneticAlgorithm(new TestSuiteChromosomeFactory());
        List fitness_functions = TestSuiteGenerator.getFitnessFunction();
        suiteGA.addFitnessFunctions(fitness_functions);
        long start_time = System.currentTimeMillis() / 1000L;
        FitnessLogger fitnessLogger = new FitnessLogger();
        if (Properties.LOG_GOALS) {
            this.ga.addListener(fitnessLogger);
        }
        List<TestFitnessFactory<? extends TestFitnessFunction>> goalFactories = TestSuiteGenerator.getFitnessFactory();
        long goalComputationStart = System.currentTimeMillis();
        ArrayList<? extends TestFitnessFunction> goals = new ArrayList<TestFitnessFunction>();
        LoggingUtils.getEvoLogger().info("* Total number of test goals: ");
        for (TestFitnessFactory<? extends TestFitnessFunction> goalFactory : goalFactories) {
            goals.addAll(goalFactory.getCoverageGoals());
            LoggingUtils.getEvoLogger().info("  - " + goalFactory.getClass().getSimpleName().replace("CoverageFactory", "") + " " + goalFactory.getCoverageGoals().size());
        }
        if (AbstractFitnessFactory.goalComputationTime != 0L) {
            AbstractFitnessFactory.goalComputationTime = System.currentTimeMillis() - goalComputationStart;
        }
        if (Properties.SHUFFLE_GOALS) {
            Randomness.shuffle(goals);
        }
        ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.Total_Goals, goals.size());
        LoggingUtils.getEvoLogger().info("* Total number of test goals: " + goals.size());
        TestSuiteChromosome suite = this.bootstrapRandomSuite(fitness_functions.get(0), goalFactories.get(0));
        suiteGA.getPopulation().add(suite);
        HashSet<Integer> covered = new HashSet<Integer>();
        int covered_goals = 0;
        int num = 0;
        for (TestFitnessFunction fitness_function : goals) {
            if (fitness_function.isCovered(suite.getTests())) {
                covered.add(num);
                ++covered_goals;
            }
            ++num;
        }
        if (covered_goals > 0) {
            LoggingUtils.getEvoLogger().info("* Random bootstrapping covered " + covered_goals + " test goals");
        }
        if (covered_goals == (total_goals = goals.size())) {
            zero_fitness.setFinished();
        }
        int current_budget = 0;
        long total_budget = Properties.SEARCH_BUDGET;
        LoggingUtils.getEvoLogger().info("* Budget: " + NumberFormat.getIntegerInstance().format(total_budget));
        block2: while ((long)current_budget < total_budget && covered_goals < total_goals && !global_time.isFinished() && !ShutdownTestWriter.isInterrupted()) {
            long budget = (total_budget - (long)current_budget) / (long)(total_goals - covered_goals);
            logger.info("Budget: " + budget + "/" + (total_budget - (long)current_budget));
            logger.info("Statements: " + current_budget + "/" + total_budget);
            logger.info("Goals covered: " + covered_goals + "/" + total_goals);
            stopping_condition.setLimit(budget);
            num = 0;
            for (TestFitnessFunction fitnessFunction : goals) {
                if (covered.contains(num)) {
                    ++num;
                    continue;
                }
                this.ga.resetStoppingConditions();
                this.ga.clearPopulation();
                this.ga.setChromosomeFactory(TestSuiteGenerator.getChromosomeFactory(fitnessFunction));
                if (Properties.PRINT_CURRENT_GOALS) {
                    LoggingUtils.getEvoLogger().info("* Searching for goal " + num + ": " + fitnessFunction.toString());
                }
                logger.info("Goal " + num + "/" + (total_goals - covered_goals) + ": " + fitnessFunction);
                if (ShutdownTestWriter.isInterrupted()) {
                    ++num;
                    continue;
                }
                if (global_time.isFinished()) {
                    LoggingUtils.getEvoLogger().info("Skipping goal because time is up");
                    ++num;
                    continue;
                }
                this.ga.addFitnessFunction(fitnessFunction);
                logger.info("Starting evolution for goal " + fitnessFunction);
                this.ga.generateSolution();
                if (this.ga.getBestIndividual().getFitness() == 0.0) {
                    if (Properties.PRINT_COVERED_GOALS) {
                        LoggingUtils.getEvoLogger().info("* Covered!");
                    }
                    logger.info("Found solution, adding to test suite at " + MaxStatementsStoppingCondition.getNumExecutedStatements());
                    TestChromosome best = (TestChromosome)this.ga.getBestIndividual();
                    if (Properties.MINIMIZE && Properties.CRITERION.length == 1) {
                        ClientServices.getInstance().getClientNode().changeState(ClientState.MINIMIZATION);
                        TestCaseMinimizer minimizer = new TestCaseMinimizer(fitnessFunction);
                        minimizer.minimize(best);
                    }
                    best.getTestCase().addCoveredGoal(fitnessFunction);
                    suite.addTest(best);
                    suiteGA.getPopulation().set(0, suite);
                    for (TestSuiteFitnessFunction fitness_function : fitness_functions) {
                        fitness_function.getFitness(suite);
                    }
                    ++covered_goals;
                    covered.add(num);
                    if (Properties.SKIP_COVERED) {
                        Set<Integer> additional_covered_nums = this.getAdditionallyCoveredGoals(goals, covered, best);
                        for (Integer covered_num : additional_covered_nums) {
                            ++covered_goals;
                            covered.add(covered_num);
                        }
                    }
                } else {
                    logger.info("Found no solution for " + fitnessFunction + " at " + MaxStatementsStoppingCondition.getNumExecutedStatements());
                }
                current_budget = Properties.REUSE_BUDGET ? (int)((long)current_budget + stopping_condition.getCurrentValue()) : (int)((long)current_budget + (budget + 1L));
                if (Properties.SHOW_PROGRESS && !Properties.PRINT_COVERED_GOALS && !Properties.PRINT_CURRENT_GOALS) {
                    double percent = current_budget;
                    percent = percent / (double)total_budget * 100.0;
                    double coverage = covered_goals;
                    coverage = coverage / (double)total_goals * 100.0;
                }
                if ((long)current_budget > total_budget) continue block2;
                ++num;
            }
        }
        if (Properties.SHOW_PROGRESS) {
            LoggingUtils.getEvoLogger().info("");
        }
        if (global_time.isFinished()) {
            LoggingUtils.getEvoLogger().info("! Timeout reached");
        }
        if ((long)current_budget >= total_budget) {
            LoggingUtils.getEvoLogger().info("! Budget exceeded");
        } else {
            LoggingUtils.getEvoLogger().info("* Remaining budget: " + (total_budget - (long)current_budget));
        }
        stopping_condition.setLimit(Properties.SEARCH_BUDGET);
        stopping_condition.forceCurrentValue(current_budget);
        suiteGA.setStoppingCondition(stopping_condition);
        suiteGA.addStoppingCondition(global_time);
        suiteGA.printBudget();
        int c = 0;
        int uncovered_goals = total_goals - covered_goals;
        if (uncovered_goals < 10) {
            for (TestFitnessFunction goal : goals) {
                if (!covered.contains(c)) {
                    LoggingUtils.getEvoLogger().info("! Unable to cover goal " + c + " " + goal.toString());
                }
                ++c;
            }
        } else {
            LoggingUtils.getEvoLogger().info("! #Goals that were not covered: " + uncovered_goals);
        }
        long end_time = System.currentTimeMillis() / 1000L;
        LoggingUtils.getEvoLogger().info("* Search finished after " + (end_time - start_time) + "s, " + current_budget + " statements, best individual has fitness " + suite.getFitness());
        if (!Properties.ANALYSIS_CRITERIA.isEmpty()) {
            CoverageAnalysis.analyzeCriteria(suite, Properties.ANALYSIS_CRITERIA);
        }
        LoggingUtils.getEvoLogger().info("* Covered " + covered_goals + "/" + goals.size() + " goals");
        logger.info("Resulting test suite: " + suite.size() + " tests, length " + suite.totalLengthOfTestCases());
        if (Properties.MINIMIZE && Properties.CRITERION.length == 1) {
            LoggingUtils.getEvoLogger().info("* Minimizing result");
            logger.info("Size before: " + suite.totalLengthOfTestCases());
            TestSuiteMinimizer minimizer = new TestSuiteMinimizer(goalFactories);
            minimizer.minimize(suite, true);
            logger.info("Size after: " + suite.totalLengthOfTestCases());
        }
        if (Properties.INLINE) {
            ConstantInliner inliner = new ConstantInliner();
            inliner.inline(suite);
        }
        if (Properties.COVERAGE) {
            for (Properties.Criterion pc : Properties.CRITERION) {
                CoverageAnalysis.analyzeCoverage(suite, pc);
            }
        }
        LoggingUtils.getEvoLogger().info("* Resulting test suite: " + suite.size() + " tests, length " + suite.totalLengthOfTestCases());
        return suite;
    }

    private Set<Integer> getAdditionallyCoveredGoals(List<? extends TestFitnessFunction> goals, Set<Integer> covered, TestChromosome best) {
        HashSet<Integer> r = new HashSet<Integer>();
        ExecutionResult result = best.getLastExecutionResult();
        assert (result != null);
        int num = -1;
        for (TestFitnessFunction testFitnessFunction : goals) {
            if (covered.contains(++num) || !testFitnessFunction.isCovered(best, result)) continue;
            r.add(num);
            if (!Properties.PRINT_COVERED_GOALS) continue;
            LoggingUtils.getEvoLogger().info("* Additionally covered: " + testFitnessFunction.toString());
        }
        return r;
    }

    public static StoppingCondition getStoppingCondition() {
        logger.info("Setting stopping condition: " + (Object)((Object)Properties.STOPPING_CONDITION));
        switch (Properties.STOPPING_CONDITION) {
            case MAXGENERATIONS: {
                return new MaxGenerationStoppingCondition();
            }
            case MAXFITNESSEVALUATIONS: {
                return new MaxFitnessEvaluationsStoppingCondition();
            }
            case MAXTIME: {
                return new MaxTimeStoppingCondition();
            }
            case MAXTESTS: {
                return new MaxTestsStoppingCondition();
            }
            case MAXSTATEMENTS: {
                return new MaxStatementsStoppingCondition();
            }
        }
        logger.warn("Unknown stopping condition: " + (Object)((Object)Properties.STOPPING_CONDITION));
        return new MaxGenerationStoppingCondition();
    }

    public static CrossOverFunction getCrossoverFunction() {
        switch (Properties.CROSSOVER_FUNCTION) {
            case SINGLEPOINTFIXED: {
                return new SinglePointFixedCrossOver();
            }
            case SINGLEPOINTRELATIVE: {
                return new SinglePointRelativeCrossOver();
            }
            case SINGLEPOINT: {
                return new SinglePointCrossOver();
            }
            case COVERAGE: {
                if (Properties.STRATEGY != Properties.Strategy.EVOSUITE) {
                    throw new RuntimeException("Coverage crossover function requires test suite mode");
                }
                return new CoverageCrossOver();
            }
        }
        throw new RuntimeException("Unknown crossover function: " + (Object)((Object)Properties.CROSSOVER_FUNCTION));
    }

    public static SelectionFunction getSelectionFunction() {
        switch (Properties.SELECTION_FUNCTION) {
            case ROULETTEWHEEL: {
                return new FitnessProportionateSelection();
            }
            case TOURNAMENT: {
                return new TournamentSelection();
            }
            case BINARY_TOURNAMENT: {
                return new BinaryTournamentSelectionCrowdedComparison();
            }
        }
        return new RankSelection();
    }

    public static GeneticAlgorithm<TestSuiteChromosome> getLastGeneticAlgorithm() {
        try {
            FileInputStream fis = new FileInputStream(Properties.SEED_FILE);
            ObjectInputStream oo = new ObjectInputStream(fis);
            Object stored = oo.readObject();
            GeneticAlgorithm<TestSuiteChromosome> lastGa = null;
            if (stored instanceof GeneticAlgorithm) {
                lastGa = (GeneticAlgorithm<TestSuiteChromosome>)stored;
            } else if (stored instanceof TestGenerationResult) {
                lastGa = ((TestGenerationResult)stored).getGeneticAlgorithm();
            }
            if (lastGa != null && lastGa.getBestIndividual() instanceof TestSuiteChromosome) {
                return lastGa;
            }
            LoggingUtils.getEvoLogger().error("* Could not load Genetic Algorithm from file " + Properties.SEED_FILE);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return null;
    }

    protected static ChromosomeFactory<? extends Chromosome> getChromosomeFactory(FitnessFunction<? extends Chromosome> fitness) {
        TestSuiteChromosomeFactory defaultSeedingFactory = new TestSuiteChromosomeFactory(new RandomLengthTestFactory());
        switch (Properties.STRATEGY) {
            case EVOSUITE: {
                switch (Properties.TEST_FACTORY) {
                    case ALLMETHODS: {
                        logger.info("Using all methods chromosome factory");
                        return new TestSuiteChromosomeFactory(new AllMethodsTestChromosomeFactory());
                    }
                    case RANDOM: {
                        logger.info("Using random chromosome factory");
                        return new TestSuiteChromosomeFactory(new RandomLengthTestFactory());
                    }
                    case TOURNAMENT: {
                        logger.info("Using tournament chromosome factory");
                        return new TournamentChromosomeFactory<TestSuiteChromosome>(fitness, new TestSuiteChromosomeFactory());
                    }
                    case JUNIT: {
                        logger.info("Using seeding chromosome factory");
                        JUnitTestCarvedChromosomeFactory factory = new JUnitTestCarvedChromosomeFactory(new RandomLengthTestFactory());
                        return new TestSuiteChromosomeFactory(factory);
                    }
                    case SERIALIZATION: {
                        logger.info("Using serialization seeding chromosome factory");
                        return new SerializationSuiteChromosomeFactory(new RandomLengthTestFactory());
                    }
                    case SEED_BEST_INDIVIDUAL: {
                        logger.info("Using Best Individual Seeding factory");
                        GeneticAlgorithm<TestSuiteChromosome> lastGa = TestSuiteGenerator.getLastGeneticAlgorithm();
                        if (lastGa instanceof GeneticAlgorithm) {
                            return new BestIndividualTestSuiteChromosomeFactory(defaultSeedingFactory, (TestSuiteChromosome)lastGa.getBestIndividual());
                        }
                        return defaultSeedingFactory;
                    }
                    case SEED_RANDOM_INDIVIDUAL: {
                        logger.info("Using Random Individual Seeding factory");
                        GeneticAlgorithm<TestSuiteChromosome> lastGa = TestSuiteGenerator.getLastGeneticAlgorithm();
                        if (lastGa instanceof GeneticAlgorithm) {
                            return new RandomIndividualTestSuiteChromosomeFactory(defaultSeedingFactory, lastGa);
                        }
                        return defaultSeedingFactory;
                    }
                    case SEED_BEST_AND_RANDOM_INDIVIDUAL: {
                        logger.info("Using Best and Random Individual Seeding factory");
                        GeneticAlgorithm<TestSuiteChromosome> lastGa = TestSuiteGenerator.getLastGeneticAlgorithm();
                        if (lastGa instanceof GeneticAlgorithm) {
                            return new BIAndRITestSuiteChromosomeFactory(defaultSeedingFactory, lastGa);
                        }
                        return defaultSeedingFactory;
                    }
                    case SEED_BEST_INDIVIDUAL_METHOD: {
                        logger.info("Using Best Individual (methods) Seeding factory");
                        GeneticAlgorithm<TestSuiteChromosome> lastGa = TestSuiteGenerator.getLastGeneticAlgorithm();
                        if (lastGa instanceof GeneticAlgorithm) {
                            return new BIMethodSeedingTestSuiteChromosomeFactory(defaultSeedingFactory, (TestSuiteChromosome)lastGa.getBestIndividual());
                        }
                        return defaultSeedingFactory;
                    }
                    case SEED_RANDOM_INDIVIDUAL_METHOD: {
                        logger.info("Using Random Individual (methods) Seeding factory");
                        GeneticAlgorithm<TestSuiteChromosome> lastGa = TestSuiteGenerator.getLastGeneticAlgorithm();
                        if (lastGa instanceof GeneticAlgorithm) {
                            return new RandomMethodSeedingTestSuiteChromosomeFactory(defaultSeedingFactory, lastGa);
                        }
                        return defaultSeedingFactory;
                    }
                    case SEED_MUTATED_BEST_INDIVIDUAL: {
                        logger.info("Using Mutated Best Individual (methods) Seeding factory");
                        GeneticAlgorithm<TestSuiteChromosome> lastGa = TestSuiteGenerator.getLastGeneticAlgorithm();
                        if (lastGa instanceof GeneticAlgorithm) {
                            return new BIMutatedMethodSeedingTestSuiteChromosomeFactory(defaultSeedingFactory, (TestSuiteChromosome)lastGa.getBestIndividual());
                        }
                        return defaultSeedingFactory;
                    }
                }
                throw new RuntimeException("Unsupported test factory: " + (Object)((Object)Properties.TEST_FACTORY));
            }
            case REGRESSION: {
                return new RegressionTestSuiteChromosomeFactory();
            }
        }
        switch (Properties.TEST_FACTORY) {
            case ALLMETHODS: {
                logger.info("Using all methods chromosome factory");
                return new AllMethodsTestChromosomeFactory();
            }
            case RANDOM: {
                logger.info("Using random chromosome factory");
                return new RandomLengthTestFactory();
            }
            case TOURNAMENT: {
                logger.info("Using tournament chromosome factory");
                return new TournamentChromosomeFactory<TestChromosome>(fitness, new RandomLengthTestFactory());
            }
            case JUNIT: {
                logger.info("Using seeding chromosome factory");
                return new JUnitTestCarvedChromosomeFactory(new RandomLengthTestFactory());
            }
            case SERIALIZATION: {
                logger.info("Using serialization seeding chromosome factory");
                return new SerializationSuiteChromosomeFactory(new RandomLengthTestFactory());
            }
        }
        throw new RuntimeException("Unsupported test factory: " + (Object)((Object)Properties.TEST_FACTORY));
    }

    public static ChromosomeFactory<? extends Chromosome> getDefaultChromosomeFactory() {
        switch (Properties.STRATEGY) {
            case EVOSUITE: {
                return new TestSuiteChromosomeFactory(new RandomLengthTestFactory());
            }
            case REGRESSION: {
                return new RegressionTestChromosomeFactory();
            }
        }
        return new RandomLengthTestFactory();
    }

    public static SecondaryObjective getSecondaryTestObjective(String name) {
        if (name.equalsIgnoreCase("size")) {
            return new MinimizeSizeSecondaryObjective();
        }
        if (name.equalsIgnoreCase("exceptions")) {
            return new MinimizeExceptionsSecondaryObjective();
        }
        throw new RuntimeException("ERROR: asked for unknown secondary objective \"" + name + "\"");
    }

    public static SecondaryObjective getSecondarySuiteObjective(String name) {
        if (name.equalsIgnoreCase("size")) {
            return new MinimizeSizeSecondaryObjective();
        }
        if (name.equalsIgnoreCase("maxlength")) {
            return new MinimizeMaxLengthSecondaryObjective();
        }
        if (name.equalsIgnoreCase("averagelength")) {
            return new MinimizeAverageLengthSecondaryObjective();
        }
        if (name.equalsIgnoreCase("exceptions")) {
            return new org.evosuite.testsuite.MinimizeExceptionsSecondaryObjective();
        }
        if (name.equalsIgnoreCase("totallength")) {
            return new MinimizeTotalLengthSecondaryObjective();
        }
        throw new RuntimeException("ERROR: asked for unknown secondary objective \"" + name + "\"");
    }

    public static void getSecondaryObjectives(GeneticAlgorithm algorithm) {
        String objectives = Properties.SECONDARY_OBJECTIVE;
        if (objectives == null || objectives.trim().length() == 0 || objectives.trim().equalsIgnoreCase("none")) {
            return;
        }
        for (String name : objectives.split(":")) {
            try {
                TestChromosome.addSecondaryObjective(TestSuiteGenerator.getSecondaryTestObjective(name.trim()));
            }
            catch (Throwable t) {
                // empty catch block
            }
            TestSuiteChromosome.addSecondaryObjective(TestSuiteGenerator.getSecondarySuiteObjective(name.trim()));
        }
    }

    public static PopulationLimit getPopulationLimit() {
        switch (Properties.POPULATION_LIMIT) {
            case INDIVIDUALS: {
                return new IndividualPopulationLimit();
            }
            case TESTS: {
                return new SizePopulationLimit();
            }
            case STATEMENTS: {
                return new StatementsPopulationLimit();
            }
        }
        throw new RuntimeException("Unsupported population limit");
    }

    public static <T extends Chromosome> GeneticAlgorithm<T> getGeneticAlgorithm(ChromosomeFactory<T> factory) {
        switch (Properties.ALGORITHM) {
            case ONEPLUSONEEA: {
                logger.info("Chosen search algorithm: (1+1)EA");
                return new OnePlusOneEA<T>(factory);
            }
            case STEADYSTATEGA: {
                logger.info("Chosen search algorithm: SteadyStateGA");
                SteadyStateGA<T> ga = new SteadyStateGA<T>(factory);
                if (Properties.REPLACEMENT_FUNCTION == Properties.TheReplacementFunction.FITNESSREPLACEMENT) {
                    ga.setReplacementFunction(new FitnessReplacementFunction());
                } else if (Properties.STRATEGY == Properties.Strategy.EVOSUITE) {
                    ga.setReplacementFunction(new TestSuiteReplacementFunction());
                } else {
                    ga.setReplacementFunction(new TestCaseReplacementFunction());
                }
                return ga;
            }
            case MUPLUSLAMBDAGA: {
                logger.info("Chosen search algorithm: MuPlusLambdaGA");
                MuPlusLambdaGA<T> ga = new MuPlusLambdaGA<T>(factory);
                if (Properties.REPLACEMENT_FUNCTION == Properties.TheReplacementFunction.FITNESSREPLACEMENT) {
                    ga.setReplacementFunction(new FitnessReplacementFunction());
                } else if (Properties.STRATEGY == Properties.Strategy.EVOSUITE) {
                    ga.setReplacementFunction(new TestSuiteReplacementFunction());
                } else {
                    ga.setReplacementFunction(new TestCaseReplacementFunction());
                }
                return ga;
            }
            case RANDOM: {
                logger.info("Chosen search algorithm: Random");
                return new RandomSearch<T>(factory);
            }
            case NSGAII: {
                logger.info("Chosen search algorithm: NSGAII");
                return new NSGAII<T>(factory);
            }
        }
        logger.info("Chosen search algorithm: StandardGA");
        return new StandardGA<T>(factory);
    }

    public GeneticAlgorithm<?> setup() {
        ChromosomeFactory<? extends Chromosome> factory = TestSuiteGenerator.getDefaultChromosomeFactory();
        GeneticAlgorithm<? extends Chromosome> ga = TestSuiteGenerator.getGeneticAlgorithm(factory);
        if (Properties.NEW_STATISTICS) {
            ga.addListener(new StatisticsListener());
        }
        SelectionFunction selection_function = TestSuiteGenerator.getSelectionFunction();
        selection_function.setMaximize(false);
        ga.setSelectionFunction(selection_function);
        stopping_condition = TestSuiteGenerator.getStoppingCondition();
        ga.setStoppingCondition(stopping_condition);
        if (Properties.STOP_ZERO) {
            ga.addStoppingCondition(zero_fitness);
        }
        if (!(stopping_condition instanceof MaxTimeStoppingCondition)) {
            ga.addStoppingCondition(global_time);
        }
        if (ArrayUtil.contains((Object[])Properties.CRITERION, (Object)Properties.Criterion.MUTATION) || ArrayUtil.contains((Object[])Properties.CRITERION, (Object)Properties.Criterion.STRONGMUTATION)) {
            if (Properties.STRATEGY == Properties.Strategy.ONEBRANCH) {
                ga.addStoppingCondition(new MutationTimeoutStoppingCondition());
            } else {
                ga.addListener(new MutationTestPool());
            }
        }
        ga.resetStoppingConditions();
        ga.setPopulationLimit(TestSuiteGenerator.getPopulationLimit());
        CrossOverFunction crossover_function = TestSuiteGenerator.getCrossoverFunction();
        ga.setCrossOverFunction(crossover_function);
        if (Properties.CHECK_BEST_LENGTH) {
            BloatControlFunction bloat_control;
            if (Properties.STRATEGY == Properties.Strategy.EVOSUITE) {
                bloat_control = new RelativeSuiteLengthBloatControl();
                ga.addBloatControl(bloat_control);
                ga.addListener((SearchListener)((Object)bloat_control));
            } else {
                bloat_control = new RelativeTestLengthBloatControl();
                ga.addBloatControl(bloat_control);
                ga.addListener((SearchListener)((Object)bloat_control));
            }
        }
        TestSuiteGenerator.getSecondaryObjectives(ga);
        if (Properties.DYNAMIC_LIMIT) {
            stopping_condition.setLimit(Properties.SEARCH_BUDGET *= (long)(BranchPool.getNumBranchlessMethods(Properties.TARGET_CLASS) + BranchPool.getBranchCountForClass(Properties.TARGET_CLASS) * 2));
            logger.info("Setting dynamic length limit to " + Properties.SEARCH_BUDGET);
        }
        if (Properties.LOCAL_SEARCH_RESTORE_COVERAGE) {
            ga.addListener(BranchCoverageMap.getInstance());
        }
        if (Properties.RECYCLE_CHROMOSOMES && Properties.STRATEGY == Properties.Strategy.ONEBRANCH) {
            ga.addListener(TestCaseRecycler.getInstance());
        }
        if (Properties.SHUTDOWN_HOOK) {
            ShutdownTestWriter writer = new ShutdownTestWriter();
            ga.addStoppingCondition(writer);
            ga.addStoppingCondition(RMIStoppingCondition.getInstance());
            if (Properties.STOPPING_PORT != -1) {
                SocketStoppingCondition ss = new SocketStoppingCondition();
                ss.accept();
                ga.addStoppingCondition(ss);
            }
            Signal.handle(new Signal("INT"), writer);
        }
        ga.addListener(new ResourceController());
        return ga;
    }

    public static void main(String[] args) {
        TestSuiteGenerator generator = new TestSuiteGenerator();
        generator.generateTestSuite();
        System.exit(0);
    }
}

