/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.evosuite.Properties;
import org.evosuite.rmi.service.ClientState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeController {
    private static final Logger logger = LoggerFactory.getLogger(TimeController.class);
    private static final TimeController singleton = new TimeController();
    private volatile ClientState state;
    private volatile long clientStartTime;
    private volatile long currentPhaseStartTime;
    private Map<ClientState, Long> phaseTimeouts;
    private Map<ClientState, Long> timeSpentInEachPhase;

    protected TimeController() {
        this.init();
    }

    private void init() {
        this.state = ClientState.NOT_STARTED;
        this.clientStartTime = 0L;
        this.initializePhaseTimeouts();
    }

    public static void resetSingleton() {
        TimeController.getInstance().init();
    }

    private void initializePhaseTimeouts() {
        if (this.phaseTimeouts != null) {
            this.phaseTimeouts.clear();
        } else {
            this.phaseTimeouts = new ConcurrentHashMap<ClientState, Long>();
        }
        Properties.getInstance();
        this.phaseTimeouts.put(ClientState.SEARCH, Long.valueOf(1000L) * (long)TimeController.getSearchBudgetInSeconds());
        this.phaseTimeouts.put(ClientState.MINIMIZATION, Long.valueOf(1000L) * (long)Properties.MINIMIZATION_TIMEOUT);
        this.phaseTimeouts.put(ClientState.ASSERTION_GENERATION, Long.valueOf(1000L) * (long)Properties.ASSERTION_TIMEOUT);
        this.phaseTimeouts.put(ClientState.CARVING, Long.valueOf(1000L) * (long)Properties.CARVING_TIMEOUT);
        this.phaseTimeouts.put(ClientState.INITIALIZATION, Long.valueOf(1000L) * (long)Properties.INITIALIZATION_TIMEOUT);
        if (this.timeSpentInEachPhase != null) {
            this.timeSpentInEachPhase.clear();
        } else {
            this.timeSpentInEachPhase = new ConcurrentHashMap<ClientState, Long>();
        }
    }

    public static TimeController getInstance() {
        return singleton;
    }

    public synchronized void updateState(ClientState newState) throws NullPointerException {
        if (this.state.equals((Object)newState)) {
            return;
        }
        if (!this.state.equals((Object)ClientState.NOT_STARTED)) {
            long elapsed = System.currentTimeMillis() - this.currentPhaseStartTime;
            if (this.timeSpentInEachPhase.containsKey((Object)this.state)) {
                logger.warn("Already entered in phase: " + (Object)((Object)this.state) + ". This will mess up the timing calculations.");
            }
            this.timeSpentInEachPhase.put(this.state, elapsed);
            logger.debug("Phase " + (Object)((Object)this.state) + " lasted " + elapsed / 1000L + " seconds");
        }
        this.state = newState;
        this.currentPhaseStartTime = System.currentTimeMillis();
        if (this.state.equals((Object)ClientState.STARTED)) {
            this.clientStartTime = this.currentPhaseStartTime;
        }
    }

    public static int getSearchBudgetInSeconds() {
        if (Properties.STOPPING_CONDITION == Properties.StoppingCondition.MAXTIME) {
            return (int)Properties.SEARCH_BUDGET;
        }
        return Properties.GLOBAL_TIMEOUT;
    }

    public int calculateForHowLongClientWillRunInSeconds() {
        int time = Properties.EXTRA_TIMEOUT;
        time += Properties.INITIALIZATION_TIMEOUT;
        time += TimeController.getSearchBudgetInSeconds();
        if (Properties.MINIMIZE) {
            time += Properties.MINIMIZATION_TIMEOUT;
        }
        if (Properties.ASSERTIONS) {
            time += Properties.ASSERTION_TIMEOUT;
        }
        if (Properties.TEST_FACTORY == Properties.TestFactory.JUNIT) {
            time += Properties.CARVING_TIMEOUT;
        }
        return time;
    }

    public synchronized boolean hasTimeToExecuteATestCase() {
        return this.isThereStillTimeInThisPhase(Properties.TIMEOUT);
    }

    public synchronized boolean isThereStillTimeInThisPhase() {
        return this.isThereStillTimeInThisPhase(1L);
    }

    protected boolean isThereStillTimeInThisPhase(long ms) {
        long timeSincePhaseStarted;
        long timeoutInMs;
        long phaseLeft;
        if (this.state.equals((Object)ClientState.NOT_STARTED)) {
            return true;
        }
        long timeSinceStart = System.currentTimeMillis() - this.clientStartTime;
        long totalTimeLimit = 1000 * this.calculateForHowLongClientWillRunInSeconds();
        long left = totalTimeLimit - timeSinceStart;
        if (ms > left) {
            return false;
        }
        return !this.currentPhaseHasTimeout() || ms <= (phaseLeft = (timeoutInMs = this.getCurrentPhaseTimeout()) - (timeSincePhaseStarted = System.currentTimeMillis() - this.currentPhaseStartTime));
    }

    private long getCurrentPhaseTimeout() {
        return this.phaseTimeouts.get((Object)this.state);
    }

    private boolean currentPhaseHasTimeout() {
        return this.phaseTimeouts.containsKey((Object)this.state);
    }
}

