/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.assertion;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.evosuite.assertion.ArrayEqualsAssertion;
import org.evosuite.assertion.Assertion;
import org.evosuite.assertion.OutputTraceEntry;
import org.evosuite.testcase.VariableReference;

public class ArrayTraceEntry
implements OutputTraceEntry {
    protected VariableReference var;
    protected Object[] value;

    public ArrayTraceEntry(VariableReference var, Object[] value) {
        this.var = var;
        this.value = value;
    }

    @Override
    public boolean differs(OutputTraceEntry other) {
        if (other instanceof ArrayTraceEntry) {
            ArrayTraceEntry otherEntry = (ArrayTraceEntry)other;
            if (!Arrays.equals(this.value, otherEntry.value)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public Set<Assertion> getAssertions(OutputTraceEntry other) {
        HashSet<Assertion> assertions = new HashSet<Assertion>();
        if (other instanceof ArrayTraceEntry) {
            ArrayTraceEntry otherEntry = (ArrayTraceEntry)other;
            if (!Arrays.equals(this.value, otherEntry.value)) {
                ArrayEqualsAssertion assertion = new ArrayEqualsAssertion();
                assertion.value = this.value;
                assertion.source = this.var;
                assertions.add(assertion);
                assert (assertion.isValid());
            }
        }
        return assertions;
    }

    @Override
    public Set<Assertion> getAssertions() {
        HashSet<Assertion> assertions = new HashSet<Assertion>();
        ArrayEqualsAssertion assertion = new ArrayEqualsAssertion();
        assertion.source = this.var;
        assertion.value = this.value;
        assertions.add(assertion);
        assert (assertion.isValid());
        return assertions;
    }

    @Override
    public boolean isDetectedBy(Assertion assertion) {
        if (assertion instanceof ArrayEqualsAssertion) {
            ArrayEqualsAssertion ass = (ArrayEqualsAssertion)assertion;
            if (this.var.equals(ass.source) && !Arrays.equals(this.value, (Object[])ass.value)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public OutputTraceEntry cloneEntry() {
        return new ArrayTraceEntry(this.var, Arrays.copyOf(this.value, this.value.length));
    }
}

