/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.assertion;

import java.lang.reflect.Array;
import org.evosuite.assertion.ArrayTraceEntry;
import org.evosuite.assertion.AssertionTraceObserver;
import org.evosuite.testcase.ArrayStatement;
import org.evosuite.testcase.AssignmentStatement;
import org.evosuite.testcase.CodeUnderTestException;
import org.evosuite.testcase.ExecutionResult;
import org.evosuite.testcase.PrimitiveStatement;
import org.evosuite.testcase.Scope;
import org.evosuite.testcase.StatementInterface;
import org.evosuite.testcase.VariableReference;

public class ArrayTraceObserver
extends AssertionTraceObserver<ArrayTraceEntry> {
    @Override
    public synchronized void afterStatement(StatementInterface statement, Scope scope, Throwable exception) {
        if (exception != null) {
            return;
        }
        this.visitReturnValue(statement, scope);
        this.visitDependencies(statement, scope);
    }

    private Object[] getArray(Object val) {
        int arrlength = Array.getLength(val);
        Object[] outputArray = new Object[arrlength];
        for (int i = 0; i < arrlength; ++i) {
            outputArray[i] = Array.get(val, i);
        }
        return outputArray;
    }

    @Override
    protected void visit(StatementInterface statement, Scope scope, VariableReference var) {
        logger.debug("Checking array " + var);
        try {
            if (var == null) {
                return;
            }
            if (statement instanceof PrimitiveStatement) {
                return;
            }
            if (statement instanceof AssignmentStatement) {
                return;
            }
            if (statement instanceof ArrayStatement) {
                return;
            }
            Object object = var.getObject(scope);
            if (object == null) {
                return;
            }
            if (!object.getClass().isArray()) {
                return;
            }
            if (!object.getClass().getComponentType().isPrimitive()) {
                return;
            }
            if (var.getComponentClass() == null) {
                return;
            }
            logger.debug("Observed value " + object + " for statement " + statement.getCode());
            this.trace.addEntry(statement.getPosition(), var, new ArrayTraceEntry(var, this.getArray(object)));
        }
        catch (CodeUnderTestException e) {
            logger.debug("", e);
        }
    }

    @Override
    public void testExecutionFinished(ExecutionResult r) {
    }
}

