/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.assertion;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.evosuite.assertion.ArrayTraceEntry;
import org.evosuite.assertion.ArrayTraceObserver;
import org.evosuite.assertion.Assertion;
import org.evosuite.assertion.ComparisonTraceEntry;
import org.evosuite.assertion.ComparisonTraceObserver;
import org.evosuite.assertion.InspectorTraceEntry;
import org.evosuite.assertion.InspectorTraceObserver;
import org.evosuite.assertion.NullTraceEntry;
import org.evosuite.assertion.NullTraceObserver;
import org.evosuite.assertion.OutputTrace;
import org.evosuite.assertion.PrimitiveFieldTraceEntry;
import org.evosuite.assertion.PrimitiveFieldTraceObserver;
import org.evosuite.assertion.PrimitiveTraceEntry;
import org.evosuite.assertion.PrimitiveTraceObserver;
import org.evosuite.assertion.SameTraceEntry;
import org.evosuite.assertion.SameTraceObserver;
import org.evosuite.ga.stoppingconditions.MaxStatementsStoppingCondition;
import org.evosuite.testcase.ExecutionResult;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.TestCaseExecutor;
import org.evosuite.testcase.TestChromosome;
import org.evosuite.testsuite.TestSuiteChromosome;
import org.evosuite.utils.Randomness;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AssertionGenerator {
    protected static final Logger logger = LoggerFactory.getLogger(AssertionGenerator.class);
    protected static final PrimitiveTraceObserver primitiveObserver = new PrimitiveTraceObserver();
    protected static final ComparisonTraceObserver comparisonObserver = new ComparisonTraceObserver();
    protected static final SameTraceObserver sameObserver = new SameTraceObserver();
    protected static final InspectorTraceObserver inspectorObserver = new InspectorTraceObserver();
    protected static final PrimitiveFieldTraceObserver fieldObserver = new PrimitiveFieldTraceObserver();
    protected static final NullTraceObserver nullObserver = new NullTraceObserver();
    protected static final ArrayTraceObserver arrayObserver = new ArrayTraceObserver();

    public AssertionGenerator() {
        TestCaseExecutor.getInstance().addObserver(primitiveObserver);
        TestCaseExecutor.getInstance().addObserver(comparisonObserver);
        TestCaseExecutor.getInstance().addObserver(inspectorObserver);
        TestCaseExecutor.getInstance().addObserver(fieldObserver);
        TestCaseExecutor.getInstance().addObserver(nullObserver);
        TestCaseExecutor.getInstance().addObserver(sameObserver);
        TestCaseExecutor.getInstance().addObserver(arrayObserver);
    }

    public abstract void addAssertions(TestCase var1);

    public void addAssertions(TestSuiteChromosome suite) {
        for (TestChromosome test : suite.getTestChromosomes()) {
            this.addAssertions(test.getTestCase());
        }
    }

    protected ExecutionResult runTest(TestCase test) {
        ExecutionResult result = new ExecutionResult(test);
        try {
            logger.debug("Executing test");
            result = TestCaseExecutor.getInstance().execute(test);
            int num = test.size();
            MaxStatementsStoppingCondition.statementsExecuted(num);
            result.setTrace(comparisonObserver.getTrace(), ComparisonTraceEntry.class);
            result.setTrace(primitiveObserver.getTrace(), PrimitiveTraceEntry.class);
            result.setTrace(inspectorObserver.getTrace(), InspectorTraceEntry.class);
            result.setTrace(fieldObserver.getTrace(), PrimitiveFieldTraceEntry.class);
            result.setTrace(nullObserver.getTrace(), NullTraceEntry.class);
            result.setTrace(sameObserver.getTrace(), SameTraceEntry.class);
            result.setTrace(arrayObserver.getTrace(), ArrayTraceEntry.class);
        }
        catch (Exception e) {
            throw new Error(e);
        }
        return result;
    }

    protected void filterFailingAssertions(TestCase test) {
        ExecutionResult result = this.runTest(test);
        HashSet<Assertion> invalidAssertions = new HashSet<Assertion>();
        block0: for (Assertion assertion : test.getAssertions()) {
            for (OutputTrace<?> outputTrace : result.getTraces()) {
                if (!outputTrace.isDetectedBy(assertion)) continue;
                invalidAssertions.add(assertion);
                continue block0;
            }
        }
        logger.info("Removing {} nondeterministic assertions", (Object)invalidAssertions.size());
        for (Assertion assertion : invalidAssertions) {
            test.removeAssertion(assertion);
        }
    }

    public void filterFailingAssertions(List<TestCase> testCases) {
        ArrayList<TestCase> tests = new ArrayList<TestCase>();
        tests.addAll(testCases);
        for (TestCase test : tests) {
            this.filterFailingAssertions(test);
        }
        Randomness.shuffle(tests);
        for (TestCase test : tests) {
            this.filterFailingAssertions(test);
        }
    }

    public void filterFailingAssertions(TestSuiteChromosome testSuite) {
        List tests = testSuite.getTestChromosomes();
        for (TestChromosome test : tests) {
            this.filterFailingAssertions(test.getTestCase());
        }
        Randomness.shuffle(tests);
        for (TestChromosome test : tests) {
            this.filterFailingAssertions(test.getTestCase());
        }
    }
}

