/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.assertion;

import org.evosuite.assertion.OutputTrace;
import org.evosuite.assertion.OutputTraceEntry;
import org.evosuite.testcase.CodeUnderTestException;
import org.evosuite.testcase.ExecutionObserver;
import org.evosuite.testcase.ExecutionTracer;
import org.evosuite.testcase.Scope;
import org.evosuite.testcase.StatementInterface;
import org.evosuite.testcase.VariableReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AssertionTraceObserver<T extends OutputTraceEntry>
extends ExecutionObserver {
    protected static final Logger logger = LoggerFactory.getLogger(AssertionTraceObserver.class);
    protected OutputTrace<T> trace = new OutputTrace();

    protected boolean checkThread() {
        return ExecutionTracer.isThreadNeqCurrentThread();
    }

    @Override
    public synchronized void output(int position, String output) {
    }

    protected void visitDependencies(StatementInterface statement, Scope scope) {
        for (VariableReference var : currentTest.getDependencies(statement.getReturnValue())) {
            if (var.isVoid()) continue;
            try {
                this.visit(statement, scope, var);
            }
            catch (CodeUnderTestException e) {}
        }
    }

    protected void visitReturnValue(StatementInterface statement, Scope scope) {
        if (!statement.getReturnClass().equals(Void.TYPE)) {
            try {
                this.visit(statement, scope, statement.getReturnValue());
            }
            catch (CodeUnderTestException codeUnderTestException) {
                // empty catch block
            }
        }
    }

    protected abstract void visit(StatementInterface var1, Scope var2, VariableReference var3) throws CodeUnderTestException;

    @Override
    public synchronized void afterStatement(StatementInterface statement, Scope scope, Throwable exception) {
        if (exception != null) {
            return;
        }
        this.visitDependencies(statement, scope);
    }

    @Override
    public synchronized void beforeStatement(StatementInterface statement, Scope scope) {
    }

    @Override
    public synchronized void clear() {
        this.trace.clear();
    }

    public synchronized OutputTrace<T> getTrace() {
        return this.trace.clone();
    }
}

