/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.assertion;

import org.evosuite.Properties;
import org.evosuite.assertion.AssertionTraceObserver;
import org.evosuite.assertion.CheapPurityAnalyzer;
import org.evosuite.assertion.ComparisonTraceEntry;
import org.evosuite.testcase.AssignmentStatement;
import org.evosuite.testcase.CodeUnderTestException;
import org.evosuite.testcase.ExecutionResult;
import org.evosuite.testcase.PrimitiveStatement;
import org.evosuite.testcase.Scope;
import org.evosuite.testcase.StatementInterface;
import org.evosuite.testcase.VariableReference;
import org.objectweb.asm.Type;

public class ComparisonTraceObserver
extends AssertionTraceObserver<ComparisonTraceEntry> {
    @Override
    protected void visit(StatementInterface statement, Scope scope, VariableReference var) {
        try {
            Object object = var.getObject(scope);
            if (object == null) {
                return;
            }
            ComparisonTraceEntry entry = new ComparisonTraceEntry(var);
            for (VariableReference other : scope.getElements(var.getType())) {
                Object otherObject = other.getObject(scope);
                if (otherObject == null || object == otherObject || statement instanceof PrimitiveStatement && currentTest.getStatement(other.getStPosition()) instanceof PrimitiveStatement || statement instanceof AssignmentStatement) continue;
                if (Properties.PURE_EQUALS) {
                    String className = object.getClass().getCanonicalName();
                    String methodName = "equals";
                    String descriptor = Type.getMethodDescriptor(Type.BOOLEAN_TYPE, Type.getType(Object.class));
                    CheapPurityAnalyzer cheapPurityAnalyzer = CheapPurityAnalyzer.getInstance();
                    if (!cheapPurityAnalyzer.isPure(className, methodName, descriptor)) continue;
                }
                try {
                    logger.debug("Comparison of " + var + " with " + other + " is: " + object.equals(otherObject));
                    entry.addEntry(other, object.equals(otherObject));
                }
                catch (Throwable t) {
                    logger.debug("Exception during equals: " + t);
                }
                if (!(object instanceof Comparable)) continue;
            }
            this.trace.addEntry(statement.getPosition(), var, entry);
        }
        catch (CodeUnderTestException e) {
            logger.debug("", e);
        }
    }

    @Override
    public void testExecutionFinished(ExecutionResult r) {
    }
}

