/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.assertion;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.evosuite.TestGenerationContext;
import org.evosuite.setup.TestClusterGenerator;
import org.evosuite.utils.LoggingUtils;
import org.objectweb.asm.Type;

public class Inspector
implements Serializable {
    private static final long serialVersionUID = -6865880297202184953L;
    private transient Class<?> clazz;
    private transient Method method;

    public Inspector(Class<?> clazz, Method m) {
        this.clazz = clazz;
        this.method = m;
    }

    public Object getValue(Object object) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Object ret = this.method.invoke(object, new Object[0]);
        return ret;
    }

    public Method getMethod() {
        return this.method;
    }

    public String getMethodCall() {
        return this.method.getName();
    }

    public String getClassName() {
        return this.clazz.getName();
    }

    public Class<?> getReturnType() {
        return this.method.getReturnType();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.clazz == null ? 0 : this.clazz.hashCode());
        result = 31 * result + (this.method == null ? 0 : this.method.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Inspector other = (Inspector)obj;
        if (this.clazz == null ? other.clazz != null : !this.clazz.equals(other.clazz)) {
            return false;
        }
        return !(this.method == null ? other.method != null : !this.method.equals(other.method));
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
        oos.writeObject(this.clazz.getName());
        oos.writeObject(this.method.getDeclaringClass().getName());
        oos.writeObject(this.method.getName());
        oos.writeObject(Type.getMethodDescriptor(this.method));
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        this.clazz = TestGenerationContext.getInstance().getClassLoaderForSUT().loadClass((String)ois.readObject());
        Class<?> methodClass = TestGenerationContext.getInstance().getClassLoaderForSUT().loadClass((String)ois.readObject());
        String methodName = (String)ois.readObject();
        String methodDesc = (String)ois.readObject();
        for (Method method : methodClass.getDeclaredMethods()) {
            if (!method.getName().equals(methodName) || !Type.getMethodDescriptor(method).equals(methodDesc)) continue;
            this.method = method;
            return;
        }
    }

    public void changeClassLoader(ClassLoader loader) {
        try {
            Class<?> oldClass = this.method.getDeclaringClass();
            Class<?> newClass = loader.loadClass(oldClass.getName());
            for (Method newMethod : TestClusterGenerator.getMethods(newClass)) {
                Class<?>[] newParameters;
                if (!newMethod.getName().equals(this.method.getName())) continue;
                boolean equals = true;
                Class<?>[] oldParameters = this.method.getParameterTypes();
                if (oldParameters.length != (newParameters = newMethod.getParameterTypes()).length || !newMethod.getDeclaringClass().getName().equals(this.method.getDeclaringClass().getName()) || !newMethod.getReturnType().getName().equals(this.method.getReturnType().getName())) continue;
                for (int i = 0; i < newParameters.length; ++i) {
                    if (oldParameters[i].getName().equals(newParameters[i].getName())) continue;
                    equals = false;
                    break;
                }
                if (!equals) continue;
                this.method = newMethod;
                this.method.setAccessible(true);
                return;
            }
            LoggingUtils.getEvoLogger().info("Method not found - keeping old class loader ");
        }
        catch (ClassNotFoundException e) {
            LoggingUtils.getEvoLogger().info("Class not found - keeping old class loader ", e);
        }
        catch (SecurityException e) {
            LoggingUtils.getEvoLogger().info("Class not found - keeping old class loader ", e);
        }
    }
}

