/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.assertion;

import org.evosuite.assertion.Assertion;
import org.evosuite.assertion.Inspector;
import org.evosuite.testcase.CodeUnderTestException;
import org.evosuite.testcase.Scope;
import org.evosuite.testcase.StatementInterface;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.VariableReference;
import org.evosuite.utils.NumberFormatter;

public class InspectorAssertion
extends Assertion {
    private static final long serialVersionUID = -4080051661226820222L;
    protected Inspector inspector;

    public InspectorAssertion() {
    }

    public InspectorAssertion(Inspector inspector, StatementInterface statement, VariableReference source, Object value) {
        this.inspector = inspector;
        this.source = source;
        this.statement = statement;
        this.value = value;
    }

    public Inspector getInspector() {
        return this.inspector;
    }

    @Override
    public Assertion copy(TestCase newTestCase, int offset) {
        InspectorAssertion s = new InspectorAssertion();
        s.source = newTestCase.getStatement(this.source.getStPosition() + offset).getReturnValue();
        s.inspector = this.inspector;
        s.value = this.value;
        s.killedMutants.addAll(this.killedMutants);
        return s;
    }

    @Override
    public String getCode() {
        if (this.value == null) {
            return "assertNull(" + this.source.getName() + "." + this.inspector.getMethodCall() + "());";
        }
        if (this.value.getClass().equals(Long.class)) {
            return "assertEquals(" + NumberFormatter.getNumberString(this.value) + ", " + this.source.getName() + "." + this.inspector.getMethodCall() + "());";
        }
        if (this.value.getClass().equals(Float.class)) {
            return "assertEquals(" + NumberFormatter.getNumberString(this.value) + ", " + this.source.getName() + "." + this.inspector.getMethodCall() + "(), 0.01F);";
        }
        if (this.value.getClass().equals(Double.class)) {
            return "assertEquals(" + NumberFormatter.getNumberString(this.value) + ", " + this.source.getName() + "." + this.inspector.getMethodCall() + "(), 0.01D);";
        }
        if (this.value.getClass().equals(Character.class)) {
            return "assertEquals(" + NumberFormatter.getNumberString(this.value) + ", " + this.source.getName() + "." + this.inspector.getMethodCall() + "());";
        }
        if (this.value.getClass().equals(String.class)) {
            return "assertEquals(" + NumberFormatter.getNumberString(this.value) + ", " + this.source.getName() + "." + this.inspector.getMethodCall() + "());";
        }
        if (this.value.getClass().isEnum()) {
            return "assertEquals(" + NumberFormatter.getNumberString(this.value) + ", " + this.source.getName() + "." + this.inspector.getMethodCall() + "());";
        }
        return "assertEquals(" + this.value + ", " + this.source.getName() + "." + this.inspector.getMethodCall() + "());";
    }

    @Override
    public boolean evaluate(Scope scope) {
        try {
            if (this.source.getObject(scope) == null) {
                return true;
            }
            try {
                Object val = this.inspector.getValue(this.source.getObject(scope));
                if (val == null) {
                    return this.value == null;
                }
                return val.equals(this.value);
            }
            catch (Exception e) {
                logger.error("* Exception during call to inspector", e);
                return true;
            }
        }
        catch (CodeUnderTestException e) {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.inspector == null ? 0 : this.inspector.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InspectorAssertion other = (InspectorAssertion)obj;
        return !(this.inspector == null ? other.inspector != null : !this.inspector.equals(other.inspector));
    }

    @Override
    public boolean isValid() {
        return this.source != null;
    }

    @Override
    public void changeClassLoader(ClassLoader loader) {
        this.inspector.changeClassLoader(loader);
    }
}

