/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.assertion;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.evosuite.assertion.Assertion;
import org.evosuite.assertion.Inspector;
import org.evosuite.assertion.InspectorAssertion;
import org.evosuite.assertion.OutputTraceEntry;
import org.evosuite.testcase.VariableReference;

public class InspectorTraceEntry
implements OutputTraceEntry {
    private final Map<Inspector, Object> inspectorMap = new HashMap<Inspector, Object>();
    private final VariableReference var;

    public InspectorTraceEntry(VariableReference var) {
        this.var = var;
    }

    public void addValue(Inspector inspector, Object value) {
        this.inspectorMap.put(inspector, value);
    }

    public int size() {
        return this.inspectorMap.size();
    }

    @Override
    public boolean differs(OutputTraceEntry other) {
        if (other instanceof InspectorTraceEntry) {
            if (!((InspectorTraceEntry)other).var.equals(this.var)) {
                return false;
            }
            InspectorTraceEntry otherEntry = (InspectorTraceEntry)other;
            for (Inspector inspector : this.inspectorMap.keySet()) {
                if (!otherEntry.inspectorMap.containsKey(inspector) || otherEntry.inspectorMap.get(inspector) == null || this.inspectorMap.get(inspector) == null || otherEntry.inspectorMap.get(inspector).equals(this.inspectorMap.get(inspector))) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Set<Assertion> getAssertions(OutputTraceEntry other) {
        HashSet<Assertion> assertions = new HashSet<Assertion>();
        if (other instanceof InspectorTraceEntry) {
            InspectorTraceEntry otherEntry = (InspectorTraceEntry)other;
            for (Inspector inspector : this.inspectorMap.keySet()) {
                if (!otherEntry.inspectorMap.containsKey(inspector) || otherEntry.inspectorMap.get(inspector) == null || this.inspectorMap.get(inspector) == null || otherEntry.inspectorMap.get(inspector).equals(this.inspectorMap.get(inspector))) continue;
                InspectorAssertion assertion = new InspectorAssertion();
                assertion.value = this.inspectorMap.get(inspector);
                assertion.inspector = inspector;
                assertion.source = this.var;
                assertions.add(assertion);
                assert (assertion.isValid());
            }
        }
        return assertions;
    }

    @Override
    public Set<Assertion> getAssertions() {
        HashSet<Assertion> assertions = new HashSet<Assertion>();
        for (Inspector inspector : this.inspectorMap.keySet()) {
            InspectorAssertion assertion = new InspectorAssertion();
            assertion.value = this.inspectorMap.get(inspector);
            assertion.inspector = inspector;
            assertion.source = this.var;
            assertions.add(assertion);
            assert (assertion.isValid());
        }
        return assertions;
    }

    @Override
    public boolean isDetectedBy(Assertion assertion) {
        if (assertion instanceof InspectorAssertion) {
            InspectorAssertion ass = (InspectorAssertion)assertion;
            if (ass.source.equals(this.var) && this.inspectorMap.containsKey(ass.inspector) && this.inspectorMap.get(ass.inspector) != null && ass.value != null) {
                return !this.inspectorMap.get(ass.inspector).equals(ass.value);
            }
        }
        return false;
    }

    @Override
    public OutputTraceEntry cloneEntry() {
        InspectorTraceEntry copy = new InspectorTraceEntry(this.var);
        copy.inspectorMap.putAll(this.inspectorMap);
        return copy;
    }
}

