/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.assertion;

import java.text.NumberFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.evosuite.Properties;
import org.evosuite.TestGenerationContext;
import org.evosuite.assertion.ArrayTraceEntry;
import org.evosuite.assertion.ArrayTraceObserver;
import org.evosuite.assertion.Assertion;
import org.evosuite.assertion.AssertionGenerator;
import org.evosuite.assertion.ComparisonTraceEntry;
import org.evosuite.assertion.ComparisonTraceObserver;
import org.evosuite.assertion.InspectorAssertion;
import org.evosuite.assertion.InspectorTraceEntry;
import org.evosuite.assertion.InspectorTraceObserver;
import org.evosuite.assertion.NullAssertion;
import org.evosuite.assertion.NullTraceEntry;
import org.evosuite.assertion.NullTraceObserver;
import org.evosuite.assertion.OutputTrace;
import org.evosuite.assertion.PrimitiveAssertion;
import org.evosuite.assertion.PrimitiveFieldTraceEntry;
import org.evosuite.assertion.PrimitiveFieldTraceObserver;
import org.evosuite.assertion.PrimitiveTraceEntry;
import org.evosuite.assertion.PrimitiveTraceObserver;
import org.evosuite.assertion.SameTraceEntry;
import org.evosuite.assertion.SameTraceObserver;
import org.evosuite.coverage.mutation.Mutation;
import org.evosuite.coverage.mutation.MutationObserver;
import org.evosuite.coverage.mutation.MutationPool;
import org.evosuite.ga.stoppingconditions.MaxStatementsStoppingCondition;
import org.evosuite.rmi.ClientServices;
import org.evosuite.runtime.reset.ResetManager;
import org.evosuite.runtime.sandbox.Sandbox;
import org.evosuite.statistics.RuntimeVariable;
import org.evosuite.testcase.ConstructorStatement;
import org.evosuite.testcase.DefaultTestCase;
import org.evosuite.testcase.ExecutionResult;
import org.evosuite.testcase.FieldStatement;
import org.evosuite.testcase.MethodStatement;
import org.evosuite.testcase.StatementInterface;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.TestCaseExecutor;
import org.evosuite.testcase.TestChromosome;
import org.evosuite.testcase.VariableReference;
import org.evosuite.testsuite.TestSuiteChromosome;
import org.evosuite.utils.ArrayUtil;
import org.evosuite.utils.LoggingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MutationAssertionGenerator
extends AssertionGenerator {
    protected final Map<Integer, Mutation> mutants = new HashMap<Integer, Mutation>();
    protected static final Logger logger = LoggerFactory.getLogger(MutationAssertionGenerator.class);
    protected static final PrimitiveTraceObserver primitiveObserver = new PrimitiveTraceObserver();
    protected static final ComparisonTraceObserver comparisonObserver = new ComparisonTraceObserver();
    protected static final SameTraceObserver sameObserver = new SameTraceObserver();
    protected static final InspectorTraceObserver inspectorObserver = new InspectorTraceObserver();
    protected static final PrimitiveFieldTraceObserver fieldObserver = new PrimitiveFieldTraceObserver();
    protected static final NullTraceObserver nullObserver = new NullTraceObserver();
    protected static final ArrayTraceObserver arrayObserver = new ArrayTraceObserver();
    protected static final Map<Mutation, Integer> timedOutMutations = new HashMap<Mutation, Integer>();
    protected static final Map<Mutation, Integer> exceptionMutations = new HashMap<Mutation, Integer>();
    protected static Class<?>[] observerClasses = new Class[]{PrimitiveTraceEntry.class, ComparisonTraceEntry.class, SameTraceEntry.class, InspectorTraceEntry.class, PrimitiveFieldTraceEntry.class, NullTraceEntry.class, ArrayTraceEntry.class};
    protected Properties.Criterion[] oldCriterion = Properties.CRITERION;

    public MutationAssertionGenerator() {
        for (Mutation m : MutationPool.getMutants()) {
            this.mutants.put(m.getId(), m);
        }
        TestCaseExecutor.getInstance().newObservers();
        TestCaseExecutor.getInstance().addObserver(primitiveObserver);
        TestCaseExecutor.getInstance().addObserver(comparisonObserver);
        TestCaseExecutor.getInstance().addObserver(sameObserver);
        TestCaseExecutor.getInstance().addObserver(inspectorObserver);
        TestCaseExecutor.getInstance().addObserver(fieldObserver);
        TestCaseExecutor.getInstance().addObserver(nullObserver);
        TestCaseExecutor.getInstance().addObserver(arrayObserver);
    }

    @Override
    protected ExecutionResult runTest(TestCase test) {
        return this.runTest(test, null);
    }

    protected ExecutionResult runTest(TestCase test, Mutation mutant) {
        ExecutionResult result = new ExecutionResult(test, mutant);
        comparisonObserver.clear();
        sameObserver.clear();
        primitiveObserver.clear();
        inspectorObserver.clear();
        fieldObserver.clear();
        nullObserver.clear();
        arrayObserver.clear();
        try {
            logger.debug("Executing test");
            if (mutant == null) {
                MutationObserver.deactivateMutation();
            } else {
                MutationObserver.activateMutation(mutant);
            }
            result = TestCaseExecutor.getInstance().execute(test);
            MutationObserver.deactivateMutation(mutant);
            int num = test.size();
            MaxStatementsStoppingCondition.statementsExecuted(num);
            result.setTrace(comparisonObserver.getTrace(), ComparisonTraceEntry.class);
            result.setTrace(sameObserver.getTrace(), SameTraceEntry.class);
            result.setTrace(primitiveObserver.getTrace(), PrimitiveTraceEntry.class);
            result.setTrace(inspectorObserver.getTrace(), InspectorTraceEntry.class);
            result.setTrace(fieldObserver.getTrace(), PrimitiveFieldTraceEntry.class);
            result.setTrace(nullObserver.getTrace(), NullTraceEntry.class);
            result.setTrace(arrayObserver.getTrace(), ArrayTraceEntry.class);
        }
        catch (Exception e) {
            throw new Error(e);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setupClassLoader(TestSuiteChromosome suite) {
        this.oldCriterion = Arrays.copyOf(Properties.CRITERION, Properties.CRITERION.length);
        if (!(ArrayUtil.contains((Object[])this.oldCriterion, (Object)Properties.Criterion.MUTATION) || ArrayUtil.contains((Object[])this.oldCriterion, (Object)Properties.Criterion.WEAKMUTATION) || ArrayUtil.contains((Object[])this.oldCriterion, (Object)Properties.Criterion.ONLYMUTATION) || ArrayUtil.contains((Object[])this.oldCriterion, (Object)Properties.Criterion.STRONGMUTATION))) {
            Properties.CRITERION = new Properties.Criterion[]{Properties.Criterion.MUTATION};
            Sandbox.goingToExecuteSUTCode();
            TestGenerationContext.getInstance().goingToExecuteSUTCode();
            Sandbox.goingToExecuteUnsafeCodeOnSameThread();
            try {
                TestGenerationContext.getInstance().resetContext();
                if (Properties.RESET_STATIC_FIELDS) {
                    ResetManager.getInstance().disableTracing();
                    ResetManager.getInstance().setResetAllClasses(true);
                    ResetManager.getInstance().setResetFinalFields(true);
                }
                TestGenerationContext.getInstance().goingToExecuteSUTCode();
                Properties.getTargetClass();
                ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.Mutants, MutationPool.getMutantCounter());
                for (TestChromosome test : suite.getTestChromosomes()) {
                    DefaultTestCase dtest = (DefaultTestCase)test.getTestCase();
                    dtest.changeClassLoader(TestGenerationContext.getInstance().getClassLoaderForSUT());
                    test.setChanged(true);
                    test.clearCachedMutationResults();
                    test.clearCachedResults();
                }
            }
            catch (Throwable e) {
                LoggingUtils.getEvoLogger().error("* Error while initializing target class: " + (e.getMessage() != null ? e.getMessage() : e.toString()));
                logger.error("Problem for " + Properties.TARGET_CLASS + ". Full stack:", e);
            }
            finally {
                TestGenerationContext.getInstance().doneWithExecuteingSUTCode();
                Sandbox.doneWithExecutingUnsafeCodeOnSameThread();
                Sandbox.doneWithExecutingSUTCode();
                TestGenerationContext.getInstance().doneWithExecuteingSUTCode();
            }
            for (Mutation m : MutationPool.getMutants()) {
                this.mutants.put(m.getId(), m);
            }
        }
    }

    protected void restoreCriterion(TestSuiteChromosome suite) {
        Properties.CRITERION = this.oldCriterion;
    }

    protected void calculateMutationScore(Set<Integer> tkilled) {
        if (MutationPool.getMutantCounter() == 0) {
            Properties.CRITERION = this.oldCriterion;
            LoggingUtils.getEvoLogger().info("* Resulting test suite's mutation score: " + NumberFormat.getPercentInstance().format(1.0));
            ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.MutationScore, 1.0);
        } else {
            double score = (double)tkilled.size() / (double)MutationPool.getMutantCounter();
            ClientServices.getInstance().getClientNode().trackOutputVariable(RuntimeVariable.MutationScore, score);
            LoggingUtils.getEvoLogger().info("* Resulting test suite's mutation score: " + NumberFormat.getPercentInstance().format(score));
        }
    }

    protected int getNumKilledMutants(TestCase test, Map<Mutation, List<OutputTrace<?>>> mutation_traces, List<Mutation> executedMutants) {
        HashSet<Integer> killed = new HashSet<Integer>();
        List<Assertion> assertions = test.getAssertions();
        for (Assertion assertion : assertions) {
            block1: for (Mutation m : executedMutants) {
                boolean isKilled = false;
                if (mutation_traces.containsKey(m)) {
                    int i = 0;
                    for (OutputTrace<?> trace : mutation_traces.get(m)) {
                        isKilled = trace.isDetectedBy(assertion);
                        if (isKilled) {
                            logger.debug("Mutation killed: " + m.getId() + " by trace " + i++);
                            killed.add(m.getId());
                            continue block1;
                        }
                        ++i;
                    }
                    continue;
                }
                isKilled = true;
            }
        }
        logger.debug("Killed mutants: " + killed);
        return killed.size();
    }

    protected boolean justNullAssertion(StatementInterface statement) {
        Set<Assertion> assertions = statement.getAssertions();
        if (assertions.isEmpty()) {
            return false;
        }
        Iterator<Assertion> iterator = assertions.iterator();
        VariableReference ret = statement.getReturnValue();
        VariableReference callee = null;
        if (statement instanceof MethodStatement) {
            callee = ((MethodStatement)statement).getCallee();
        }
        boolean just = true;
        while (iterator.hasNext()) {
            Assertion ass = iterator.next();
            if (ass instanceof NullAssertion || !ass.getReferencedVariables().contains(ret) && !ass.getReferencedVariables().contains(callee)) continue;
            just = false;
            break;
        }
        return just;
    }

    protected boolean primitiveWithoutAssertion(StatementInterface statement) {
        if (!statement.getReturnValue().isPrimitive()) {
            return false;
        }
        Set<Assertion> assertions = statement.getAssertions();
        if (assertions.isEmpty()) {
            return true;
        }
        Iterator<Assertion> iterator = assertions.iterator();
        VariableReference ret = statement.getReturnValue();
        while (iterator.hasNext()) {
            Assertion ass = iterator.next();
            if (!(ass instanceof PrimitiveAssertion) || !ass.getReferencedVariables().contains(ret)) continue;
            return false;
        }
        return true;
    }

    protected boolean isUsedAsCallee(TestCase test, VariableReference var) {
        for (int pos = var.getStPosition() + 1; pos < test.size(); ++pos) {
            StatementInterface statement = test.getStatement(pos);
            if (!(statement instanceof MethodStatement ? ((MethodStatement)statement).getCallee() == var : statement instanceof FieldStatement && ((FieldStatement)statement).getSource() == var)) continue;
            return true;
        }
        return false;
    }

    protected void filterRedundantNonnullAssertions(TestCase test) {
        HashSet<Assertion> redundantAssertions = new HashSet<Assertion>();
        for (StatementInterface statement : test) {
            if (!(statement instanceof ConstructorStatement)) continue;
            ConstructorStatement cs = (ConstructorStatement)statement;
            for (Assertion a : cs.getAssertions()) {
                if (!(a instanceof NullAssertion)) continue;
                if (cs.getAssertions().size() > 0) {
                    for (Assertion a2 : cs.getAssertions()) {
                        if (a2.getSource() != cs.getReturnValue()) continue;
                        redundantAssertions.add(a);
                    }
                    continue;
                }
                if (!this.isUsedAsCallee(test, cs.getReturnValue())) continue;
                redundantAssertions.add(a);
            }
        }
        for (Assertion a : redundantAssertions) {
            test.removeAssertion(a);
        }
    }

    protected void filterInspectorPrimitiveDuplication(StatementInterface statement) {
        HashSet<Assertion> assertions = new HashSet<Assertion>(statement.getAssertions());
        if (assertions.size() < 2) {
            return;
        }
        if (!(statement instanceof MethodStatement)) {
            return;
        }
        MethodStatement methodStatement = (MethodStatement)statement;
        boolean hasPrimitive = false;
        for (Assertion assertion : assertions) {
            if (!(assertion instanceof PrimitiveAssertion) || !assertion.getStatement().equals(statement)) continue;
            hasPrimitive = true;
        }
        if (hasPrimitive) {
            for (Assertion assertion : assertions) {
                InspectorAssertion ia;
                if (!(assertion instanceof InspectorAssertion) || !(ia = (InspectorAssertion)assertion).getInspector().getMethod().equals(methodStatement.getMethod().getMethod())) continue;
                statement.removeAssertion(assertion);
                return;
            }
        }
    }

    @Override
    public void addAssertions(TestCase test) {
    }
}

