/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.assertion;

import org.evosuite.assertion.Assertion;
import org.evosuite.testcase.CodeUnderTestException;
import org.evosuite.testcase.Scope;
import org.evosuite.testcase.TestCase;

public class NullAssertion
extends Assertion {
    private static final long serialVersionUID = 8486987896764253928L;

    @Override
    public Assertion copy(TestCase newTestCase, int offset) {
        NullAssertion s = new NullAssertion();
        s.source = newTestCase.getStatement(this.source.getStPosition() + offset).getReturnValue();
        s.value = this.value;
        s.killedMutants.addAll(this.killedMutants);
        assert (s.isValid());
        return s;
    }

    @Override
    public boolean evaluate(Scope scope) {
        try {
            if (((Boolean)this.value).booleanValue()) {
                return this.source.getObject(scope) == null;
            }
            return this.source.getObject(scope) != null;
        }
        catch (CodeUnderTestException e) {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public String getCode() {
        if (((Boolean)this.value).booleanValue()) {
            return "assertNull(" + this.source.getName() + ");";
        }
        return "assertNotNull(" + this.source.getName() + ");";
    }
}

