/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.assertion;

import org.evosuite.assertion.AssertionTraceObserver;
import org.evosuite.assertion.NullTraceEntry;
import org.evosuite.testcase.CodeUnderTestException;
import org.evosuite.testcase.ExecutionResult;
import org.evosuite.testcase.PrimitiveStatement;
import org.evosuite.testcase.Scope;
import org.evosuite.testcase.StatementInterface;
import org.evosuite.testcase.VariableReference;

public class NullTraceObserver
extends AssertionTraceObserver<NullTraceEntry> {
    @Override
    public synchronized void afterStatement(StatementInterface statement, Scope scope, Throwable exception) {
        if (exception != null) {
            return;
        }
        this.visitReturnValue(statement, scope);
    }

    @Override
    protected void visit(StatementInterface statement, Scope scope, VariableReference var) {
        logger.debug("Checking for null of " + var);
        try {
            if (var == null || var.isPrimitive() || var.isWrapperType() || var.isEnum() || currentTest.getStatement(var.getStPosition()) instanceof PrimitiveStatement) {
                return;
            }
            Object object = var.getObject(scope);
            this.trace.addEntry(statement.getPosition(), var, new NullTraceEntry(var, object == null));
        }
        catch (CodeUnderTestException e) {
            logger.debug("", e);
        }
    }

    @Override
    public void testExecutionFinished(ExecutionResult r) {
    }
}

