/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.assertion;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.evosuite.assertion.AssertionTraceObserver;
import org.evosuite.assertion.PrimitiveFieldTraceEntry;
import org.evosuite.testcase.CodeUnderTestException;
import org.evosuite.testcase.ExecutionResult;
import org.evosuite.testcase.Scope;
import org.evosuite.testcase.StatementInterface;
import org.evosuite.testcase.VariableReference;

public class PrimitiveFieldTraceObserver
extends AssertionTraceObserver<PrimitiveFieldTraceEntry> {
    @Override
    protected void visit(StatementInterface statement, Scope scope, VariableReference var) {
        logger.debug("Checking fields of " + var);
        try {
            if (var == null) {
                return;
            }
            Object object = var.getObject(scope);
            int position = statement.getPosition();
            if (!(object == null || object.getClass().isPrimitive() || object.getClass().isEnum() || PrimitiveFieldTraceObserver.isWrapperType(object.getClass()))) {
                PrimitiveFieldTraceEntry entry = new PrimitiveFieldTraceEntry(var);
                for (Field field : var.getVariableClass().getFields()) {
                    if (!Modifier.isPublic(field.getModifiers()) || field.getType().equals(Void.TYPE) || !field.getType().isPrimitive() || Modifier.isFinal(field.getModifiers()) || field.isSynthetic()) continue;
                    try {
                        logger.debug("Keeping field " + field + " with value " + field.get(object));
                        entry.addValue(field, field.get(object));
                    }
                    catch (IllegalArgumentException e) {
                    }
                    catch (IllegalAccessException e) {
                        // empty catch block
                    }
                }
                this.trace.addEntry(position, var, entry);
            }
        }
        catch (CodeUnderTestException e) {
            logger.debug("", e);
        }
    }

    @Override
    public void testExecutionFinished(ExecutionResult r) {
    }
}

