/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.assertion;

import java.lang.reflect.Modifier;
import java.util.regex.Pattern;
import org.evosuite.assertion.AssertionTraceObserver;
import org.evosuite.assertion.PrimitiveTraceEntry;
import org.evosuite.testcase.CodeUnderTestException;
import org.evosuite.testcase.ExecutionResult;
import org.evosuite.testcase.PrimitiveStatement;
import org.evosuite.testcase.Scope;
import org.evosuite.testcase.StatementInterface;
import org.evosuite.testcase.VariableReference;

public class PrimitiveTraceObserver
extends AssertionTraceObserver<PrimitiveTraceEntry> {
    private static Pattern addressPattern = Pattern.compile(".*[\\w+\\.]+@[abcdef\\d]+.*", 8);

    @Override
    public synchronized void afterStatement(StatementInterface statement, Scope scope, Throwable exception) {
        if (exception != null) {
            return;
        }
        this.visitReturnValue(statement, scope);
    }

    @Override
    protected void visit(StatementInterface statement, Scope scope, VariableReference var) {
        if (statement.isAssignmentStatement()) {
            return;
        }
        logger.debug("Checking primitive " + var);
        try {
            if (var == null) {
                return;
            }
            if (statement instanceof PrimitiveStatement) {
                return;
            }
            Object object = var.getObject(scope);
            if (object == null) {
                return;
            }
            if (object.getClass().isEnum() && !Modifier.isPublic(object.getClass().getModifiers())) {
                return;
            }
            if (object.getClass().isPrimitive() || object.getClass().isEnum() || PrimitiveTraceObserver.isWrapperType(object.getClass()) || object instanceof String) {
                if (object instanceof String) {
                    if (addressPattern.matcher((String)object).find()) {
                        return;
                    }
                    if (((String)object).length() >= Short.MAX_VALUE) {
                        return;
                    }
                }
                logger.debug("Observed value " + object + " for statement " + statement.getCode());
                this.trace.addEntry(statement.getPosition(), var, new PrimitiveTraceEntry(var, object));
            }
        }
        catch (CodeUnderTestException e) {
            logger.debug("", e);
        }
    }

    @Override
    public void testExecutionFinished(ExecutionResult r) {
    }
}

