/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.assertion;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.evosuite.assertion.Assertion;
import org.evosuite.assertion.OutputTraceEntry;
import org.evosuite.assertion.SameAssertion;
import org.evosuite.testcase.VariableReference;

public class SameTraceEntry
implements OutputTraceEntry {
    private final VariableReference var;
    private final Map<VariableReference, Boolean> equalityMap = new HashMap<VariableReference, Boolean>();

    public SameTraceEntry(VariableReference var) {
        this.var = var;
    }

    public void addEntry(VariableReference other, boolean value) {
        this.equalityMap.put(other, value);
    }

    @Override
    public boolean differs(OutputTraceEntry other) {
        if (other instanceof SameTraceEntry) {
            if (!((SameTraceEntry)other).var.equals(this.var)) {
                return false;
            }
            SameTraceEntry otherEntry = (SameTraceEntry)other;
            for (VariableReference otherVar : this.equalityMap.keySet()) {
                if (!otherEntry.equalityMap.containsKey(otherVar) || otherEntry.equalityMap.get(otherVar).equals(this.equalityMap.get(otherVar))) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Set<Assertion> getAssertions(OutputTraceEntry other) {
        HashSet<Assertion> assertions = new HashSet<Assertion>();
        if (other instanceof SameTraceEntry) {
            SameTraceEntry otherEntry = (SameTraceEntry)other;
            for (VariableReference otherVar : this.equalityMap.keySet()) {
                if (!otherEntry.equalityMap.containsKey(otherVar) || otherVar == null || otherEntry.equalityMap.get(otherVar).equals(this.equalityMap.get(otherVar))) continue;
                SameAssertion assertion = new SameAssertion();
                assertion.source = this.var;
                assertion.dest = otherVar;
                assertion.value = this.equalityMap.get(otherVar);
                assertions.add(assertion);
                assert (assertion.isValid());
            }
        }
        return assertions;
    }

    @Override
    public Set<Assertion> getAssertions() {
        HashSet<Assertion> assertions = new HashSet<Assertion>();
        for (VariableReference otherVar : this.equalityMap.keySet()) {
            if (otherVar == null) continue;
            SameAssertion assertion = new SameAssertion();
            assertion.source = this.var;
            assertion.dest = otherVar;
            assertion.value = this.equalityMap.get(otherVar);
            assertions.add(assertion);
            assert (assertion.isValid());
        }
        return assertions;
    }

    @Override
    public boolean isDetectedBy(Assertion assertion) {
        if (assertion instanceof SameAssertion) {
            SameAssertion ass = (SameAssertion)assertion;
            if (ass.source.equals(this.var) && this.equalityMap.containsKey(ass.dest)) {
                return !this.equalityMap.get(ass.dest).equals(ass.value);
            }
        }
        return false;
    }

    @Override
    public OutputTraceEntry cloneEntry() {
        SameTraceEntry copy = new SameTraceEntry(this.var);
        copy.equalityMap.putAll(this.equalityMap);
        return copy;
    }
}

