/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.assertion;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.evosuite.Properties;
import org.evosuite.assertion.Assertion;
import org.evosuite.assertion.AssertionGenerator;
import org.evosuite.assertion.ComparisonTraceEntry;
import org.evosuite.assertion.ComparisonTraceObserver;
import org.evosuite.assertion.InspectorTraceEntry;
import org.evosuite.assertion.InspectorTraceObserver;
import org.evosuite.assertion.NullTraceEntry;
import org.evosuite.assertion.NullTraceObserver;
import org.evosuite.assertion.OutputTrace;
import org.evosuite.assertion.PrimitiveAssertion;
import org.evosuite.assertion.PrimitiveFieldTraceEntry;
import org.evosuite.assertion.PrimitiveFieldTraceObserver;
import org.evosuite.assertion.PrimitiveTraceEntry;
import org.evosuite.assertion.PrimitiveTraceObserver;
import org.evosuite.assertion.SameTraceEntry;
import org.evosuite.assertion.SameTraceObserver;
import org.evosuite.coverage.mutation.Mutation;
import org.evosuite.coverage.mutation.MutationObserver;
import org.evosuite.coverage.mutation.MutationPool;
import org.evosuite.ga.stoppingconditions.MaxStatementsStoppingCondition;
import org.evosuite.rmi.ClientServices;
import org.evosuite.rmi.service.ClientState;
import org.evosuite.rmi.service.ClientStateInformation;
import org.evosuite.testcase.ExecutionResult;
import org.evosuite.testcase.StatementInterface;
import org.evosuite.testcase.StructuredTestCase;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.TestCaseExecutor;
import org.evosuite.testsuite.TestSuiteChromosome;
import org.evosuite.utils.Randomness;

public class StructuredAssertionGenerator
extends AssertionGenerator {
    private static PrimitiveTraceObserver primitiveObserver = new PrimitiveTraceObserver();
    private static ComparisonTraceObserver comparisonObserver = new ComparisonTraceObserver();
    private static SameTraceObserver sameObserver = new SameTraceObserver();
    private static InspectorTraceObserver inspectorObserver = new InspectorTraceObserver();
    private static PrimitiveFieldTraceObserver fieldObserver = new PrimitiveFieldTraceObserver();
    private static NullTraceObserver nullObserver = new NullTraceObserver();
    private static final Map<Mutation, Integer> timedOutMutations = new HashMap<Mutation, Integer>();
    protected static Class<?>[] observerClasses = new Class[]{PrimitiveTraceEntry.class, ComparisonTraceEntry.class, SameTraceEntry.class, InspectorTraceEntry.class, PrimitiveFieldTraceEntry.class, NullTraceEntry.class};

    public StructuredAssertionGenerator() {
        TestCaseExecutor.getInstance().newObservers();
        TestCaseExecutor.getInstance().addObserver(primitiveObserver);
        TestCaseExecutor.getInstance().addObserver(comparisonObserver);
        TestCaseExecutor.getInstance().addObserver(sameObserver);
        TestCaseExecutor.getInstance().addObserver(inspectorObserver);
        TestCaseExecutor.getInstance().addObserver(fieldObserver);
        TestCaseExecutor.getInstance().addObserver(nullObserver);
    }

    @Override
    public void addAssertions(TestSuiteChromosome suite) {
        long startTime = System.currentTimeMillis();
        int numTest = 0;
        for (TestCase test : suite.getTests()) {
            long currentTime = System.currentTimeMillis() / 1000L;
            if (currentTime - startTime > (long)Properties.ASSERTION_TIMEOUT) {
                logger.info("Reached maximum time to generate assertions!");
                break;
            }
            this.addAssertions(test);
            ClientState state = ClientState.ASSERTION_GENERATION;
            ClientStateInformation information = new ClientStateInformation(state);
            information.setProgress(100 * numTest++ / suite.size());
            ClientServices.getInstance().getClientNode().changeState(state, information);
        }
    }

    @Override
    public void addAssertions(TestCase test) {
        if (!(test instanceof StructuredTestCase)) {
            throw new IllegalArgumentException("Expecting StructuredTestCase");
        }
        StructuredTestCase structuredTest = (StructuredTestCase)test;
        Set<String> targetMethods = structuredTest.getTargetMethods();
        List<Mutation> mutants = MutationPool.getMutants();
        ExecutionResult origResult = this.runTest(test);
        HashMap<Mutation, ExecutionResult> mutationResults = new HashMap<Mutation, ExecutionResult>();
        for (Mutation mutant : mutants) {
            if (!origResult.getTrace().wasMutationTouched(mutant.getId()) || !targetMethods.contains(mutant.getMethodName())) continue;
            ExecutionResult mutationResult = this.runTest(test, mutant);
            mutationResults.put(mutant, mutationResult);
        }
        this.addAssertions(structuredTest, origResult, mutationResults);
    }

    private void minimizeAssertions(StructuredTestCase test, ExecutionResult origResult, Map<Mutation, ExecutionResult> mutationResults) {
        HashSet killedMutants = new HashSet();
        for (int position = test.size() - 1; position >= test.getFirstExerciseStatement(); --position) {
            boolean killsNew;
            StatementInterface statement = test.getStatement(position);
            if (!statement.hasAssertions()) continue;
            ArrayList<Assertion> assertions = new ArrayList<Assertion>(statement.getAssertions());
            Map<Integer, Set<Integer>> killMap = this.getKillMap(assertions, mutationResults);
            int num = 0;
            for (Assertion assertion : assertions) {
                if (assertion instanceof PrimitiveAssertion) {
                    killsNew = false;
                    for (Integer mutationId : killMap.get(num)) {
                        if (killedMutants.contains(mutationId)) continue;
                        killsNew = true;
                        break;
                    }
                    if (!killsNew) {
                        statement.removeAssertion(assertion);
                    } else {
                        killedMutants.addAll(killMap.get(num));
                    }
                }
                ++num;
            }
            for (int i = 0; i < assertions.size(); ++i) {
                Assertion assertion;
                if (!killMap.containsKey(i)) {
                    statement.removeAssertion((Assertion)assertions.get(i));
                    continue;
                }
                assertion = (Assertion)assertions.get(i);
                killsNew = false;
                for (Integer mutationId : killMap.get(i)) {
                    if (killedMutants.contains(mutationId)) continue;
                    killsNew = true;
                    break;
                }
                if (!killsNew) {
                    statement.removeAssertion(assertion);
                    continue;
                }
                killedMutants.addAll(killMap.get(i));
            }
            if (statement.hasAssertions()) continue;
            boolean addedPrimitive = false;
            for (Assertion assertion : assertions) {
                if (!(assertion instanceof PrimitiveAssertion)) continue;
                statement.addAssertion(assertion);
                addedPrimitive = true;
            }
            if (addedPrimitive) continue;
            statement.addAssertion(Randomness.choice(assertions));
        }
    }

    private Map<Integer, Set<Integer>> getKillMap(List<Assertion> assertions, Map<Mutation, ExecutionResult> mutationResults) {
        HashMap<Integer, Set<Integer>> killMap = new HashMap<Integer, Set<Integer>>();
        int num = 0;
        for (Assertion assertion : assertions) {
            HashSet<Integer> killedMutations = new HashSet<Integer>();
            for (Mutation m : mutationResults.keySet()) {
                boolean isKilled = false;
                for (OutputTrace<?> trace : mutationResults.get(m).getTraces()) {
                    if (!trace.isDetectedBy(assertion)) continue;
                    isKilled = true;
                    break;
                }
                if (!isKilled) continue;
                killedMutations.add(m.getId());
                assertion.addKilledMutation(m);
            }
            killMap.put(num, killedMutations);
            ++num;
        }
        return killMap;
    }

    private int addAssertions(StructuredTestCase test, ExecutionResult origResult, Map<Mutation, ExecutionResult> mutationResults) {
        int numKilled = 0;
        for (Class<?> observerClass : observerClasses) {
            if (origResult.getTrace(observerClass) == null) continue;
            for (int i = 0; i < test.size(); ++i) {
                if (!test.isExerciseStatement(i)) continue;
                origResult.getTrace(observerClass).getAllAssertions(test, i);
            }
        }
        this.minimizeAssertions(test, origResult, mutationResults);
        return numKilled;
    }

    @Override
    protected ExecutionResult runTest(TestCase test) {
        return this.runTest(test, null);
    }

    private ExecutionResult runTest(TestCase test, Mutation mutant) {
        ExecutionResult result = new ExecutionResult(test, mutant);
        comparisonObserver.clear();
        sameObserver.clear();
        primitiveObserver.clear();
        inspectorObserver.clear();
        fieldObserver.clear();
        nullObserver.clear();
        try {
            logger.debug("Executing test");
            MutationObserver.activateMutation(mutant);
            result = TestCaseExecutor.getInstance().execute(test);
            MutationObserver.deactivateMutation(mutant);
            int num = test.size();
            MaxStatementsStoppingCondition.statementsExecuted(num);
            result.setTrace(comparisonObserver.getTrace(), ComparisonTraceEntry.class);
            result.setTrace(sameObserver.getTrace(), SameTraceEntry.class);
            result.setTrace(primitiveObserver.getTrace(), PrimitiveTraceEntry.class);
            result.setTrace(inspectorObserver.getTrace(), InspectorTraceEntry.class);
            result.setTrace(fieldObserver.getTrace(), PrimitiveFieldTraceEntry.class);
            result.setTrace(nullObserver.getTrace(), NullTraceEntry.class);
        }
        catch (Exception e) {
            throw new Error(e);
        }
        return result;
    }
}

