/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.assertion;

import org.evosuite.Properties;
import org.evosuite.assertion.AssertionGenerator;
import org.evosuite.assertion.OutputTrace;
import org.evosuite.testcase.ExecutionResult;
import org.evosuite.testcase.MethodStatement;
import org.evosuite.testcase.StatementInterface;
import org.evosuite.testcase.TestCase;

public class UnitAssertionGenerator
extends AssertionGenerator {
    private boolean isRelevant(StatementInterface s, TestCase t) {
        if (s.getPosition() == t.size() - 1) {
            return true;
        }
        if (s instanceof MethodStatement) {
            MethodStatement ms = (MethodStatement)s;
            String declaringClass = ms.getMethod().getDeclaringClass().getName();
            while (declaringClass.contains("$")) {
                declaringClass = declaringClass.substring(0, declaringClass.indexOf("$"));
            }
            if (declaringClass.equals(Properties.TARGET_CLASS) || !Properties.TARGET_CLASS_PREFIX.isEmpty() && declaringClass.startsWith(Properties.TARGET_CLASS_PREFIX)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void addAssertions(TestCase test) {
        ExecutionResult result = this.runTest(test);
        for (OutputTrace<?> trace : result.getTraces()) {
            trace.getAllAssertions(test);
        }
        for (int i = 0; i < test.size(); ++i) {
            StatementInterface s = test.getStatement(i);
            if (this.isRelevant(s, test)) continue;
            s.removeAssertions();
        }
    }
}

