/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.classpath;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.evosuite.classpath.ClassPathHandler;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceList {
    private static Logger logger = LoggerFactory.getLogger(ResourceList.class);
    private static Cache cache;

    public static void resetCache() {
        cache = null;
    }

    public static boolean hasClass(String className) {
        return ResourceList.getCache().mapClassToCP.containsKey(className);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static InputStream getClassAsStream(String name) {
        String path = name.replace('.', '/') + ".class";
        String windowsPath = name.replace(".", "\\") + ".class";
        InputStream is = ClassLoader.getSystemResourceAsStream(path);
        if (is != null) {
            return is;
        }
        if (File.separatorChar != '/' && (is = ClassLoader.getSystemResourceAsStream(windowsPath)) != null) {
            return is;
        }
        String cpEntry = ResourceList.getCache().mapClassToCP.get(name);
        if (cpEntry == null) {
            if (ResourceList.getCache().missingClasses.contains(name)) return null;
            ResourceList.getCache().missingClasses.add(name);
            logger.debug("The class " + name + " is not on the classpath");
            return null;
        }
        if (cpEntry.endsWith(".jar")) {
            try (JarFile jar = new JarFile(cpEntry);){
                JarEntry entry = jar.getJarEntry(path);
                if (entry == null) {
                    logger.error("Error: could not find " + path + " inside of jar file " + cpEntry);
                    InputStream inputStream2 = null;
                    return inputStream2;
                }
                InputStream inputStream = jar.getInputStream(entry);
                return inputStream;
            }
            catch (IOException e) {
                logger.error("Error while reading jar file " + cpEntry + ": " + e.getMessage(), e);
                return null;
            }
        }
        File classFile = null;
        classFile = File.separatorChar != '/' ? new File(cpEntry + File.separator + windowsPath) : new File(cpEntry + File.separator + path);
        if (!classFile.exists()) {
            logger.error("Could not find " + classFile);
        }
        try {
            return new FileInputStream(classFile);
        }
        catch (FileNotFoundException e) {
            logger.error("Error while trying to open stream on: " + classFile.getAbsolutePath());
            return null;
        }
    }

    public static Set<String> getAllClasses(String classPathEntry, boolean includeAnonymousClasses) {
        return ResourceList.getAllClasses(classPathEntry, "", includeAnonymousClasses);
    }

    public static Set<String> getAllClasses(String classPathEntry, String prefix, boolean includeAnonymousClasses) {
        if (classPathEntry.contains(File.pathSeparator)) {
            LinkedHashSet<String> retval = new LinkedHashSet<String>();
            for (String element : classPathEntry.split(File.pathSeparator)) {
                retval.addAll(ResourceList.getAllClasses(element, prefix, includeAnonymousClasses));
            }
            return retval;
        }
        classPathEntry = new File(classPathEntry).getAbsolutePath();
        ResourceList.addEntry(classPathEntry);
        Set<String> cps = ResourceList.getCache().mapPrefixToCPs.get(prefix);
        if (cps == null || !cps.contains(classPathEntry)) {
            return Collections.emptySet();
        }
        LinkedHashSet<String> classes = new LinkedHashSet<String>();
        for (String className : ResourceList.getCache().mapCPtoClasses.get(classPathEntry)) {
            if (!className.startsWith(prefix) || !includeAnonymousClasses && className.contains("$")) continue;
            classes.add(className);
        }
        return classes;
    }

    public static boolean isInterface(String resource) throws IOException {
        InputStream input = ResourceList.class.getClassLoader().getResourceAsStream(resource);
        return ResourceList.isClassAnInterface(input);
    }

    public static boolean isClassAnInterface(String className) throws IOException {
        InputStream input = ResourceList.getClassAsStream(className);
        return ResourceList.isClassAnInterface(input);
    }

    public static boolean isClassDeprecated(String className) throws IOException {
        InputStream input = ResourceList.getClassAsStream(className);
        return ResourceList.isClassDeprecated(input);
    }

    public static boolean isClassTestable(String className) throws IOException {
        InputStream input = ResourceList.getClassAsStream(className);
        return ResourceList.isClassTestable(input);
    }

    public static String getClassNameFromResourcePath(String resource) {
        if (resource == null || resource.isEmpty()) {
            return resource;
        }
        String CLASS = ".class";
        if (resource.endsWith(".class")) {
            resource = resource.substring(0, resource.length() - ".class".length());
        }
        resource = resource.replace('/', '.');
        if (File.separatorChar != '/') {
            resource = resource.replace(File.separatorChar, '.');
        }
        return resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isClassAnInterface(InputStream input) throws IOException {
        try {
            ClassReader reader = new ClassReader(input);
            ClassNode cn = new ClassNode();
            reader.accept(cn, 4);
            boolean bl = (cn.access & 0x200) == 512;
            return bl;
        }
        finally {
            input.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isClassDeprecated(InputStream input) throws IOException {
        try {
            ClassReader reader = new ClassReader(input);
            ClassNode cn = new ClassNode();
            reader.accept(cn, 4);
            boolean bl = (cn.access & 0x20000) == 131072;
            return bl;
        }
        finally {
            input.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isClassTestable(InputStream input) throws IOException {
        try {
            ClassReader reader = new ClassReader(input);
            ClassNode cn = new ClassNode();
            reader.accept(cn, 4);
            List l = cn.methods;
            for (MethodNode m : l) {
                if ((m.access & 1) != 1) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            input.close();
        }
    }

    protected static String getParentPackageName(String className) {
        if (className == null || className.isEmpty()) {
            return className;
        }
        int index = className.lastIndexOf(46);
        if (index < 0) {
            return "";
        }
        return className.substring(0, index);
    }

    private static Cache getCache() {
        if (cache == null) {
            ResourceList.initCache();
        }
        return cache;
    }

    private static void initCache() {
        cache = new Cache();
        String cp = ClassPathHandler.getInstance().getTargetProjectClasspath();
        for (String entry : cp.split(File.pathSeparator)) {
            ResourceList.addEntry(entry);
        }
    }

    private static void addEntry(String classPathElement) throws IllegalArgumentException {
        File file = new File(classPathElement);
        if (ResourceList.getCache().mapCPtoClasses.containsKey(classPathElement = file.getAbsolutePath())) {
            return;
        }
        ResourceList.getCache().mapCPtoClasses.put(classPathElement, new LinkedHashSet());
        if (!file.exists()) {
            throw new IllegalArgumentException("The class path resource " + file.getAbsolutePath() + " does not exist");
        }
        if (file.isDirectory()) {
            ResourceList.scanDirectory(file, classPathElement);
        } else if (file.getName().endsWith(".jar")) {
            ResourceList.scanJar(classPathElement);
        } else {
            throw new IllegalArgumentException("The class path resource " + file.getAbsolutePath() + " is not valid");
        }
    }

    private static void scanDirectory(File directory, String classPathFolder) {
        File[] fileList;
        if (!directory.exists()) {
            return;
        }
        if (!directory.isDirectory()) {
            return;
        }
        if (!directory.canRead()) {
            logger.warn("No permission to read: " + directory.getAbsolutePath());
            return;
        }
        String prefix = directory.getAbsolutePath().replace(classPathFolder + File.separator, "");
        prefix = prefix.replace(File.separatorChar, '.');
        for (File file : fileList = directory.listFiles()) {
            if (file.isDirectory()) {
                ResourceList.scanDirectory(file, classPathFolder);
                continue;
            }
            if (!file.getName().endsWith(".class")) continue;
            String relativeFilePath = file.getAbsolutePath().replace(classPathFolder + File.separator, "");
            String className = ResourceList.getClassNameFromResourcePath(relativeFilePath);
            ResourceList.getCache().mapClassToCP.put(className, classPathFolder);
            ResourceList.getCache().mapCPtoClasses.get(classPathFolder).add(className);
            ResourceList.getCache().addPrefix(prefix, classPathFolder);
        }
    }

    private static void scanJar(String jarEntry) {
        JarFile zf;
        try {
            zf = new JarFile(jarEntry);
        }
        catch (Exception e) {
            throw new Error(e);
        }
        Enumeration<JarEntry> e = zf.entries();
        while (e.hasMoreElements()) {
            JarEntry ze = e.nextElement();
            String entryName = ze.getName();
            if (!entryName.endsWith(".class")) continue;
            String className = ResourceList.getClassNameFromResourcePath(entryName);
            ResourceList.getCache().mapClassToCP.put(className, jarEntry);
            ResourceList.getCache().mapCPtoClasses.get(jarEntry).add(className);
            ResourceList.getCache().addPrefix(ResourceList.getParentPackageName(className), jarEntry);
        }
        try {
            zf.close();
        }
        catch (IOException e1) {
            throw new Error(e1);
        }
    }

    private static class Cache {
        public Map<String, Set<String>> mapCPtoClasses = new LinkedHashMap<String, Set<String>>();
        public Map<String, String> mapClassToCP = new LinkedHashMap<String, String>();
        public Map<String, Set<String>> mapPrefixToCPs = new LinkedHashMap<String, Set<String>>();
        public Set<String> missingClasses = new LinkedHashSet<String>();

        private Cache() {
        }

        public void addPrefix(String prefix, String cpEntry) {
            Set<String> classPathEntries = this.mapPrefixToCPs.get(prefix);
            if (classPathEntries == null) {
                classPathEntries = new LinkedHashSet<String>();
                this.mapPrefixToCPs.put(prefix, classPathEntries);
            }
            classPathEntries.add(cpEntry);
            if (!prefix.isEmpty()) {
                String parent = ResourceList.getParentPackageName(prefix);
                this.addPrefix(parent, cpEntry);
            }
        }
    }
}

