/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.continuous;

import java.util.List;
import org.evosuite.Properties;
import org.evosuite.continuous.CtgConfiguration;
import org.evosuite.continuous.job.JobDefinition;
import org.evosuite.continuous.job.JobExecutor;
import org.evosuite.continuous.job.JobScheduler;
import org.evosuite.continuous.persistency.StorageManager;
import org.evosuite.continuous.project.ProjectAnalyzer;
import org.evosuite.continuous.project.ProjectStaticData;
import org.evosuite.xsd.ProjectInfo;

public class ContinuousTestGeneration {
    private final String target;
    private final String prefix;
    private final String projectClassPath;
    private CtgConfiguration configuration;
    private String[] cuts;

    public ContinuousTestGeneration(String target, String projectClassPath, String prefix, CtgConfiguration conf, String[] cuts) {
        this.target = target;
        this.prefix = prefix;
        this.projectClassPath = projectClassPath;
        this.configuration = conf;
        this.cuts = cuts;
    }

    public String execute() {
        StorageManager storage = new StorageManager();
        boolean storageOK = storage.openForWriting();
        if (!storageOK) {
            return "Failed to initialize local storage system";
        }
        storageOK = storage.createNewTmpFolders();
        if (!storageOK) {
            return "Failed to create tmp folders";
        }
        ProjectAnalyzer analyzer = new ProjectAnalyzer(this.target, this.prefix, this.cuts);
        ProjectStaticData data = analyzer.analyze();
        if (data.getTotalNumberOfTestableCUTs() == 0) {
            return "There is no class to test in the chosen project\nTarget: " + this.target + "\n" + "Prefix: '" + this.prefix + "'\n";
        }
        if (Properties.CTG_TIME_PER_CLASS != null) {
            this.configuration = this.configuration.getWithChangedTime(Properties.CTG_TIME_PER_CLASS, data.getTotalNumberOfTestableCUTs());
        }
        JobScheduler scheduler = new JobScheduler(data, this.configuration);
        JobExecutor executor = new JobExecutor(storage, this.projectClassPath, this.configuration);
        while (scheduler.canExecuteMore()) {
            List<JobDefinition> jobs = scheduler.createNewSchedule();
            executor.executeJobs(jobs, this.configuration.getNumberOfUsableCores());
            executor.waitForJobs();
        }
        String description = storage.mergeAndCommitChanges(data);
        if (this.configuration.callHome) {
            // empty if block
        }
        return description;
    }

    public boolean clean() {
        StorageManager storage = new StorageManager();
        return storage.clean();
    }

    public String info() {
        StorageManager storage = new StorageManager();
        ProjectInfo projectInfo = storage.getDatabaseProjectInfo();
        if (projectInfo == null) {
            return "No info available";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Total number of classes in the project: " + projectInfo.getTotalNumberOfClasses() + "\n");
        sb.append("Number of classes in the project that are testable: " + projectInfo.getTotalNumberOfTestableClasses() + "\n");
        sb.append("Number of generated test suites: " + projectInfo.getGeneratedTestSuites().size() + "\n");
        sb.append("Average branch coverage: " + projectInfo.getAverageBranchCoverage() + "\n");
        return sb.toString();
    }
}

