/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.continuous.job;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.evosuite.EvoSuite;
import org.evosuite.Properties;
import org.evosuite.continuous.job.JobDefinition;
import org.evosuite.continuous.job.JobExecutor;
import org.evosuite.continuous.persistency.StorageManager;
import org.evosuite.statistics.RuntimeVariable;
import org.evosuite.utils.LoggingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobHandler
extends Thread {
    private static Logger logger = LoggerFactory.getLogger(JobHandler.class);
    private final JobExecutor executor;
    private Process latestProcess;

    public JobHandler(JobExecutor executor) {
        this.executor = executor;
    }

    public void setUpShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                if (JobHandler.this.latestProcess != null) {
                    JobHandler.this.latestProcess.destroy();
                }
            }
        });
    }

    public static JobHandler[] getPool(int n, JobExecutor executor) {
        JobHandler[] jobs = new JobHandler[n];
        for (int i = 0; i < jobs.length; ++i) {
            jobs[i] = new JobHandler(executor);
            jobs[i].setUpShutdownHook();
        }
        return jobs;
    }

    public void stopExecution() {
        this.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.isInterrupted()) {
            JobDefinition job = null;
            try {
                job = this.executor.pollJob();
            }
            catch (InterruptedException e) {
                break;
            }
            List<String> commands = this.getCommandString(job);
            Process process = null;
            try {
                String baseDir = System.getProperty("user.dir");
                File dir = new File(baseDir);
                String[] parsedCommand = new String[commands.size()];
                commands.toArray(parsedCommand);
                ProcessBuilder builder = new ProcessBuilder(parsedCommand);
                builder.directory(dir);
                builder.redirectErrorStream(true);
                LoggingUtils.getEvoLogger().info("Going to start job for: " + job.cut);
                logger.debug("Base directory: " + baseDir);
                logger.debug("Commands: " + Arrays.asList(parsedCommand));
                this.latestProcess = process = builder.start();
                int exitCode = process.waitFor();
                if (exitCode == 0) continue;
                this.handleProcessError(job, process);
            }
            catch (IOException e) {
                logger.error("Failed to start new job: " + e.getMessage(), e);
            }
            catch (InterruptedException e) {
                this.interrupt();
                if (process == null) continue;
                process.destroy();
            }
            finally {
                this.executor.doneWithJob(job);
            }
        }
    }

    private void handleProcessError(JobDefinition job, Process process) throws IOException {
        StringBuffer sb = new StringBuffer();
        BufferedReader in = new BufferedReader(new InputStreamReader(process.getInputStream()));
        int data = 0;
        while (data != -1 && !this.isInterrupted()) {
            data = in.read();
            if (data == -1) continue;
            sb.append((char)data);
        }
        logger.warn("Job ended with erroneous exit code: " + job.cut + "\nProcess console output:\n" + sb.toString());
    }

    private List<String> getCommandString(JobDefinition job) {
        ArrayList<String> commands = new ArrayList<String>();
        commands.add("java");
        String classpath = System.getProperty("java.class.path");
        commands.add("-cp");
        commands.add(classpath + File.pathSeparator + this.executor.getProjectClassPath());
        commands.add("-Duse_different_logback=logback-ctg.xml");
        StorageManager storage = this.executor.getStorage();
        File logs = storage.getTmpLogs();
        commands.add("-Devosuite.log.folder=" + logs.getAbsolutePath() + "/" + job.cut);
        if (Properties.LOG_LEVEL != null && !Properties.LOG_LEVEL.isEmpty()) {
            commands.add("-Dlog.level=" + Properties.LOG_LEVEL);
        }
        int masterMB = 250;
        int clientMB = job.memoryInMB - masterMB;
        commands.add("-Xmx" + masterMB + "m");
        commands.add(EvoSuite.class.getName());
        commands.add("-mem");
        commands.add("" + clientMB);
        commands.add("-class");
        commands.add(job.cut);
        commands.add("-projectCP");
        commands.add(this.executor.getProjectClassPath());
        if (Properties.LOG_LEVEL != null && !Properties.LOG_LEVEL.isEmpty()) {
            commands.add("-Dlog.level=" + Properties.LOG_LEVEL);
        }
        if (Properties.LOG_TARGET != null && !Properties.LOG_TARGET.isEmpty()) {
            commands.add("-Dlog.target=" + Properties.LOG_TARGET);
        }
        commands.addAll(this.getPoolInfo(job));
        commands.addAll(this.timeSetUp(job.seconds));
        File reports = storage.getTmpReports();
        File tests = storage.getTmpTests();
        commands.add("-Dreport_dir=" + reports.getAbsolutePath() + "/" + job.cut);
        commands.add("-Dtest_dir=" + tests.getAbsolutePath());
        commands.add("-Dcriterion=" + (Object)((Object)Properties.Criterion.LINE) + ":" + (Object)((Object)Properties.Criterion.BRANCH) + ":" + (Object)((Object)Properties.Criterion.EXCEPTION));
        commands.add("-Dtest_factory=" + (Object)((Object)Properties.TEST_FACTORY));
        commands.add("-Dseed_clone=" + Properties.SEED_CLONE);
        commands.add("-Dseed_dir=" + storage.getTmpSeeds().getAbsolutePath());
        commands.addAll(this.getOutputVariables());
        commands.add("-Djunit_suffix=" + Properties.JUNIT_SUFFIX);
        commands.add("-Denable_asserts_for_evosuite=" + Properties.ENABLE_ASSERTS_FOR_EVOSUITE);
        String confId = Properties.CONFIGURATION_ID;
        if (confId != null && !confId.isEmpty()) {
            commands.add("-Dconfiguration_id=" + confId);
        } else {
            commands.add("-Dconfiguration_id=default");
        }
        if (Properties.RANDOM_SEED != null) {
            commands.add("-Drandom_seed=" + Properties.RANDOM_SEED);
        }
        commands.add("-Dprint_to_system=" + Properties.PRINT_TO_SYSTEM);
        commands.add("-Dp_object_pool=" + Properties.P_OBJECT_POOL);
        commands.add("-Dminimize=" + Properties.MINIMIZE);
        commands.add("-Dassertions=" + Properties.ASSERTIONS);
        commands.add("-Dmax_size=" + Properties.MAX_SIZE);
        commands.add("-Dsecondary_objectives=totallength");
        commands.add("-Dtimeout=5000");
        commands.add("-Dhtml=false");
        commands.add("-Dlog_timeout=false");
        commands.add("-Dplot=false");
        commands.add("-Djunit_tests=true");
        commands.add("-Dtest_comments=false");
        commands.add("-Dshow_progress=false");
        commands.add("-Dsave_all_data=false");
        commands.add("-Dinline=false");
        commands.add("-Dreset_static_fields=true");
        commands.add("-Dreplace_calls=true");
        if (!Properties.CTG_HISTORY_FILE.isEmpty()) {
            commands.add("-Dctg_history_file=" + Properties.CTG_HISTORY_FILE);
        }
        return commands;
    }

    private List<String> getPoolInfo(JobDefinition job) {
        ArrayList<String> commands = new ArrayList<String>();
        StorageManager storage = this.executor.getStorage();
        File poolFolder = storage.getTmpPools();
        String extension = ".pool";
        commands.add("-Dwrite_pool=" + poolFolder.getAbsolutePath() + File.separator + job.cut + extension);
        if (job.inputClasses != null && job.inputClasses.size() > 0) {
            String[] dep = job.inputClasses.toArray(new String[0]);
            double poolP = 0.5;
            if (Properties.P_OBJECT_POOL > 0.0) {
                poolP = Properties.P_OBJECT_POOL;
            }
            commands.add("-Dp_object_pool=" + poolP);
            String cmd = "-Dobject_pools=";
            cmd = cmd + poolFolder.getAbsolutePath() + File.separator + dep[0] + extension;
            for (int i = 1; i < dep.length; ++i) {
                cmd = cmd + File.pathSeparator + poolFolder.getAbsolutePath() + File.separator + dep[i] + extension;
            }
            commands.add(cmd);
        }
        return commands;
    }

    private List<String> getOutputVariables() {
        ArrayList<String> commands = new ArrayList<String>();
        String cmd = "-Doutput_variables=";
        cmd = cmd + "TARGET_CLASS,configuration_id,";
        cmd = cmd + "ctg_min_time_per_job,ctg_schedule,search_budget,p_object_pool,";
        cmd = cmd + (Object)((Object)RuntimeVariable.Covered_Branches) + ",";
        cmd = cmd + (Object)((Object)RuntimeVariable.Total_Branches) + ",";
        cmd = cmd + (Object)((Object)RuntimeVariable.BranchCoverage) + ",";
        cmd = cmd + (Object)((Object)RuntimeVariable.Size) + ",";
        cmd = cmd + (Object)((Object)RuntimeVariable.Length) + ",";
        cmd = cmd + (Object)((Object)RuntimeVariable.Statements_Executed) + ",";
        cmd = cmd + (Object)((Object)RuntimeVariable.Total_Time) + ",";
        cmd = cmd + (Object)((Object)RuntimeVariable.Implicit_MethodExceptions) + ",";
        cmd = cmd + (Object)((Object)RuntimeVariable.Random_Seed) + ",";
        cmd = cmd + (Object)((Object)RuntimeVariable.Explicit_MethodExceptions);
        if (Properties.CTG_TIME_PER_CLASS != null) {
            cmd = cmd + ",ctg_time_per_class";
        }
        commands.add(cmd);
        if (Properties.CTG_TIME_PER_CLASS != null) {
            commands.add("-Dctg_time_per_class=" + Properties.CTG_TIME_PER_CLASS);
        }
        commands.add("-startedByCtg");
        commands.add("-Dctg_schedule=" + (Object)((Object)Properties.CTG_SCHEDULE));
        commands.add("-Dctg_min_time_per_job=" + Properties.CTG_MIN_TIME_PER_JOB);
        return commands;
    }

    private List<String> timeSetUp(int seconds) {
        int minSecondsPerJob;
        int remaining = (int)this.executor.getRemainingTimeInMs() / 1000;
        if (seconds > remaining) {
            seconds = remaining;
        }
        if (seconds < (minSecondsPerJob = 60 * this.executor.configuration.minMinutesPerJob)) {
            seconds = minSecondsPerJob;
        }
        int PHASES = 5;
        int initialization = seconds / 5;
        int minimization = seconds / 5;
        int assertions = seconds / 5;
        int extra = seconds / 5;
        int MAJOR_DELTA = 120;
        int MINOR_DELTA = 60;
        if (seconds > 600) {
            initialization = 120;
            minimization = 120;
            assertions = 120;
            extra = 120;
        } else if (seconds > 300) {
            initialization = 60;
            minimization = 60;
            assertions = 60;
            extra = 60;
        }
        int search = seconds - (initialization + minimization + assertions + extra);
        ArrayList<String> commands = new ArrayList<String>();
        commands.add("-Dsearch_budget=" + search);
        commands.add("-Dglobal_timeout=" + search);
        commands.add("-Dstopping_condition=" + (Object)((Object)Properties.StoppingCondition.MAXTIME));
        commands.add("-Dinitialization_timeout=" + initialization);
        commands.add("-Dminimization_timeout=" + minimization);
        commands.add("-Dassertion_timeout=" + assertions);
        commands.add("-Dextra_timeout=" + extra);
        return commands;
    }
}

